/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.oaipmh;

import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import org.gcube.application.framework.oaipmh.constants.ResponseConstants;
import org.gcube.application.framework.oaipmh.exceptions.MissingRequestParameters;
import org.gcube.application.framework.oaipmh.objectmappers.Identifier;
import org.gcube.application.framework.oaipmh.objectmappers.Record;
import org.gcube.application.framework.oaipmh.objectmappers.Repository;
import org.gcube.application.framework.oaipmh.tools.ElementGenerator;
import org.gcube.application.framework.oaipmh.tools.Toolbox;
import org.gcube.application.framework.oaipmh.verbcontainers.ErrorParam;
import org.gcube.application.framework.oaipmh.verbcontainers.GetRecord;
import org.gcube.application.framework.oaipmh.verbcontainers.Identify;
import org.gcube.application.framework.oaipmh.verbcontainers.ListIdentifiers;
import org.gcube.application.framework.oaipmh.verbcontainers.ListMetadataFormats;
import org.gcube.application.framework.oaipmh.verbcontainers.ListRecords;
import org.gcube.application.framework.oaipmh.verbcontainers.ListSets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class Response {
    private static final Logger logger = LoggerFactory.getLogger(Response.class);
    private Date responseDate;
    private String verb;
    private String verbResponse;

    public String getIdentifyResponse(Properties requestProps, Repository repository) throws MissingRequestParameters, TransformerException {
        Element oaipmh = this.getResponseElement(requestProps, repository);
        oaipmh.appendChild(Identify.formulateIdentifyElement(repository));
        return ElementGenerator.domToXML(oaipmh);
    }

    public String getListMetadataFormatsResponse(Properties requestProps, Repository repository) throws MissingRequestParameters, TransformerException {
        Element oaipmh = this.getResponseElement(requestProps, repository);
        oaipmh.appendChild(ListMetadataFormats.formulateMetadataFormatsElement(repository));
        return ElementGenerator.domToXML(oaipmh);
    }

    public String getListSetsResponse(Properties requestProps, Repository repository) throws MissingRequestParameters, TransformerException {
        Element oaipmh = this.getResponseElement(requestProps, repository);
        oaipmh.appendChild(ListSets.formulateListSetsElement(repository));
        return ElementGenerator.domToXML(oaipmh);
    }

    public String getGetRecordResponse(Properties requestProps, Repository repository, Record record) throws MissingRequestParameters, TransformerException {
        Element oaipmh = this.getResponseElement(requestProps, repository);
        oaipmh.appendChild(GetRecord.formulateGetRecordElement(record));
        return ElementGenerator.domToXML(oaipmh);
    }

    public String getListRecordsResponse(Properties requestProps, Repository repository, ArrayList<Record> records, int cursor, int total) throws MissingRequestParameters, TransformerException {
        Element oaipmh = this.getResponseElement(requestProps, repository);
        oaipmh.appendChild(ListRecords.formulateListRecordsElement(records, cursor, total));
        return ElementGenerator.domToXML(oaipmh);
    }

    public String getListIdentifiersResponse(Properties requestProps, Repository repository, ArrayList<Identifier> identifiers, int cursor, int total) throws MissingRequestParameters, TransformerException {
        Element oaipmh = this.getResponseElement(requestProps, repository);
        oaipmh.appendChild(ListIdentifiers.formulateListIdentifiersElement(identifiers, cursor, total));
        return ElementGenerator.domToXML(oaipmh);
    }

    public String getErrorResponse(Properties requestProps, Repository repository, String errorMessage) throws TransformerException, MissingRequestParameters {
        Element oaipmh = this.getResponseElement(requestProps, repository);
        oaipmh.appendChild(ErrorParam.formulateErrorElement(errorMessage));
        return ElementGenerator.domToXML(oaipmh);
    }

    private Element getResponseElement(Properties requestProps, Repository repository) throws MissingRequestParameters {
        if (!this.checkMinimumMappings(requestProps)) {
            throw new MissingRequestParameters("A required parameter was missing");
        }
        Element oaipmh = ElementGenerator.getDocument().createElement("OAI-PMH");
        for (Object key : ResponseConstants.getHeaderProps().keySet()) {
            oaipmh.setAttribute((String)key, (String)ResponseConstants.getHeaderProps().get(key));
        }
        Element respDate = ElementGenerator.getDocument().createElement("responseDate");
        respDate.appendChild(ElementGenerator.getDocument().createTextNode(Toolbox.dateTimeNow()));
        oaipmh.appendChild(respDate);
        this.verb = requestProps.getProperty("verb");
        Element req = ElementGenerator.getDocument().createElement("request");
        req.setAttribute("verb", this.verb);
        req.appendChild(ElementGenerator.getDocument().createTextNode(repository.getBaseURL()));
        oaipmh.appendChild(req);
        return oaipmh;
    }

    private boolean checkMinimumMappings(Properties requestProps) {
        return requestProps.containsKey("verb");
    }
}

