/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.oaipmh.objectmappers;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;
import javax.xml.transform.TransformerException;
import org.gcube.application.framework.oaipmh.constants.MetadataConstants;
import org.gcube.application.framework.oaipmh.objectmappers.CustomMetadataXSD;
import org.gcube.application.framework.oaipmh.objectmappers.OAIDCMetadataXSD;
import org.gcube.application.framework.oaipmh.objectmappers.RecordTemplateCustom;
import org.gcube.application.framework.oaipmh.objectmappers.RecordTemplateDC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Repository {
    private static final Logger logger = LoggerFactory.getLogger(Repository.class);
    private String name;
    private String baseURL;
    private ArrayList<String> adminEmail;
    private Date earliestDatestamp;
    private String deletedRecord;
    private String granularity;
    private String protocolVersion;
    private ArrayList<String> supportedMetadataPrefixes;
    private CustomMetadataXSD customMetadataXSD;
    private OAIDCMetadataXSD oaiDcMetadataXSD;
    private RecordTemplateCustom recordTemplateCustom;
    private RecordTemplateDC recordTemplateDC;
    private Properties sets;

    public Repository(String name, String baseURL, ArrayList<String> adminEmail, Date earliestDatestamp, RecordTemplateDC recordTemplateDC, RecordTemplateCustom recordTemplateCustom, Properties sets) throws MalformedURLException {
        if (this.supportedMetadataPrefixes == null) {
            this.supportedMetadataPrefixes = new ArrayList();
        }
        this.granularity = "YYYY-MM-DD";
        this.name = name;
        this.baseURL = baseURL;
        this.adminEmail = adminEmail;
        this.deletedRecord = "no";
        this.protocolVersion = "2.0";
        this.earliestDatestamp = earliestDatestamp;
        this.oaiDcMetadataXSD = new OAIDCMetadataXSD();
        if (recordTemplateDC != null) {
            this.supportedMetadataPrefixes.add("oai_dc");
            this.recordTemplateDC = recordTemplateDC;
        }
        this.supportedMetadataPrefixes.add("custom");
        this.recordTemplateCustom = recordTemplateCustom;
        URL url = new URL(baseURL);
        this.customMetadataXSD = new CustomMetadataXSD(name, url.getHost(), url.getPort());
        if (sets == null || sets.isEmpty()) {
            this.sets = new Properties();
            this.sets.put(name, "Single set which contains all records of the repository");
        } else {
            this.sets = sets;
        }
    }

    public Repository(String name, String baseURL, ArrayList<String> adminEmail, Date earliestDatestamp, RecordTemplateDC recordTemplateDC, Properties sets) throws MalformedURLException {
        if (this.supportedMetadataPrefixes == null) {
            this.supportedMetadataPrefixes = new ArrayList();
        }
        this.granularity = "YYYY-MM-DD";
        this.name = name;
        this.baseURL = baseURL;
        this.adminEmail = adminEmail;
        this.deletedRecord = "no";
        this.protocolVersion = "2.0";
        this.earliestDatestamp = earliestDatestamp;
        this.supportedMetadataPrefixes.add(MetadataConstants.DCNAME);
        this.recordTemplateDC = recordTemplateDC;
        this.oaiDcMetadataXSD = new OAIDCMetadataXSD();
        if (sets == null || sets.isEmpty()) {
            this.sets = new Properties();
            this.sets.put(name, "Single set which contains all records of the repository");
        } else {
            this.sets = sets;
        }
    }

    public Repository(String name, String baseURL, ArrayList<String> adminEmail, Date earliestDatestamp, RecordTemplateCustom recordTemplateCustom, Properties sets) throws MalformedURLException {
        this.supportedMetadataPrefixes = new ArrayList();
        this.granularity = "YYYY-MM-DD";
        this.name = name;
        this.baseURL = baseURL;
        this.adminEmail = adminEmail;
        this.deletedRecord = "no";
        this.protocolVersion = "2.0";
        this.earliestDatestamp = earliestDatestamp;
        this.supportedMetadataPrefixes.add("custom");
        this.recordTemplateCustom = recordTemplateCustom;
        URL url = new URL(baseURL);
        this.customMetadataXSD = new CustomMetadataXSD(name, url.getHost(), url.getPort());
        if (sets == null || sets.isEmpty()) {
            this.sets = new Properties();
            this.sets.put(name, "Single set which contains all records of the repository");
        } else {
            this.sets = sets;
        }
    }

    public void materializeXSDonFilesystem() throws TransformerException {
        this.customMetadataXSD.materializeXSDonFilesystem(this.recordTemplateCustom);
    }

    public String getName() {
        return this.name;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public ArrayList<String> getAdminEMails() {
        return this.adminEmail;
    }

    public String typeDeletedRecord() {
        return this.deletedRecord;
    }

    public Properties getSets() {
        return this.sets;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public String getEarliestDatestamp() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(this.earliestDatestamp);
    }

    public String getGranularity() {
        return this.granularity;
    }

    public ArrayList<String> getSupportedMetadataPrefixes() {
        return this.supportedMetadataPrefixes;
    }

    public CustomMetadataXSD getCustomMetadataXSD() {
        return this.customMetadataXSD;
    }

    public OAIDCMetadataXSD getOAIDCMetadataXSD() {
        return this.oaiDcMetadataXSD;
    }

    public RecordTemplateCustom getRecordTemplateCustom() {
        return this.recordTemplateCustom;
    }

    public RecordTemplateDC getRecordTemplateDC() {
        return this.recordTemplateDC;
    }
}

