/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.oaipmh.objectmappers;

import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.lang.StringEscapeUtils;
import org.gcube.application.framework.oaipmh.objectmappers.CustomMetadataXSD;
import org.gcube.application.framework.oaipmh.objectmappers.OAIDCMetadataXSD;
import org.gcube.application.framework.oaipmh.objectmappers.RecordTemplateCustom;
import org.gcube.application.framework.oaipmh.objectmappers.RecordTemplateDC;
import org.gcube.application.framework.oaipmh.tools.ElementGenerator;
import org.gcube.application.framework.oaipmh.tools.Toolbox;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Record {
    private Element record;

    public Record(HashMap<String, String> values, RecordTemplateCustom template, Properties sets, CustomMetadataXSD customMetadataXSD) {
        Document doc = ElementGenerator.getDocument();
        Element record = doc.createElement("record");
        record.appendChild(this.createRecordHeaderCustom(values, sets));
        record.appendChild(this.createRecordMetadataByCustom(values, template, customMetadataXSD));
        this.record = record;
    }

    private Element createRecordHeaderCustom(HashMap<String, String> values, Properties sets) {
        Document doc = ElementGenerator.getDocument();
        Element header = doc.createElement("header");
        Element identifier = doc.createElement("identifier");
        identifier.appendChild(doc.createTextNode(values.get("id")));
        Element datestamp = doc.createElement("datestamp");
        if (values.get("datestamp") != null) {
            datestamp.appendChild(doc.createTextNode(values.get("datestamp")));
        } else {
            datestamp.appendChild(doc.createTextNode(Toolbox.dateTimeNow()));
        }
        header.appendChild(identifier);
        header.appendChild(datestamp);
        for (Object set : sets.values()) {
            Element setSpec = doc.createElement("setSpec");
            setSpec.appendChild(doc.createTextNode((String)set));
            header.appendChild(setSpec);
        }
        return header;
    }

    private Element createRecordMetadataByCustom(HashMap<String, String> values, RecordTemplateCustom template, CustomMetadataXSD metadataXSDobject) {
        Document doc = ElementGenerator.getDocument();
        Element metadata = doc.createElement("metadata");
        CustomMetadataXSD customMetadataXSD = metadataXSDobject;
        Element record = doc.createElement(customMetadataXSD.getName());
        record.setAttribute("xmlns", customMetadataXSD.getXmlnsPlusName());
        record.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        record.setAttribute("xsi:schemaLocation", customMetadataXSD.getXmlnsPlusName() + " " + customMetadataXSD.getXSDWebLocation());
        for (String elemName : template.getBaseNameTypes().keySet()) {
            String elVal = values.get(elemName);
            if (elVal == null) continue;
            Element element = doc.createElement(elemName);
            element.appendChild(doc.createTextNode(elVal));
            record.appendChild(element);
        }
        for (String rootElemName : template.getAllSubGroupNames()) {
            Element group = doc.createElement(rootElemName);
            for (String subElemName : template.getSubGroupNameTypes(rootElemName).keySet()) {
                String elVal = values.get(rootElemName + ":" + subElemName);
                if (elVal == null) continue;
                Element element = doc.createElement(subElemName);
                element.appendChild(doc.createTextNode(elVal));
                group.appendChild(element);
            }
            if (!group.hasChildNodes()) continue;
            record.appendChild(group);
        }
        metadata.appendChild(record);
        return metadata;
    }

    public Record(HashMap<String, String> values, RecordTemplateDC template, Properties sets, OAIDCMetadataXSD oaidcMetadataXSD) {
        Document doc = ElementGenerator.getDocument();
        Element record = doc.createElement("record");
        record.appendChild(this.createRecordHeaderDC(values, sets));
        record.appendChild(this.createRecordMetadataDC(values, template, oaidcMetadataXSD));
        this.record = record;
    }

    private Element createRecordHeaderDC(HashMap<String, String> values, Properties sets) {
        Document doc = ElementGenerator.getDocument();
        Element header = doc.createElement("header");
        Element identifier = doc.createElement("identifier");
        identifier.appendChild(doc.createTextNode(StringEscapeUtils.escapeXml((String)values.get("_OBJECT_ID_"))));
        Element datestamp = doc.createElement("datestamp");
        if (values.get("datestamp") != null) {
            datestamp.appendChild(doc.createTextNode(StringEscapeUtils.escapeXml((String)values.get("datestamp"))));
        } else {
            datestamp.appendChild(doc.createTextNode(StringEscapeUtils.escapeXml((String)Toolbox.dateTimeNow())));
        }
        header.appendChild(identifier);
        header.appendChild(datestamp);
        for (Object set : sets.values()) {
            Element setSpec = doc.createElement("setSpec");
            setSpec.appendChild(doc.createTextNode(StringEscapeUtils.escapeXml((String)((String)set))));
            header.appendChild(setSpec);
        }
        return header;
    }

    private Element createRecordMetadataDC(HashMap<String, String> values, RecordTemplateDC template, OAIDCMetadataXSD oaidcMetadataXSD) {
        Document doc = ElementGenerator.getDocument();
        Element record = doc.createElement(oaidcMetadataXSD.getName());
        record.setAttribute("xmlns:oai_dc", oaidcMetadataXSD.getXmlnsPlusName());
        record.setAttribute("xmlns:dc", "http://purl.org/dc/elements/1.1/");
        record.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        record.setAttribute("xsi:schemaLocation", oaidcMetadataXSD.getXmlnsPlusName() + " " + oaidcMetadataXSD.getPathXSD());
        for (String elemName : template.getNameTypes().keySet()) {
            String elVal = values.get(elemName);
            if (elVal == null) continue;
            Element element = doc.createElement("dc:" + elemName);
            element.appendChild(doc.createTextNode(StringEscapeUtils.escapeXml((String)elVal)));
            record.appendChild(element);
        }
        return record;
    }

    public Element getRecordElement() {
        return this.record;
    }
}

