/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.oaipmh.objectmappers;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.xml.transform.TransformerException;
import org.gcube.application.framework.oaipmh.objectmappers.MetadataElement;
import org.gcube.application.framework.oaipmh.objectmappers.RecordTemplateCustom;
import org.gcube.application.framework.oaipmh.tools.ElementGenerator;
import org.gcube.application.framework.oaipmh.tools.Toolbox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CustomMetadataXSD {
    private static final Logger logger = LoggerFactory.getLogger(CustomMetadataXSD.class);
    private String xmlns = "http://www.w3.org/2001/XMLSchema";
    private String xmlnsPlusName;
    private String name;
    private String hostname;
    private int port;
    private String xsdBasePath = System.getProperty("catalina.base") + "/webapps/ROOT/dtd/oai_pmh";
    private String pathXSD;
    private String contentXSD;
    private String description = "Custom XSD created on-the-fly to support custom records";

    public CustomMetadataXSD(String name, String hostname, int port) {
        File dir = new File(this.xsdBasePath);
        dir.mkdirs();
        this.name = name;
        this.hostname = hostname;
        this.port = port;
    }

    public String getXSDFileContent() {
        return this.contentXSD;
    }

    public String getXmlnsPlusName() {
        return this.xmlnsPlusName;
    }

    public String getXSDWebLocation() {
        URL url = null;
        try {
            url = new URL("http", this.hostname, this.port, this.pathXSD.split("/webapps/ROOT")[1]);
        }
        catch (MalformedURLException e) {
            logger.debug("Could not form the url for the XSD web location. " + e);
            return "";
        }
        return url.toString();
    }

    public void materializeXSDonFilesystem(RecordTemplateCustom recordTemplate) throws TransformerException {
        this.pathXSD = this.xsdBasePath + "/" + this.name + ".xsd";
        this.contentXSD = this.createXSD(recordTemplate);
        Toolbox.writeOnFile(this.pathXSD, this.contentXSD);
    }

    private String createXSD(RecordTemplateCustom recordTemplate) throws TransformerException {
        Element el;
        String webFilePath = this.getXSDWebLocation();
        String webBasePath = webFilePath.substring(0, webFilePath.lastIndexOf("/"));
        this.xmlnsPlusName = webBasePath + "/" + this.name + "/";
        Document doc = ElementGenerator.getDocument();
        Element schema = doc.createElement("schema");
        schema.setAttribute("xmlns", "http://www.w3.org/2001/XMLSchema");
        schema.setAttribute("xmlns:" + this.name, this.xmlnsPlusName);
        schema.setAttribute("targetNamespace", this.xmlnsPlusName);
        schema.setAttribute("elementFormDefault", "qualified");
        Element annotation = doc.createElement("annotation");
        Element documentation = doc.createElement("documentation");
        documentation.appendChild(doc.createTextNode(this.description));
        annotation.appendChild(documentation);
        schema.appendChild(annotation);
        Element element = doc.createElement("element");
        element.setAttribute("name", this.name);
        element.setAttribute("type", this.name + ":" + recordTemplate.getRecordName());
        schema.appendChild(element);
        Element complexType = doc.createElement("complexType");
        complexType.setAttribute("name", recordTemplate.getRecordName());
        Element all = doc.createElement("all");
        for (MetadataElement field : recordTemplate.getBaseNameTypes().values()) {
            el = doc.createElement("element");
            el.setAttribute("name", field.getName());
            el.setAttribute("minOccurs", field.getMinOccurs());
            el.setAttribute("maxOccurs", field.getMaxOccurs());
            el.setAttribute("type", field.getType());
            all.appendChild(el);
        }
        for (String subname : recordTemplate.getAllSubGroupNames()) {
            el = doc.createElement("element");
            el.setAttribute("name", subname);
            el.setAttribute("minOccurs", "0");
            el.setAttribute("maxOccurs", "unlimited");
            el.setAttribute("type", this.name + ":" + subname);
            all.appendChild(el);
        }
        complexType.appendChild(all);
        schema.appendChild(complexType);
        for (String subname : recordTemplate.getAllSubGroupNames()) {
            HashMap<String, MetadataElement> subNameTypes = recordTemplate.getSubGroupNameTypes(subname);
            complexType = doc.createElement("complexType");
            complexType.setAttribute("name", subname);
            Element sequence = doc.createElement("sequence");
            for (MetadataElement el2 : subNameTypes.values()) {
                Element elem = doc.createElement("element");
                elem.setAttribute("name", el2.getName());
                elem.setAttribute("minOccurs", el2.getMinOccurs());
                elem.setAttribute("maxOccurs", el2.getMaxOccurs());
                elem.setAttribute("type", el2.getType());
                sequence.appendChild(elem);
            }
            complexType.appendChild(sequence);
            schema.appendChild(complexType);
        }
        return ElementGenerator.domToXML(schema);
    }

    public String getName() {
        return this.name;
    }
}

