package org.gcube.application.framework.userprofiles.library;

import java.util.ArrayList;
import java.util.HashMap;

import org.gcube.personalization.profileadministration.client.library.exceptions.ProfileAdministrationException;
import org.gcube.personalization.userprofileaccess.client.library.exceptions.UserProfileAccessException;

public interface UserProfileInfoI {
	
	/**
	 * @param username the username
	 * @return the Profile serialized as a string
	 * @throws UserProfileAccessException 
	 */
	public String getUserProfile(String username) throws UserProfileAccessException;
	
	/**
	 * Sets user's profile
	 * @param username the username
	 * @param profile the Profile serialized as a string
	 * @return 
	 * @throws UserProfileAccessException 
	 */
	public boolean setUserProfile(String username, String profile) throws UserProfileAccessException;

	/**
	 * @param username the username
	 * @return a hashmap containing the metadata schemata and the IDs of the corresponding generic resources that represent the XSLTs to transform metadata to html
	 */
	public HashMap<String,String> getMetadataXSLTs(String username);
	
	/**
	 * @param username the username
	 * @return a hashmap containing the ids of the presentation fields selected by the user per collection
	 */
	public HashMap<String,ArrayList<String>> getPresentationFields(String username);

	/**
	 * Creates a default profile for this user
	 * @param username the username
	 */
	public void createUserProfile(String username);
	
	/**
	 * Drops the profile of this user
	 * @param username the username
	 */
	public void dropUserProfile(String username);

	/**
	 * @param username the username
	 * @param element the element node to be retrieved from the profile
	 * @return the value
	 */
	public String[] getElement(String username, String element);

	/**
	 * @param username the username
	 * @param element the element value to be retrieved from the profile
	 * @return the values
	 */
	public String getElementValue(String username, String element);
	
	/**
	 * @param username the username
	 * @param element the element node to be set from the profile
	 */
	public void setElementValue(String username, String element, String value);
	
	/**
	 * @param defaultProfile the default profile xml
	 */
	public void setDefaultProfile(String defaultProfile);

}
