package org.gcube.application.framework.userprofiles.library.impl;

import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
//import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
//import javax.xml.xpath.XPath;
//import javax.xml.xpath.XPathConstants;
//import javax.xml.xpath.XPathExpressionException;
//import javax.xml.xpath.XPathFactory;

//import net.sf.ehcache.Element;

import org.apache.xpath.XPathAPI;
import org.gcube.application.framework.core.cache.CachesManager;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.application.framework.core.util.CacheEntryConstants;
import org.gcube.application.framework.core.util.QueryString;
import org.gcube.application.framework.userprofiles.cache.UserProfileCache;
import org.gcube.application.framework.userprofiles.cache.factories.ProfileCacheEntryFactory;
//import org.gcube.application.framework.userprofiles.commons.ProfileService;
import org.gcube.application.framework.userprofiles.library.UserProfileInfoI;
import org.gcube.common.clients.fw.queries.StatefulQuery;
import org.gcube.common.scope.api.ScopeProvider;
//import org.gcube.common.core.faults.GCUBEFault;
//import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.personalization.profileadministration.client.library.exceptions.ProfileAdministrationException;
import org.gcube.personalization.profileadministration.client.library.proxies.ProfileAdministrationCLProxyI;
import org.gcube.personalization.profileadministration.client.library.proxies.ProfileAdministrationDSL;
//import org.gcube.personalization.profileadministration.stubs.ProfileAdministrationPortType;
import org.gcube.personalization.userprofileaccess.client.library.beans.Types;
import org.gcube.personalization.userprofileaccess.client.library.beans.Types.GetElementResponse;
import org.gcube.personalization.userprofileaccess.client.library.beans.Types.SetElement;
import org.gcube.personalization.userprofileaccess.client.library.beans.Types.SetElementValue;
import org.gcube.personalization.userprofileaccess.client.library.exceptions.UserProfileAccessException;
import org.gcube.personalization.userprofileaccess.client.library.proxies.UserProfileAccessCLProxyI;
import org.gcube.personalization.userprofileaccess.client.library.proxies.UserProfileAccessDSL;
//import org.gcube.personalization.userprofileaccess.stubs.SetElement;
//import org.gcube.personalization.userprofileaccess.stubs.SetElementValue;
//import org.gcube.personalization.userprofileaccess.stubs.UserProfileAccessPortType;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
//import org.xml.sax.InputSource;
//import org.xml.sax.SAXException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserProfile implements UserProfileInfoI {
	
	protected ASLSession session;

	/** The logger. */
	private static final Logger logger = LoggerFactory.getLogger(UserProfile.class);

	protected static final DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();

	protected static ProfileAdministrationCLProxyI profileProxy = ProfileAdministrationDSL.getSearchProxyBuilder().build();
	
	
	/**
	 * @param extrenalSessionID the external session ID. In case of a web application using ASL, this is the http session ID
	 * @param username the username of the user that makes the request
	 */
	public UserProfile(String extrenalSessionID, String username)
	{
		session = SessionManager.getInstance().getASLSession(extrenalSessionID, username);
	}


	/**
	 * @param session the D4SSession 
	 */
	public UserProfile(ASLSession session) {
		super();
		this.session = session;
	}

	/** {@inheritDoc}*/
	public HashMap<String, String> getMetadataXSLTs(String username) {
		HashMap<String, String> metaXSLTs = new HashMap<String, String>();
		QueryString query = new QueryString();
		query.put(CacheEntryConstants.vre, session.getOriginalScopeName());
		query.put(CacheEntryConstants.username, username);
		Document profile = (Document)(CachesManager.getInstance().getEhcache(org.gcube.application.framework.userprofiles.util.CacheConstants.PROFILE_CACHE_NAME, new ProfileCacheEntryFactory()).get(query).getObjectValue());
		try {
			NodeList nodes = XPathAPI.selectNodeList(profile, "//xslts/metadataxslt/xslt");
			for(int i=0; i < nodes.getLength(); i++)
			{
				String name = "";
				String id = "";
				NodeList children = nodes.item(i).getChildNodes();
				for(int j =0; j < children.getLength(); j ++)
				{
					if(children.item(j).getNodeType() == Node.ELEMENT_NODE)
					{
						if(children.item(j).getNodeName().equals("name"))
							name = children.item(j).getFirstChild().getNodeValue();
						else if(children.item(j).getNodeName().equals("id"))
							id = children.item(j).getFirstChild().getNodeValue();
					}
				}
				logger.info("Inside GetMetadataXslts - initial name is: " + name);
				
				int a = name.lastIndexOf("-|-");
				name = name.substring(0, a);
				logger.info("After: " + name + " " + id);
				metaXSLTs.put(name, id);
			}
		} catch (TransformerException e) {
			logger.error("Failed to create a transformer",e);
		}
		return metaXSLTs;
	}


	/** {@inheritDoc}*/
	public HashMap<String, ArrayList<String>> getPresentationFields(String username) {
		HashMap<String, ArrayList<String>> collectionsFields = new HashMap<String, ArrayList<String>>();
		QueryString query = new QueryString();
		query.put(CacheEntryConstants.vre, session.getOriginalScopeName());
		query.put(CacheEntryConstants.username, username);
		Document profile = (Document)(CachesManager.getInstance().getEhcache(org.gcube.application.framework.userprofiles.util.CacheConstants.PROFILE_CACHE_NAME, new ProfileCacheEntryFactory()).get(query).getObjectValue());
		logger.debug("The user profile is: ");
		try {
			DOMSource domSource = new DOMSource(profile);
			StringWriter sw = new StringWriter();
			StreamResult result = new StreamResult(sw);
			TransformerFactory tf = TransformerFactory.newInstance();
			Transformer transformer = tf.newTransformer();
			transformer.transform(domSource, result);
			logger.debug(sw.toString());
		} catch (Exception e) {
			logger.error("Exception:", e);
		}
		try {
			NodeList nodes = XPathAPI.selectNodeList(profile, "//collections/collection");
			logger.debug("Number of collection nodes is: " + nodes.getLength());
			for(int i=0; i < nodes.getLength(); i++)
			{
				String id = "";
				String colId = "";
				//colId = nodes.item(i).getTextContent();
				NamedNodeMap attrs = nodes.item(i).getAttributes();
				Node colIdNode = attrs.getNamedItem("id");
				colId = colIdNode.getNodeValue();
				logger.debug("IDS: " + colId + " " + colIdNode.getTextContent());
				NodeList children = nodes.item(i).getChildNodes();
				for(int j =0; j < children.getLength(); j ++)
				{
					//id = children.item(j).getNodeValue();
					id = children.item(j).getTextContent();
					logger.debug("Field id: " + id);
					ArrayList<String> fieldIds = collectionsFields.get(colId);
					if (fieldIds == null)
						fieldIds = new ArrayList<String>();
					fieldIds.add(id);
					logger.debug("Putting field: " + id);
					logger.debug("For Collection Putting: " + colId);
					collectionsFields.put(colId, fieldIds);
				}
			}
		} catch (TransformerException e) {
			logger.error("Failed to create a transformer",e);
		}
		return collectionsFields;
	}

	/** {@inheritDoc}*/
	public String getUserProfile(String username) {
		String scope = session.getScope();
		String scopeLeaf = scope.substring(scope.lastIndexOf("/")+1);
		String profile = null;
		//get profile from cache
		profile = UserProfileCache.getProfile(username, scopeLeaf);
		if((profile!=null)&&(profile.length()>0))
			return profile;
		//if not available, get profile from IS
		StatefulQuery q = UserProfileAccessDSL.getSource().withUsernameAndScope(username, scopeLeaf).build();
		List<EndpointReference> eprs = q.fire();
		if(eprs.size()>0){
			try{
				UserProfileAccessCLProxyI proxyRandom = UserProfileAccessDSL.getUserProfileAccessProxyBuilder().at((W3CEndpointReference)eprs.get(0)).build();
				profile = proxyRandom.getUserProfile();
				//and store it in cache as well
				UserProfileCache.addProfile(username, scopeLeaf, profile);
				return profile;
			}catch(UserProfileAccessException e){
				logger.debug("Could not retrieve user profile from IS",e);
			}
		}
		else{
			logger.debug("Could not find any EPRs to get the user profile");
		}
		return "";
		
	}

	private String createStringFromDomTree(Node tree) throws Exception {
		String nodeString = null;
		TransformerFactory tFactory = TransformerFactory.newInstance();
		Transformer transformer = tFactory.newTransformer();
		transformer.setOutputProperty("omit-xml-declaration", "yes");
		StringWriter sw = new StringWriter();
		StreamResult result = new StreamResult(sw);
		DOMSource source = new DOMSource(tree);
		transformer.transform( source, result );
		nodeString = sw.getBuffer().toString();
		return nodeString;
	}

	/** {@inheritDoc}
	 * */
	public boolean setUserProfile(String username, String profile) {
		String scope = session.getScope();
		String scopeLeaf = scope.substring(scope.lastIndexOf("/")+1);
		//set it on IS
		StatefulQuery q = UserProfileAccessDSL.getSource().withUsernameAndScope(username, scopeLeaf).build();
		List<EndpointReference> eprs = q.fire();	
		if(eprs.size()>0){
			try{
				UserProfileAccessCLProxyI proxyRandom = UserProfileAccessDSL.getUserProfileAccessProxyBuilder().at((W3CEndpointReference)eprs.get(0)).build();
				proxyRandom.updateUserProfile(profile);
				//set it on cache as well
				UserProfileCache.addProfile(username, scopeLeaf, profile);
				return true;
			}catch(Exception e){
				logger.debug("Error contacting IS to set profile. Profile was not set on IS");
				return false;
			}
		}
		else{
			logger.debug("Could not find any EPRs to set the profile on IS");
			return false;
		}

	}

	/** {@inheritDoc}*/
	public void createUserProfile(String username) {
		try{
			//it creates a default profile for the user on IS
			ScopeProvider.instance.set(session.getScope());
			profileProxy.createUserProfile(username);
			//maybe we could get the profile from IS and add it to the cache. Better use setUserProfile() afterwards.
		}catch(Exception e){
			logger.debug("Could not create user profile");
		}
	}

	/** {@inheritDoc}*/
	public void dropUserProfile(String username) {
		
		String scope = session.getScope();
		String scopeLeaf = scope.substring(scope.lastIndexOf("/")+1);
		//remove it from Cache
		UserProfileCache.removeProfile(username, scopeLeaf);
		//remove it from IS
		ScopeProvider.instance.set(session.getScope());
		try{
			profileProxy.dropUserProfile(username);
		}catch(ProfileAdministrationException e){
			logger.debug("Could not remove user profile from IS",e);
		}
		
		
	}

	/** {@inheritDoc}*/
	public String[] getElement(String username, String element) {
		
		String scope = session.getScope();
		String scopeLeaf = scope.substring(scope.lastIndexOf("/")+1);
		//get from cached profile
		String profile = getUserProfile(username);
		InputSource profileIn = new InputSource(new ByteArrayInputStream(profile.getBytes()));
		try {
			Document profileDoc = dfactory.newDocumentBuilder().parse(profileIn);
			List<String> nodesStr = new ArrayList<String>();
			NodeList nodes = XPathAPI.selectNodeList(profileDoc, element);
			for(int i=0; i < nodes.getLength(); i++)
			{
				try {
					nodesStr.add(createStringFromDomTree(nodes.item(i)));
				} catch (Exception e) {
					logger.error("Failed to serialize a profile's node",e);
				}
			}
			String[] res = new String[nodesStr.size()];
			for(int i=0; i<res.length; i++)
				res[i] = nodesStr.get(i);
			return res;
		} catch (Exception e) {
			logger.debug("Could not parse the element value from User profile stored in cache",e);
		} 
		
		//get it from profile stored on IS 
		StatefulQuery q = UserProfileAccessDSL.getSource().withUsernameAndScope(username, scopeLeaf).build();
		List<EndpointReference> eprs = q.fire();
		
		GetElementResponse elementValue = new GetElementResponse();
		if(eprs.size()>0){
			try{
				UserProfileAccessCLProxyI proxyRandom = UserProfileAccessDSL.getUserProfileAccessProxyBuilder().at((W3CEndpointReference)eprs.get(0)).build();
				elementValue = proxyRandom.getElement(element);
			}catch(UserProfileAccessException e){
				logger.debug("Could not get profile element from IS",e);
			}
		}
		else{
			logger.debug("Could not find any EPRs to get the element value");
		}
		
		String[] results = new String[elementValue.array.size()];
		for(int i=0;i<elementValue.array.size();i++)
			results[i] = elementValue.array.get(i);
		return results;
	}
	
	


	/** {@inheritDoc}*/
	public String getElementValue(String username, String element) {
		//get it from cached profile
		String profile = getUserProfile(username);
		InputSource profileIn = new InputSource(new ByteArrayInputStream(profile.getBytes()));
		try {
			Document profileDoc = dfactory.newDocumentBuilder().parse(profileIn);
			XPath xpath = XPathFactory.newInstance().newXPath();	 
			String result = (String) xpath.evaluate(element+"/text()", profileDoc, XPathConstants.STRING);
			if((result!=null) && (result.length()>0))
				return result;
		} catch (Exception e) {
			logger.debug("Could not parse the element value from User profile stored in cache",e);
		}
		//get it from IS
		String scope = session.getScope();
		String scopeLeaf = scope.substring(scope.lastIndexOf("/")+1);
		StatefulQuery q = UserProfileAccessDSL.getSource().withUsernameAndScope(username, scopeLeaf).build();
		List<EndpointReference> eprs = q.fire();
		String elementValue = null;
		if(eprs.size()>0){
			try{
				UserProfileAccessCLProxyI proxyRandom = UserProfileAccessDSL.getUserProfileAccessProxyBuilder().at((W3CEndpointReference)eprs.get(0)).build();
				elementValue = proxyRandom.getElementValue(element);
			}catch(UserProfileAccessException e){
				logger.debug("Could not get element value from IS",e);
			}
		}
		else{
			logger.debug("Could not find any EPRs to get the element value");
		}
		
		return elementValue;
		
	}

	/** {@inheritDoc}*/
	public void setDefaultProfile(String defaultProfile) {
		
		//set it on IS
		ScopeProvider.instance.set(session.getScope());
		try{
			profileProxy.setDefaultProfile(defaultProfile);
		}catch(ProfileAdministrationException e){
			logger.debug("Could not set default profile value on IS",e);
		}
		
	}

	/** {@inheritDoc}*/
	public void setElementValue(String username, String element, String value) {

		String scope = session.getScope();
		String scopeLeaf = scope.substring(scope.lastIndexOf("/")+1);
		
		//set it on IS
		StatefulQuery q = UserProfileAccessDSL.getSource().withUsernameAndScope(username, scopeLeaf).build();
		List<EndpointReference> eprs = q.fire();
		if(eprs.size()>0){
			try{
				SetElementValue el = new SetElementValue();
				el.elementName = element;
				el.value = value;
				UserProfileAccessCLProxyI proxyRandom = UserProfileAccessDSL.getUserProfileAccessProxyBuilder().at((W3CEndpointReference)eprs.get(0)).build();
				proxyRandom.setElementValue(el);
				//set it on cache as well
				String newISProfile = proxyRandom.getUserProfile();
				UserProfileCache.addProfile(username, scopeLeaf, newISProfile);
			}catch(UserProfileAccessException e){
				logger.debug("Could not set profile's element value on IS",e);
			}
		}
		else{
			logger.debug("Could not find any EPRs to set the element value");
		}
		
	}
	
	public boolean deleteElement(String username, String elementName) {
		String scope = session.getScope();
		String scopeLeaf = scope.substring(scope.lastIndexOf("/")+1);
		//delete from IS
		StatefulQuery q = UserProfileAccessDSL.getSource().withUsernameAndScope(username, scopeLeaf).build();
		List<EndpointReference> eprs = q.fire();
		if(eprs.size()>0){
			try{
				UserProfileAccessCLProxyI proxyRandom = UserProfileAccessDSL.getUserProfileAccessProxyBuilder().at((W3CEndpointReference)eprs.get(0)).build();
				proxyRandom.deleteElement(elementName);
				//delete it on cache as well (replace user profile with the new one without the value)
				String newISProfile = proxyRandom.getUserProfile();
				UserProfileCache.addProfile(username, scopeLeaf, newISProfile);
				return true;
			}catch(UserProfileAccessException e){
				logger.debug("Could not delete profile element from IS",e);
				return false;
			}
		}
		else{
			logger.debug("Could not find any EPRs to get profile and remove the element value");
			return false;
		}
		
	 }
	
	
	public void setElement (String username, String path, String elementName, String elementValue) {
		String scope = session.getScope();
		String scopeLeaf = scope.substring(scope.lastIndexOf("/")+1);
		//set it on IS
		StatefulQuery q = UserProfileAccessDSL.getSource().withUsernameAndScope(username, scopeLeaf).build();
		List<EndpointReference> eprs = q.fire();
		if(eprs.size()>0){
			try{
			SetElement el = new SetElement();
			el.path = path;
			el.elementName = elementName;
			el.value = elementValue;
			UserProfileAccessCLProxyI proxyRandom = UserProfileAccessDSL.getUserProfileAccessProxyBuilder().at((W3CEndpointReference)eprs.get(0)).build();
			proxyRandom.setElement(el);
			// set it on cached profile as well
			String newISProfile = proxyRandom.getUserProfile();
			UserProfileCache.addProfile(username, scopeLeaf, newISProfile);
			}catch(UserProfileAccessException e){
				logger.debug("Could not set profile element on IS",e);
			}
		}
		else{
			logger.debug("Could not find any EPRs to set the element value");
		}
        
     }	
	
	
	/**
	 * inactive since the  the integration of featherweight stack. Should implement security first 
	 */
	protected void createElementToService(String path, String username, String name, String value) {

//		ProfileService profileService = new ProfileService(username, session.getScopeName());
//		UserProfileAccessPortType port = profileService.getUserProfileAccess(session.getCredential());
//		SetElement setElement = new SetElement();
//		setElement.setElementName(name);
//		setElement.setValue(value);
//		setElement.setPath(path);
//		try {
//			port.setElement(setElement);
//		} catch (GCUBEFault e) {
//			logger.error("An error occured while adding element to service", e);
//		} catch (RemoteException e) {
//			logger.error("An error occured while adding element to service", e);
//		}

	}
	

	/**
	 * inactive since the  the integration of featherweight stack. Should implement security first 
	 */
	protected void setElementToService(String username, String element, String value)
	{
/*
		ProfileService profileService = new ProfileService(username,  session.getScopeName());
		UserProfileAccessPortType port = profileService.getUserProfileAccess(session.getCredential());
		SetElementValue setElement = new SetElementValue();
		setElement.setElementName(element);
		setElement.setValue(value);
		try {
			port.setElementValue(setElement);
		} catch (GCUBEFault e) {
			logger.error("An error occured while setting the element to service",e);
		} catch (RemoteException e) {
			logger.error("An error occured while setting the element to service",e);
		}
		*/
	}
	
	/**
	 * inactive since the  the integration of featherweight stack. Should implement security first 
	 */
	protected void deleteElementToService (String username, String elementName) {
		/*
		ProfileService profileService = new ProfileService(username, session.getScopeName());
		UserProfileAccessPortType port = profileService.getUserProfileAccess(session.getCredential());
		
		try {
			port.deleteElement(elementName);
		} catch (GCUBEFault e) {
			// TODO Auto-generated catch block
			logger.error("Exception:", e);
		} catch (RemoteException e) {
			// TODO Auto-generated catch block
			logger.error("Exception:", e);
		}
		*/
	}

}
