/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.sms;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.application.framework.core.cache.RIsManager;
import org.gcube.application.framework.core.security.ServiceContextManager;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.sms.util.Logger;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.FileTransferParameters;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.InfoObjectDescription;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.PropertyDescription;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.ReferenceDescription;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.SMSPortType1PortType;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.service.SMSPortType1ServiceAddressingLocator;
import org.gcube.informationsystem.cache.SrvType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorageManagement {
    public static final String ANN_COLS_SCOPED_IDS_ATTRIBUTE_NAME = "SCOPED_ANNCOLS_IDS";
    protected ASLSession session;
    protected static AtomicInteger smsId = new AtomicInteger(0);
    protected static final GCUBELog logger = new GCUBELog(StorageManagement.class);

    private StorageManagement(ASLSession session) {
        this.session = session;
    }

    public static StorageManagement getInstance(ASLSession session) {
        return new StorageManagement(session);
    }

    protected SMSPortType1PortType getSMSAddress() {
        EndpointReference[] smsURIs = null;
        Logger.debug("\n\n\n\n*************** CALLING  RIsManager with scope: \n" + this.session.getScope().getName() + "\n*************** HEEB ******\n\n\n");
        try {
            smsURIs = RIsManager.getInstance().getISCache(this.session.getScope()).getEPRsFor("ContentManagement", "StorageManagementService", SrvType.SIMPLE.name());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (EndpointReference add : smsURIs) {
            String smsAddress = add.getAddress().toString();
            if (!smsAddress.contains("gcube/contentmanagement/storagelayer/storagemanagementservice/porttype1")) continue;
            try {
                EndpointReferenceType endpoint = new EndpointReferenceType();
                endpoint.setAddress((AttributedURI)new Address(smsAddress));
                SMSPortType1ServiceAddressingLocator smslocator = new SMSPortType1ServiceAddressingLocator();
                SMSPortType1PortType sms = smslocator.getSMSPortType1PortTypePort(endpoint);
                return (SMSPortType1PortType)ServiceContextManager.applySecurity((Remote)sms, (ASLSession)this.session);
            }
            catch (Exception e) {
                logger.fatal((Object)"Error getting the SMS porttype", (Throwable)e);
            }
        }
        logger.fatal((Object)"Error getting the SMS porttype, no porttype1 found");
        return null;
    }

    protected boolean belongsToScope(String annotationID, SMSPortType1PortType sms) {
        FileTransferParameters ftp = new FileTransferParameters();
        ftp.setObjectID(annotationID);
        ftp.setFileLocation("/dev/null");
        InfoObjectDescription info = null;
        try {
            info = sms.getInfoObject(ftp);
        }
        catch (RemoteException re) {
            logger.debug((Object)("Received exception while getting annotation metadata collection: returning false" + re.getMessage()));
            return false;
        }
        String annMetaColID = "";
        logger.debug((Object)("LOOKING FOR annotationID:" + annotationID));
        if (info.getProperties() != null) {
            PropertyDescription[] props = info.getProperties();
            for (int i = props.length - 1; i >= 0; --i) {
                if (!props[i].getName().equalsIgnoreCase("mc:member-of")) continue;
                annMetaColID = props[i].getValue();
                logger.debug((Object)("FOUND ITS annMetaColID: " + annMetaColID));
                break;
            }
            List<String> scopedIDs = StorageManagement.getAnnMetadataCols(this.session);
            boolean returnValue = scopedIDs.contains(annMetaColID);
            logger.debug((Object)("annMetaColID: " + annMetaColID + " belongs? " + returnValue));
            return returnValue;
        }
        return false;
    }

    protected static List<String> getAnnMetadataCols(ASLSession session) {
        if (session.getAttribute(ANN_COLS_SCOPED_IDS_ATTRIBUTE_NAME) == null) {
            return new LinkedList<String>();
        }
        return (List)session.getAttribute(ANN_COLS_SCOPED_IDS_ATTRIBUTE_NAME);
    }

    public String getContentFromSMS(String infoObjectID) {
        SMSPortType1PortType sms = this.getSMSAddress();
        try {
            FileTransferParameters ftp = new FileTransferParameters();
            ftp.setObjectID(infoObjectID);
            ftp.setFileLocation("inmessage://");
            InfoObjectDescription info = null;
            try {
                info = sms.getInfoObject(ftp);
            }
            catch (RemoteException re) {
                logger.debug((Object)("Received exception: returning null" + re.getMessage()));
                return "";
            }
            if (info.getRawContent() != null) {
                String toReturn = new String(info.getRawContent());
                return toReturn;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public InfoObjectDescription getRawObject(String oid) {
        SMSPortType1PortType sms = null;
        sms = this.getSMSAddress();
        FileTransferParameters ftp = new FileTransferParameters();
        ftp.setObjectID(oid);
        ftp.setFileLocation("/dev/null");
        InfoObjectDescription info = null;
        try {
            info = sms.getInfoObject(ftp);
        }
        catch (RemoteException re) {
            logger.debug((Object)("Received exception while getting annotation metadata collection: returning false" + re.getMessage()));
            return null;
        }
        return info;
    }

    public String getFirstActualMetadataOID(String mdCollOID) throws IOException, FileNotFoundException {
        InfoObjectDescription info = null;
        info = this.getRawObject(mdCollOID);
        logger.debug((Object)("<b>OID</b>:" + info.getObjectID() + "<br>"));
        String metadataOID = "";
        if (info.getReferences() != null) {
            ReferenceDescription[] refs = info.getReferences();
            for (int i = 0; i < refs.length; ++i) {
                if (!refs[i].getRole().equalsIgnoreCase("contentmanagement:is-member-of")) continue;
                metadataOID = refs[i].getSourceObjectID();
                return metadataOID;
            }
        }
        return "";
    }

    public String getRandomMetadataOID(String mdCollOID) throws IOException, FileNotFoundException {
        InfoObjectDescription info = null;
        info = this.getRawObject(mdCollOID);
        logger.debug((Object)("<b>OID</b>:" + info.getObjectID() + "<br>"));
        String metadataOID = "";
        if (info.getReferences() != null) {
            ReferenceDescription[] refs = info.getReferences();
            for (int i = 0; i < 10; ++i) {
                int random = new Random().nextInt() % refs.length;
                int n = random = Integer.signum(random) == -1 ? -random : random;
                if (!refs[random].getRole().equalsIgnoreCase("contentmanagement:is-member-of")) continue;
                metadataOID = refs[random].getSourceObjectID();
                return metadataOID;
            }
        }
        logger.error((Object)"Unable to retrieve a MOId for the collection");
        return "";
    }
}

