/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.sms;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.gcube.application.framework.sms.util.StorageReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DigiObjectInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String oid;
    private String name;
    private long length;
    private String mimetype;
    private String collectionID;
    private List<StorageReference> availableMetadata = new LinkedList<StorageReference>();
    private List<StorageReference> alternativeReprs = new LinkedList<StorageReference>();
    private List<StorageReference> parts = new LinkedList<StorageReference>();
    private List<StorageReference> annotations = new LinkedList<StorageReference>();

    public DigiObjectInfo() {
    }

    public DigiObjectInfo(String oid, String name, long length, String mimetype, String collectionID, List<StorageReference> availableMetadata, List<StorageReference> alternativeReprs, List<StorageReference> parts, List<StorageReference> annotations) {
        this.oid = oid;
        this.name = name;
        this.length = length;
        this.mimetype = mimetype;
        this.collectionID = collectionID;
        this.availableMetadata = availableMetadata;
        this.alternativeReprs = alternativeReprs;
        this.annotations = annotations;
        this.parts = parts;
    }

    public DigiObjectInfo(String oid, String belongsToOid, String name, String collectionID, long length, String mimetype) {
        this.oid = oid;
        this.name = name;
        this.length = length;
        this.mimetype = mimetype;
        this.collectionID = collectionID;
        this.availableMetadata = null;
        this.alternativeReprs = null;
        this.annotations = null;
        this.parts = null;
    }

    public String getOid() {
        return this.oid;
    }

    public void setOid(String oid) {
        this.oid = oid;
    }

    public String getCollectionID() {
        return this.collectionID;
    }

    public void setCollectionID(String collectionID) {
        this.collectionID = collectionID;
    }

    public List<StorageReference> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(List<StorageReference> annotations) {
        this.annotations = annotations;
    }

    public List<StorageReference> getAvailableMetadata() {
        return this.availableMetadata;
    }

    public void setAvailableMetadata(List<StorageReference> availableMetadata) {
        this.availableMetadata = availableMetadata;
    }

    public long getLenght() {
        return this.length;
    }

    public void setLenght(long length) {
        this.length = length;
    }

    public String getMimetype() {
        return this.mimetype;
    }

    public void setMimetype(String mimetype) {
        this.mimetype = mimetype;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public String toString() {
        String toReturn = "DIGITAL OBJECT: id:" + this.oid;
        toReturn = toReturn + "\nlenght: " + this.length;
        toReturn = toReturn + (this.name == null ? "name: " : "name: " + this.name);
        toReturn = toReturn + (this.mimetype == null ? "\nmimetype: " : "\nmimetype: " + this.mimetype);
        if (this.availableMetadata != null) {
            for (StorageReference metadata : this.availableMetadata) {
                toReturn = toReturn + " " + metadata.getTarget();
            }
        }
        return toReturn;
    }

    public List<StorageReference> getAlternativeReprs() {
        return this.alternativeReprs;
    }

    public void setAlternativeReprs(List<StorageReference> alternativeReprs) {
        this.alternativeReprs = alternativeReprs;
    }

    public List<StorageReference> getParts() {
        return this.parts;
    }

    public void setParts(List<StorageReference> parts) {
        this.parts = parts;
    }

    public boolean hasMetadata() {
        if (this.availableMetadata == null) {
            return false;
        }
        return this.availableMetadata.size() > 0;
    }

    public boolean hasAnnotation() {
        if (this.annotations == null) {
            return false;
        }
        return this.annotations.size() > 0;
    }

    public boolean hasAlternative() {
        if (this.alternativeReprs == null) {
            return false;
        }
        return this.alternativeReprs.size() > 0;
    }

    public boolean hasParts() {
        if (this.parts == null) {
            return false;
        }
        return this.parts.size() > 0;
    }
}

