package org.gcube.applicationsupportlayer.social.mailing;

import java.util.Date;
import java.util.Properties;

import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

import org.gcube.portal.custom.communitymanager.OrganizationsUtil;
import org.gcube.portal.databook.shared.Notification;
import org.gcube.portal.databook.shared.NotificationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.liferay.portal.model.UserModel;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;

/**
 * 
 * @author Massimiliano Assante
 *
 */
public class EmailPlugin {

	private static final Logger _log = LoggerFactory.getLogger(EmailPlugin.class);

	private static String getHTMLEmail(Notification notification2Save, String userFirstName, String portalURL, String email) {

		String removedMarkup = notification2Save.getDescription().replaceAll("&amp;", "&");
		removedMarkup = removedMarkup.replaceAll("&gt;", ">");
		removedMarkup = removedMarkup.replaceAll("&lt;", "<");

		String sender = notification2Save.getSenderFullName();
		if (notification2Save.getType() == NotificationType.DOCUMENT_WORKFLOW_STEP_REQUEST_TASK)
			sender = "";
		
		String portalHost = portalURL.replaceAll("https://", "");
		portalHost = portalHost.replaceAll("http://", "");

		StringBuilder body = new StringBuilder();

		body.append("<body><br />")
		.append("<div style=\"color:#000; font-size:13px; font-family:'lucida grande',tahoma,verdana,arial,sans-serif;\">")
		.append("Dear ").append(userFirstName).append(",")  //dear <user>
		.append("<p>").append(sender).append(" ").append(removedMarkup) // has done something
		.append(getActionLink(notification2Save, portalURL)).append("</p>")  //Goto
		.append("</div><br />")
		.append("<p><div style=\"color:#999999; font-size:11px; font-family:'lucida grande',tahoma,verdana,arial,sans-serif;\">")
		.append("This message was sent to <a href=\"mailto:")
		.append(email)
		.append("\" style=\"color:#3B5998;text-decoration:none\" target=\"_blank\">").append(email).append("</a> by ")
		.append("<a href=\"").append(portalURL).append("\" style=\"color:#3B5998;text-decoration:none\" target=\"_blank\">").append(portalHost)
		.append("</a>. ")
		.append(" If you don't want to receive these emails in the future, please <a href=\"")
		.append(portalURL).append("/group/data-e-infrastructure-gateway/notifications\" style=\"color:#3b5998;text-decoration:none\" target=\"_blank\">unsubscribe</a>.")
		.append("</div></p>")
		.append("<p><div style=\"color:#999999; font-size:10px; font-family:'lucida grande',tahoma,verdana,arial,sans-serif; padding-top:15px;\">")
		.append("WARNING / LEGAL TEXT: This message is intended only for the use of the individual or entity to which it is addressed and may contain")
		.append("information which is privileged, confidential, proprietary, or exempt from disclosure under applicable law. If you are not the intended recipient or the person responsible for delivering the message to the intended recipient, you are strictly prohibited from disclosing, distributing, copying, or in any way using this message.")
		.append("If you have received this communication in error, please notify the <sender> and destroy and delete any copies you may have received.")
		.append("</div></p>")
		.append("</body>");
	
		return body.toString();

	}

	private static String getActionLink(Notification notification2Save, String portalURL) {
		StringBuilder actionLink = new StringBuilder("<a style=\"color:#3B5998; text-decoration:none\" target=\"_blank\" href=\"");
		return completeActonLinkByNotificationType(notification2Save, actionLink, portalURL);
	}

	public static void sendNotification(Notification notification2Save, String vreName) {

		UserModel user = null;
		String portalUrl = null;
		try {
			user = UserLocalServiceUtil.getUserByScreenName(OrganizationsUtil.getCompany().getCompanyId(), notification2Save.getUserid());
			portalUrl = PortalUtil.getPortalURL(OrganizationsUtil.getCompany().getVirtualHost(), PortalUtil.getPortalPort(), true);
		} catch (Exception e1) {
			e1.printStackTrace();
		} 
		String email = user.getEmailAddress();

		Properties props = System.getProperties();
		String mailServiceHost = "localhost";
		props.put("mail.smtp.host", mailServiceHost);
		String mailServicePort = "25";
		props.put("mail.smtp.port", mailServicePort);
		Session session = Session.getDefaultInstance(props, null);
		session.setDebug(true);
		Message mimeMessage = new MimeMessage(session);

		try {
			// EMAIL SENDER
			Address from = new InternetAddress("no-reply@d4science.org");
			mimeMessage.setFrom(from);

			Address address = new InternetAddress(email);
			mimeMessage.addRecipient(Message.RecipientType.TO, address);

			mimeMessage.setSubject(getSubjectByNotificationType(notification2Save, portalUrl, vreName));
			// mimeMessage.setText(body);
			mimeMessage.setContent(getHTMLEmail(notification2Save, user.getFirstName(), portalUrl, email), "text/html");
			mimeMessage.setSentDate(new Date());
			Transport.send(mimeMessage);
			_log.trace("notification email sent successfully");
		} catch (Exception e) {
			e.printStackTrace();
			_log.error("While sending the notification email:", e);
		}
	}

	private static String getSubjectByNotificationType(Notification notification2Save, String portalURL, String vreName) {
		//<Portal URI senza protocollo>: Shared document workflow view notification
		String portalHost = portalURL.replaceAll("https://", "");
		portalHost = portalHost.replaceAll("http://", "");
		switch (notification2Save.getType()) {
		case LIKE:
			return portalHost + ": Like on your post notification";
		case COMMENT:
			return portalHost + ": Reply on a post notification";
		case MESSAGE:
			return portalHost + ": New message notification";
		case WP_FOLDER_ADDEDUSER:
			return portalHost + ": New user in a shared folder notification";
		case WP_FOLDER_REMOVEDUSER:
			return portalHost + ": Removed user in a shared folder notification";
		case WP_FOLDER_SHARE:
			return portalHost + ": Folder sharing notification";
		case WP_ITEM_NEW:
			return portalHost + ": New item in a shared folder notification";
		case WP_ITEM_DELETE:
			return portalHost + ": Deleted item in a shared folder notification";
		case WP_ITEM_UPDATED:
			return portalHost + ": Updated item in a shared folder notification";
		case OWN_COMMENT:
			return portalHost + ": Reply on your post notification";
		case MENTION:
			return portalHost + ": Mention in a post notification";
		case REQUEST_CONNECTION:
			return portalHost + ": Connection request notification";
		case JOB_COMPLETED_NOK:
			return portalHost + ": Job Completed notification";
		case JOB_COMPLETED_OK:
			return portalHost + ": Job Completed notification";
		case DOCUMENT_WORKFLOW_EDIT:
			return portalHost + ": Shared document workflow view notification";
		case DOCUMENT_WORKFLOW_VIEW:
			return portalHost + ": Shared document workflow view notification";
		case DOCUMENT_WORKFLOW_STEP_REQUEST_TASK:
			return portalHost + " - " + vreName +": Request for task notification";
		case DOCUMENT_WORKFLOW_FIRST_STEP_REQUEST_INVOLVMENT:
			return portalHost + " - " + vreName +": Request for task notification";
		case DOCUMENT_WORKFLOW_USER_FORWARD_TO_OWNER:
			return portalHost + " - " + vreName +": Document workflow forward notification";
		case DOCUMENT_WORKFLOW_STEP_FORWARD_PEER:
			return portalHost + " - " + vreName +": Done task notification";
		case DOCUMENT_WORKFLOW_FORWARD_STEP_COMPLETED_OWNER:
			return portalHost + " - " + vreName +": Document workflow step completion notification";
		case CALENDAR_ADDED_EVENT:
			return portalHost + " - " + vreName +": New event in a shared calendar notification";
		case CALENDAR_UPDATED_EVENT:
			return portalHost + " - " + vreName +": Edited event in a shared calendar notification";
		case CALENDAR_DELETED_EVENT:
			return portalHost + " - " + vreName +": Deleted in a shared calendar notification";
		default:
			return "You have a new Notification";
		}
	}

	/**
	 * generate the clickable link
	 * @param notification2Save
	 * @param actionLink
	 * @param portalURL
	 * @return
	 */
	private static String completeActonLinkByNotificationType(Notification notification2Save, StringBuilder actionLink,  String portalURL) {
		
		actionLink.append(portalURL).append(notification2Save.getUri());  
		
		switch (notification2Save.getType()) {
		case LIKE:		
			actionLink.append("\">.").append(" See the Post").append("</a>");
			break;
		case COMMENT:
			actionLink.append("\">.").append(" See the Post").append("</a>");
			break;
		case MENTION:
			actionLink.append("\">.").append(" See the Post").append("</a>");
			break;
		case MESSAGE:
			actionLink.append("\">.").append(" Go to Message").append("</a>");
			break;
		case WP_FOLDER_ADDEDUSER:
			actionLink.append("\">.").append(" Go to Folder").append("</a>");
			break;
		case WP_FOLDER_REMOVEDUSER:
			actionLink.append("\">.").append(" Go to Folder").append("</a>");
			break;
		case WP_FOLDER_SHARE:
			actionLink.append("\">.").append(" Go to Folder").append("</a>");
			break;
		case WP_ITEM_NEW:
			actionLink.append("\">.").append(" Go to Folder").append("</a>");
			break;
		case WP_ITEM_DELETE:
			actionLink.append("\">.").append(" Go to Folder").append("</a>");
			break;
		case WP_ITEM_UPDATED:
			actionLink.append("\">.").append(" Go to Folder").append("</a>");
			break;
		case OWN_COMMENT:
			actionLink.append("\">.").append(" See the Post").append("</a>");
			break;
		case REQUEST_CONNECTION:
			actionLink.append("\">.").append(" Go to Contacts Center").append("</a>");
			break;
		case JOB_COMPLETED_NOK:
			actionLink.append("\">.").append(" Go to Application").append("</a>");
			break;
		case JOB_COMPLETED_OK:
			actionLink.append("\">.").append(" Go to Application").append("</a>");
			break;
		case DOCUMENT_WORKFLOW_EDIT:
			actionLink.append("\">.").append(" Go to Document Workflow Manager").append("</a>");
			break;
		case DOCUMENT_WORKFLOW_VIEW:
			actionLink.append("\">.").append(" Go to Document Workflow Manager").append("</a>");
			break;
		case DOCUMENT_WORKFLOW_STEP_REQUEST_TASK:
			actionLink.append("\">.").append(" Go to Your Document Workflows").append("</a>");
			break;
		case DOCUMENT_WORKFLOW_FIRST_STEP_REQUEST_INVOLVMENT:
			actionLink.append("\">.").append(" Go to Your Document Workflows").append("</a>");
			break;
		case DOCUMENT_WORKFLOW_USER_FORWARD_TO_OWNER:
			actionLink.append("\">.").append(" Go to Document Workflow Manager").append("</a>");
			break;
		case DOCUMENT_WORKFLOW_STEP_FORWARD_PEER:
			actionLink.append("\">.").append(" Go to Document Workflow Manager").append("</a>");
			break;
		case DOCUMENT_WORKFLOW_FORWARD_STEP_COMPLETED_OWNER:
			actionLink.append("\">.").append(" Go to Document Workflow Manager").append("</a>");
			break;
		default:
			actionLink.append("\">.").append("").append("</a>");
			break;			
		}
		
		return actionLink.toString();
	}
}



