package org.gcube.applicationsupportlayer.social;

import org.gcube.portal.databook.shared.Comment;
import org.gcube.portal.databook.shared.Feed;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.portlets.user.homelibrary.home.workspace.sharing.WorkspaceMessage;
/**
 * 
 * @author Massimiliano Assante, ISTI-CNR
 * @version 0.1 Dec 2012
 *
 */
public interface NotificationManager {
	/**
	 * use to notify a user he got a workspace folder shared
	 *
	 * @param userIdToNotify the user you want to notify
	 * @param sharedFolder the shared {@link WorkspaceFolder}  
	 * @return true if the notification is correctly delivered, false otherwise
	 */
	boolean notifyFolderSharing(String userIdToNotify, WorkspaceFolder sharedFolder);
	/**
	 * use to notify a user that a new user was added in on of his workspace shared folder
	 *
	 * @param userIdToNotify the user you want to notify
	 * @param sharedFolder the shared {@link WorkspaceFolder}  
	 * @param newAddedUserId the new user that was added
	 * @return true if the notification is correctly delivered, false otherwise
	 */
	boolean notifyFolderAddedUser(String userIdToNotify, WorkspaceFolder sharedFolder, String newAddedUserId);
	/**
	 * use to notify a user that an existing user was removed from one of his workspace shared folder
	 *
	 * @param userIdToNotify the user you want to notify
	 * @param sharedFolder the shared {@link WorkspaceFolder}  
	 * @param removedUserId the new user that was removed
	 * @return true if the notification is correctly delivered, false otherwise
	 */
	boolean notifyFolderRemovedUser(String userIdToNotify, WorkspaceFolder sharedFolder, String removedUserId);	
	/**
	 * use to notify a user he got a workspace item new in some of his workspace shared folder
	 * @param userIdToNotify the user you want to notify
	 * @param newItem the new shared {@link WorkspaceItem}  
	 * @return true if the notification is correctly delivered, false otherwise
	 */
	boolean notifyAddedItem(String userIdToNotify, WorkspaceItem newItem);
	/**
	 * use to notify a user he got a workspace item deleted from one of his workspace shared folder
	 * @param userIdToNotify the user you want to notify
	 * @param removedItem the removed {@link WorkspaceItem}  
	 * @return true if the notification is correctly delivered, false otherwise
	 */
	boolean notifyRemovedItem(String userIdToNotify, WorkspaceItem removedItem);
	/**
	 * use to notify a user he got a workspace item updated from one of his workspace shared folder
	 * @param userIdToNotify the user you want to notify
	 * @param updatedItem the updated shared {@link WorkspaceItem}  
	 * @return true if the notification is correctly delivered, false otherwise
	 */
	boolean notifyUpdatedItem(String userIdToNotify, WorkspaceItem updatedItem);
	/**
	 * 
	 * @param userIdToNotify the user you want to notify
	 * @param message the {@link WorkspaceMessage} sent
	 * @return true if the notification is correctly delivered, false otherwise
	 */
	boolean notifyMessageReceived(String userIdToNotify, WorkspaceMessage message);
	/**
	 * 
	 * @param userIdToNotify the user you want to notify
	 * @param comment the {@link Comment} instance to which someone replied to
	 * @return true if the notification is correctly delivered, false otherwise
	 */
	boolean notifyOwnCommentReply(String userIdToNotify, Comment comment);
	/**
	 * use to notify a user that commented on a feed (Not his) that someone commented too 
	 * 
	 * @param userIdToNotify the user you want to notify
	 * @param comment the {@link Comment} instance to which someone replied to
	 * @return true if the notification is correctly delivered, false otherwise
	 */
	boolean notifyCommentReply(String userIdToNotify, Comment comment);
	/**
	 * use to notify a user he got one of his feed liked
	 *  
	 * @param userIdToNotify the user you want to notify
	 * @param likedFeed the {@link Feed} instance someone liked
	 * @return true if the notification is correctly delivered, false otherwise
	 */
	boolean notifyLikedFeed(String userIdToNotify, Feed likedFeed);
	
}
