/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.search.library.impl;

import gr.uoa.di.madgik.grs.buffer.GRS2BufferException;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.events.BufferEvent;
import gr.uoa.di.madgik.grs.events.KeyValueEvent;
import gr.uoa.di.madgik.grs.reader.GRS2ReaderException;
import gr.uoa.di.madgik.grs.reader.GRS2ReaderInvalidArgumentException;
import gr.uoa.di.madgik.grs.reader.IRecordReader;
import gr.uoa.di.madgik.grs.reader.RandomReader;
import gr.uoa.di.madgik.grs.reader.decorators.RecordReaderDelegate;
import gr.uoa.di.madgik.grs.reader.decorators.keepalive.KeepAliveReader;
import gr.uoa.di.madgik.grs.record.GRS2RecordDefinitionException;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.element.query.QueryHelper;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.gcube.application.framework.contentmanagement.content.impl.DigitalObject;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.search.library.exception.InitialBridgingNotCompleteException;
import org.gcube.application.framework.search.library.exception.InternalErrorException;
import org.gcube.application.framework.search.library.exception.gRS2AvailableRecordsRetrievalException;
import org.gcube.application.framework.search.library.exception.gRS2BufferException;
import org.gcube.application.framework.search.library.exception.gRS2CreationException;
import org.gcube.application.framework.search.library.exception.gRS2NoRecordReadWithinTimeIntervalException;
import org.gcube.application.framework.search.library.exception.gRS2ReaderException;
import org.gcube.application.framework.search.library.exception.gRS2RecordDefinitionException;
import org.gcube.application.framework.search.library.impl.SearchHelper;
import org.gcube.application.framework.search.library.interfaces.ResultSetConsumerI;
import org.gcube.application.framework.search.library.util.DisableButtons;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSetConsumer
implements ResultSetConsumerI {
    private static final Logger logger = LoggerFactory.getLogger(ResultSetConsumer.class);
    IRecordReader<GenericRecord> reader;
    ListIterator<GenericRecord> iter;
    int pageNo = 1;
    int pageTotal = 0;
    int lastRequestedEnd = 0;
    int lastRequestedStart = 0;
    boolean out_of_end = false;
    boolean readTotal = false;
    ArrayList<String> selectedCollections;
    String rsLocator;
    String searchType;
    String genericSearchType;
    int numOfResultsRead = 0;
    boolean getTotalRead = false;
    HashMap<String, String> fieldsIDsNames = new HashMap();
    boolean onlyPresentationFields = false;
    protected static AtomicInteger SMid = new AtomicInteger();

    ResultSetConsumer() {
        this.reader = null;
        this.pageNo = 1;
        this.pageTotal = 0;
        this.lastRequestedEnd = 0;
        this.lastRequestedStart = 0;
        this.out_of_end = false;
        this.readTotal = false;
        this.selectedCollections = new ArrayList();
        this.searchType = "";
    }

    public ResultSetConsumer(String RSLocator, String searchType) throws URISyntaxException, gRS2CreationException {
        this.searchType = searchType;
        this.rsLocator = RSLocator;
        URI locator = new URI(RSLocator);
        try {
            long startTime = System.currentTimeMillis();
            this.reader = new RandomReader(locator);
            this.reader = new KeepAliveReader(this.reader, 20L, TimeUnit.SECONDS, 20L, TimeUnit.MINUTES);
            this.reader.setIteratorTimeout(1L);
            this.reader.setIteratorTimeUnit(TimeUnit.MINUTES);
            this.iter = (ListIterator)this.reader.iterator();
            long endTime = System.currentTimeMillis();
            long diff = endTime - startTime;
            logger.debug("Portal Benchmarking - Time to get the RandomReader from ResultSet: " + diff);
        }
        catch (GRS2ReaderException e) {
            throw new gRS2CreationException(e);
        }
        catch (GRS2ReaderInvalidArgumentException e) {
            throw new gRS2CreationException(e);
        }
    }

    public static void removeSessionVariables(ASLSession session) {
        logger.info("Removing session variables");
        session.removeAttribute("page_no");
        session.removeAttribute("page_total");
        session.removeAttribute("lastRes");
        session.removeAttribute("isLast");
        session.removeAttribute("out_of_end");
        session.removeAttribute("rsClient");
        session.removeAttribute("theResultObjects");
        session.removeAttribute("theThumbnails");
        session.removeAttribute("startingPoint");
        session.removeAttribute("sourcePortlet");
        session.removeAttribute("rsEPR");
        session.removeAttribute("showRank");
        session.removeAttribute("searchException");
        session.removeAttribute("QeuryIndexToPresent");
        session.removeAttribute("selectedCriteriaNames");
    }

    @Override
    public List<DigitalObject> getFirst(int n, DisableButtons dis, ASLSession session) throws gRS2NoRecordReadWithinTimeIntervalException, gRS2RecordDefinitionException, gRS2ReaderException, gRS2AvailableRecordsRetrievalException, InitialBridgingNotCompleteException, InternalErrorException {
        List<GenericRecord> results;
        logger.debug("Get First results!");
        long startTime = System.currentTimeMillis();
        dis.setBack(true);
        try {
            long startTimeReadRs = System.currentTimeMillis();
            results = this.readRS(n, dis, false);
            long endTimeReadRs = System.currentTimeMillis();
            long diffReadRs = endTimeReadRs - startTimeReadRs;
            logger.debug("Portal Benchmarking - Reading first Results Time: " + diffReadRs);
        }
        catch (GRS2ReaderException e1) {
            throw new gRS2ReaderException(e1);
        }
        try {
            if (this.reader.availableRecords() == 0) {
                dis.setForward(true);
            }
        }
        catch (GRS2ReaderException e1) {
            throw new gRS2AvailableRecordsRetrievalException(e1);
        }
        List<DigitalObject> resultsList = null;
        try {
            resultsList = this.transformToHTML(session, results);
        }
        catch (GRS2RecordDefinitionException e) {
            throw new gRS2RecordDefinitionException(e);
        }
        catch (GRS2BufferException e) {
            logger.error("Exception while consuming the resultset", (Throwable)e);
        }
        long endTime = System.currentTimeMillis();
        long diff = endTime - startTime;
        logger.debug("Portal Benchmarking - First page available: " + diff);
        if (results != null && results.size() != 0) {
            try {
                BufferEvent ev = this.reader.receive();
                while (ev != null) {
                    KeyValueEvent kvev = (KeyValueEvent)ev;
                    if (kvev != null) {
                        String key = kvev.getKey();
                        if (key.equals("resultsNumber")) {
                            this.numOfResultsRead = Integer.parseInt(kvev.getValue());
                        }
                        if (key.equals("resultsNumberFinal")) {
                            this.numOfResultsRead = Integer.parseInt(kvev.getValue());
                            this.getTotalRead = true;
                        }
                    }
                    ev = this.reader.receive();
                }
            }
            catch (GRS2ReaderException e) {
                logger.error("Exception while consuming the resultset", (Throwable)e);
            }
        } else {
            this.numOfResultsRead = 0;
            this.getTotalRead = true;
        }
        return resultsList;
    }

    @Override
    public List<DigitalObject> getNext(int n, DisableButtons dis, ASLSession session) throws gRS2NoRecordReadWithinTimeIntervalException, gRS2RecordDefinitionException, gRS2ReaderException, gRS2AvailableRecordsRetrievalException, InitialBridgingNotCompleteException, InternalErrorException {
        List<GenericRecord> results;
        logger.debug("Get Next results!");
        dis.setBack(false);
        try {
            results = this.readRS(n, dis, false);
        }
        catch (GRS2ReaderException e1) {
            throw new gRS2ReaderException(e1);
        }
        List<DigitalObject> resultsList = null;
        try {
            resultsList = this.transformToHTML(session, results);
        }
        catch (GRS2RecordDefinitionException e) {
            throw new gRS2RecordDefinitionException(e);
        }
        catch (GRS2BufferException e) {
            logger.error("Exception:", (Throwable)e);
        }
        try {
            BufferEvent ev = this.reader.receive();
            while (ev != null) {
                KeyValueEvent kvev = (KeyValueEvent)ev;
                if (kvev != null) {
                    String key = kvev.getKey();
                    if (key.equals("resultsNumber")) {
                        this.numOfResultsRead = Integer.parseInt(kvev.getValue());
                        break;
                    }
                    if (key.equals("resultsNumberFinal")) {
                        this.numOfResultsRead = Integer.parseInt(kvev.getValue());
                        this.getTotalRead = true;
                        break;
                    }
                }
                ev = this.reader.receive();
            }
        }
        catch (GRS2ReaderException e) {
            logger.error("Exception:", (Throwable)e);
        }
        return resultsList;
    }

    @Override
    public List<DigitalObject> getPrevious(int n, DisableButtons dis, ASLSession session) throws gRS2NoRecordReadWithinTimeIntervalException, gRS2RecordDefinitionException, gRS2ReaderException, gRS2AvailableRecordsRetrievalException, InitialBridgingNotCompleteException, InternalErrorException {
        List<GenericRecord> results;
        logger.debug("Get previous results.");
        dis.setForward(false);
        try {
            results = this.readRS(n, dis, true);
        }
        catch (GRS2ReaderException e1) {
            throw new gRS2ReaderException(e1);
        }
        List<DigitalObject> resultsList = null;
        try {
            resultsList = this.transformToHTML(session, results);
        }
        catch (GRS2RecordDefinitionException e) {
            throw new gRS2RecordDefinitionException(e);
        }
        catch (GRS2BufferException e) {
            logger.error("Exception:", (Throwable)e);
        }
        return resultsList;
    }

    private List<DigitalObject> transformToHTML(ASLSession session, List<GenericRecord> results) throws GRS2RecordDefinitionException, GRS2BufferException, InitialBridgingNotCompleteException, InternalErrorException {
        ArrayList<DigitalObject> resultsList = new ArrayList<DigitalObject>();
        HashMap<String, String> idsNames = new HashMap<String, String>();
        long startTime = System.currentTimeMillis();
        logger.debug("Inside transform to HTML");
        for (int i = 0; i < results.size(); ++i) {
            StringField docURI = (StringField)results.get(i).getField("ObjectID");
            Field RankID = results.get(i).getField("rank");
            StringField rankId = (StringField)RankID;
            Field CollID = results.get(i).getField("gDocCollectionID");
            StringField colId = null;
            if (CollID != null) {
                colId = (StringField)CollID;
            }
            SearchHelper sh = new SearchHelper(session);
            DigitalObject resRec = null;
            if (colId == null) {
                logger.debug("the collection ID is null");
                if (docURI != null) {
                    logger.debug("Creating digital object - the gDocCollection id is NULL: " + docURI.getPayload());
                    resRec = new DigitalObject(session, docURI.getPayload());
                } else {
                    logger.debug("The docId is null - probably browse distinct");
                    resRec = new DigitalObject(session, "", "");
                }
            } else if (docURI != null) {
                logger.debug("Creating digital object - the gDocCollection id is NOT null: " + docURI.getPayload());
                resRec = new DigitalObject(session, docURI.getPayload(), colId.getPayload());
            } else {
                resRec = new DigitalObject(session, "", colId.getPayload());
            }
            String htmlRepresentation = new String();
            logger.debug("Display detailed result? --> " + session.getAttribute("sessionDetailedResult"));
            if (session.getAttribute("sessionDetailedResult") != null && (((Boolean)session.getAttribute("sessionDetailedResult")).booleanValue() || this.searchType.equals("browseFields") || this.searchType.equals("browse"))) {
                ArrayList presentationIds = (ArrayList)session.getAttribute("presentationFields");
                if (presentationIds != null && presentationIds.size() != 0) {
                    for (int j = 0; j < presentationIds.size(); ++j) {
                        Field fld = results.get(i).getField((String)presentationIds.get(j));
                        StringField stringField = (StringField)fld;
                        if (fld == null) continue;
                        String name = (String)idsNames.get(fld.getFieldDefinition().getName());
                        if (name == null || name.equals("")) {
                            try {
                                name = QueryHelper.GetFieldNameById((String)fld.getFieldDefinition().getName());
                            }
                            catch (ResourceRegistryException e) {
                                logger.error("Error while retrieving field name", (Throwable)e);
                            }
                            idsNames.put(fld.getFieldDefinition().getName(), name);
                        }
                        if (name.trim().equalsIgnoreCase("S")) {
                            name = "Snippet";
                            stringField.setPayload(this.handleSnippetValue(stringField.getPayload()));
                        }
                        if (stringField.getPayload() != null && stringField.getPayload().length() > 370) {
                            String smallDescription = stringField.getPayload().substring(0, 369);
                            htmlRepresentation = htmlRepresentation + "<p><b>" + name + ":</b> " + smallDescription + "..." + "</p>";
                        } else if (stringField.getPayload() != null && !stringField.getPayload().equals("")) {
                            logger.info("Description was " + stringField.getPayload());
                            htmlRepresentation = htmlRepresentation + "<p><b>" + name + ":</b> " + stringField.getPayload() + "</p>";
                        }
                        if (resRec.getTitle() != null && !resRec.getTitle().equals("") || stringField == null || stringField.getPayload() == null) continue;
                        if (stringField.getPayload().length() > 40) {
                            resRec.setTitle(name + ": " + stringField.getPayload().substring(0, 40));
                            continue;
                        }
                        resRec.setTitle(name + ": " + stringField.getPayload());
                    }
                    logger.debug("Record's HTML representation --> " + htmlRepresentation);
                    resRec.setHTMLRepresentation(htmlRepresentation);
                    resultsList.add(resRec);
                    continue;
                }
                Field[] allFields = results.get(i).getFields();
                for (int k = 0; k < allFields.length; ++k) {
                    try {
                        logger.debug("Looking for name of the field: " + allFields[k].getFieldDefinition().getName());
                        String name = QueryHelper.GetFieldNameById((String)allFields[k].getFieldDefinition().getName());
                        logger.debug("The name is: " + name);
                        if (name == null || name.equals("ObjectID") || name.equals("rank") || name.equals("gDocCollectionID")) continue;
                        StringField stringField = (StringField)allFields[k];
                        htmlRepresentation = htmlRepresentation + "<p><b>" + name + ":</b> " + stringField.getPayload() + "</p>";
                        if (resRec.getTitle() != null && !resRec.getTitle().equals("")) continue;
                        if (stringField.getPayload().length() > 40) {
                            resRec.setTitle(name + ": " + stringField.getPayload().substring(0, 40));
                            continue;
                        }
                        resRec.setTitle(name + ": " + stringField.getPayload());
                        continue;
                    }
                    catch (ResourceRegistryException e) {
                        logger.error("Error while retrieving field name", (Throwable)e);
                    }
                }
                resRec.setHTMLRepresentation(htmlRepresentation);
                resultsList.add(resRec);
                continue;
            }
            Field titleField = results.get(i).getField((String)session.getAttribute("session_title_attr"));
            Field snippetField = results.get(i).getField((String)session.getAttribute("session_snippet_attr"));
            if (titleField != null) {
                StringField stringField = (StringField)titleField;
                String titlePayload = stringField.getPayload();
                logger.debug("Title field payload -> " + titlePayload);
                resRec.setTitle(titlePayload);
                htmlRepresentation = htmlRepresentation + "<p><h5 style=\"color: darkblue;\">" + titlePayload + "</h5></p>";
            }
            if (snippetField != null) {
                StringField stringField = (StringField)snippetField;
                String snippetPayload = this.handleSnippetValue(stringField.getPayload());
                logger.debug("Snippet field payload -> " + snippetPayload);
                htmlRepresentation = htmlRepresentation + "<p style=\"color:#333333;  word-wrap: break-word;\">" + snippetPayload + "</p>";
            }
            logger.debug("Record's HTML representation --> " + htmlRepresentation);
            resRec.setHTMLRepresentation(htmlRepresentation);
            resultsList.add(resRec);
        }
        long endTime = System.currentTimeMillis();
        long diff = endTime - startTime;
        logger.debug("Portal Benchmarking - Records Transformation for Presentation (for whole page): " + diff);
        logger.info("---------------------------The number of results returned are: " + resultsList.size());
        return resultsList;
    }

    private String handleSnippetValue(String snippetValue) {
        String newValue;
        logger.debug("Handling the snippet value came from search --> " + snippetValue);
        String currentPayload = newValue = snippetValue.replaceAll("&amp;gt;", ">").replaceAll("&amp;lt;", "<");
        if (currentPayload.length() > 370) {
            int index;
            for (index = 362; index < 365 && currentPayload.charAt(index) != '<'; ++index) {
            }
            String newPayload = currentPayload.substring(0, index);
            newValue = newPayload = newPayload + "</b>";
        }
        return newValue;
    }

    @Override
    public List<String> getResultsToText(int n, int offset, ASLSession session) throws gRS2ReaderException, gRS2RecordDefinitionException, gRS2BufferException {
        int diff;
        int currentPlace;
        try {
            currentPlace = (int)this.reader.currentRecord();
        }
        catch (GRS2ReaderException e) {
            logger.error("Error while getting current place in ResultSet", (Throwable)e);
            throw new gRS2ReaderException(e);
        }
        logger.debug("Current Place of ResultSet: " + currentPlace + " and offset is: " + offset);
        logger.info("Current Place of ResultSet: " + currentPlace + " and offset is: " + offset);
        if (offset < 0) {
            return new ArrayList<String>();
        }
        if (offset > currentPlace) {
            diff = offset - currentPlace;
            logger.debug("Seeking to: " + diff);
            logger.info("Seeking to: " + diff);
            try {
                this.reader.seek((long)diff);
            }
            catch (GRS2ReaderException e) {
                logger.error("Error while seeking resultSet.", (Throwable)e);
                logger.info("Error while seeking resultSet.");
                throw new gRS2ReaderException(e);
            }
        }
        diff = currentPlace - offset;
        logger.debug("Seeking to: -" + diff);
        logger.info("Seeking to: -" + diff);
        try {
            this.reader.seek((long)(-diff));
        }
        catch (GRS2ReaderException e) {
            logger.error("Error while seeking resultSet.", (Throwable)e);
            logger.info("Error while seeking resultSet.");
            throw new gRS2ReaderException(e);
        }
        ArrayList<String> recs = new ArrayList();
        try {
            recs = this.read(n, session);
        }
        catch (GRS2RecordDefinitionException e) {
            logger.error("Error while reading resultSet.", (Throwable)e);
            throw new gRS2RecordDefinitionException(e);
        }
        catch (GRS2ReaderException e) {
            logger.error("Error while reading resultSet.", (Throwable)e);
            throw new gRS2ReaderException(e);
        }
        catch (GRS2BufferException e) {
            logger.error("Error while reading resultSet.", (Throwable)e);
            throw new gRS2BufferException(e);
        }
        catch (ResourceRegistryException e) {
            logger.error("Error while reading field names from registry.", (Throwable)e);
            throw new gRS2BufferException(e);
        }
        return recs;
    }

    @Override
    public void setOnlyPresentables() {
        this.onlyPresentationFields = true;
    }

    private List<String> read(int count, ASLSession session) throws GRS2ReaderException, GRS2RecordDefinitionException, GRS2BufferException, ResourceRegistryException {
        GenericRecord rec;
        if (!this.onlyPresentationFields) {
            GenericRecord rec2;
            ArrayList<String> records = new ArrayList<String>();
            for (int i = 0; i < count && this.reader.getStatus() != IBuffer.Status.Dispose && (this.reader.getStatus() != IBuffer.Status.Close || this.reader.availableRecords() != 0) && (rec2 = (GenericRecord)this.reader.get(30L, TimeUnit.SECONDS)) != null; ++i) {
                String recString = "<RSRecord>";
                Field[] fields = rec2.getFields();
                for (int j = 0; j < fields.length; ++j) {
                    StringField stringField = (StringField)fields[j];
                    String stringValue = stringField.getPayload();
                    String roundTrip = null;
                    try {
                        if (stringValue != null) {
                            byte[] utf8Bytes = stringValue.getBytes("UTF8");
                            roundTrip = new String(utf8Bytes, "UTF8");
                        }
                    }
                    catch (UnsupportedEncodingException e) {
                        logger.error("Exception:", (Throwable)e);
                    }
                    String key = fields[j].getFieldDefinition().getName();
                    String name = null;
                    if (!this.fieldsIDsNames.containsKey(key)) {
                        name = QueryHelper.GetFieldNameById((String)fields[j].getFieldDefinition().getName());
                        this.fieldsIDsNames.put(fields[j].getFieldDefinition().getName(), name);
                    } else {
                        name = this.fieldsIDsNames.get(key);
                    }
                    recString = roundTrip == null ? recString + "<field><fieldId>" + fields[j].getFieldDefinition().getName() + "</fieldId><fieldValue>" + stringField.getPayload() + "</fieldValue><fieldName>" + name + "</fieldName></field>" : recString + "<field><fieldId>" + fields[j].getFieldDefinition().getName() + "</fieldId><fieldValue>" + roundTrip + "</fieldValue><fieldName>" + name + "</fieldName></field>";
                }
                recString = recString + "</RSRecord>";
                records.add(recString);
            }
            return records;
        }
        ArrayList<String> records = new ArrayList<String>();
        HashMap<String, String> idsNames = new HashMap<String, String>();
        for (int i = 0; i < count && this.reader.getStatus() != IBuffer.Status.Dispose && (this.reader.getStatus() != IBuffer.Status.Close || this.reader.availableRecords() != 0) && (rec = (GenericRecord)this.reader.get(30L, TimeUnit.SECONDS)) != null; ++i) {
            DigitalObject mDO;
            Field DocId = rec.getField("ObjectID");
            StringField docId = (StringField)DocId;
            Field RankID = rec.getField("rank");
            StringField rankId = (StringField)RankID;
            Field CollID = rec.getField("gDocCollectionID");
            StringField colId = null;
            String colIdRecord = null;
            String recString = "<RSRecord>";
            ArrayList presentationIds = (ArrayList)session.getAttribute("presentationFields");
            if (presentationIds != null && presentationIds.size() != 0) {
                for (int j = 0; j < presentationIds.size(); ++j) {
                    Field fld = rec.getField((String)presentationIds.get(j));
                    StringField stringField = (StringField)fld;
                    if (fld == null) continue;
                    String name = (String)idsNames.get(fld.getFieldDefinition().getName());
                    if (name == null || name.equals("")) {
                        try {
                            name = QueryHelper.GetFieldNameById((String)fld.getFieldDefinition().getName());
                        }
                        catch (ResourceRegistryException e) {
                            logger.error("Error while retrieving field name", (Throwable)e);
                        }
                        idsNames.put(fld.getFieldDefinition().getName(), name);
                    }
                    recString = recString + "<field><fieldId>" + fld.getFieldDefinition().getName() + "</fieldId><fieldValue>" + stringField.getPayload() + "</fieldValue><fieldName>" + name + "</fieldName></field>";
                }
            }
            String docIdRecord = "<field><fieldId>" + DocId.getFieldDefinition().getName() + "</fieldId><fieldValue>" + docId.getPayload() + "</fieldValue><fieldName>" + "ObjectID" + "</fieldName></field>";
            if (CollID != null) {
                colId = (StringField)CollID;
                colIdRecord = "<field><fieldId>";
                if (CollID.getFieldDefinition() != null && CollID.getFieldDefinition().getName() != null) {
                    colIdRecord = colIdRecord + CollID.getFieldDefinition().getName();
                }
                colIdRecord = colIdRecord + "</fieldId><fieldValue>";
                if (colId != null && colId.getPayload() != null) {
                    colIdRecord = colIdRecord + colId.getPayload();
                }
                colIdRecord = colIdRecord + "</fieldValue><fieldName>gDocCollectionID</fieldName></field>";
            }
            recString = recString + docIdRecord;
            if (colIdRecord != null) {
                recString = recString + colIdRecord;
            }
            if (colId == null) {
                logger.debug("the gDocCollection id is: ");
                logger.debug("Creating digital object - the gDocCollection id is NULL: " + docId.getPayload());
                mDO = new DigitalObject(session, docId.getPayload());
            } else {
                logger.debug("Creating digital object - the gDocCollection id is NOT null: " + docId.getPayload());
                mDO = new DigitalObject(session, docId.getPayload(), colId.getPayload());
            }
            String mimeRecord = "<field><fieldId>mimeId</fieldId><fieldValue>" + mDO.getMimeType() + "</fieldValue><fieldName>" + "mimeType" + "</fieldName></field>";
            recString = recString + mimeRecord;
            recString = recString + "</RSRecord>";
            records.add(recString);
        }
        return records;
    }

    @Override
    public void setWindowSize(int windowSize) throws GRS2ReaderInvalidArgumentException {
        if (!(this.reader instanceof RecordReaderDelegate)) {
            throw new GRS2ReaderInvalidArgumentException("Reader not instance of RecordReaderDelegate");
        }
        ((RecordReaderDelegate)this.reader).changeWindowSize(windowSize);
    }

    private List<GenericRecord> readRS(int count, DisableButtons dis, boolean back) throws GRS2ReaderException, gRS2NoRecordReadWithinTimeIntervalException {
        if (!back) {
            ArrayList<GenericRecord> results = new ArrayList<GenericRecord>();
            for (int i = 0; this.iter.hasNext() && i < count; ++i) {
                GenericRecord rec = this.iter.next();
                if (rec == null) {
                    dis.setForward(true);
                    break;
                }
                results.add(rec);
            }
            if (!this.iter.hasNext()) {
                dis.setForward(true);
            }
            return results;
        }
        ArrayList<GenericRecord> results = new ArrayList<GenericRecord>();
        for (int i = 0; this.iter.hasPrevious() && i < count; ++i) {
            GenericRecord rec = this.iter.previous();
            if (rec == null) {
                dis.setForward(true);
                break;
            }
            results.add(rec);
        }
        if (!this.iter.hasNext()) {
            dis.setForward(true);
        }
        return results;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ArrayList<DigitalObject> getAllResultIds(ASLSession session) {
        ArrayList<DigitalObject> rsIds = new ArrayList<DigitalObject>();
        try {
            while (this.reader.getStatus() != IBuffer.Status.Dispose && (this.reader.getStatus() != IBuffer.Status.Close || this.reader.availableRecords() != 0)) {
                GenericRecord rec = (GenericRecord)this.reader.get(120L, TimeUnit.SECONDS);
                try {
                    Field DocId = rec.getField("ObjectID");
                    StringField docId = (StringField)DocId;
                    Field CollID = rec.getField("gDocCollectionID");
                    StringField colId = null;
                    if (CollID != null) {
                        colId = (StringField)CollID;
                    }
                    DigitalObject dobj = new DigitalObject(session, docId.getPayload(), colId.getPayload());
                    Field[] flds = rec.getFields();
                    for (int i = 0; i < flds.length; ++i) {
                        try {
                            String name = QueryHelper.GetFieldNameById((String)flds[i].getFieldDefinition().getName());
                            if (name != null && name.equals("guid")) {
                                StringField strFld = (StringField)flds[i];
                                logger.debug("The guid is: " + name);
                                continue;
                            }
                            if (name != null) continue;
                            logger.debug("The guid is null");
                            continue;
                        }
                        catch (ResourceRegistryException e) {
                            logger.error("Exception:", (Throwable)e);
                        }
                    }
                    rsIds.add(dobj);
                }
                catch (GRS2RecordDefinitionException e) {
                    logger.error("Exception:", (Throwable)e);
                }
                catch (GRS2BufferException e) {
                    logger.error("Exception:", (Throwable)e);
                }
            }
            logger.debug("Returning number of all ids: " + rsIds.size());
            return rsIds;
        }
        catch (GRS2ReaderException e) {
            logger.error("Exception:", (Throwable)e);
        }
        return rsIds;
    }

    @Override
    public void setGenericSearchType(String gst) {
        this.genericSearchType = gst;
    }

    @Override
    public int getNumOfResultsRead() {
        return this.numOfResultsRead;
    }

    @Override
    public boolean getTotalRead() {
        return this.readTotal;
    }
}

