package org.gcube.application.framework.search.library.impl;

import gr.uoa.di.madgik.grs.buffer.GRS2BufferException;
import gr.uoa.di.madgik.grs.buffer.IBuffer.Status;
import gr.uoa.di.madgik.grs.events.BufferEvent;
import gr.uoa.di.madgik.grs.events.KeyValueEvent;
import gr.uoa.di.madgik.grs.reader.GRS2ReaderException;
import gr.uoa.di.madgik.grs.reader.GRS2ReaderInvalidArgumentException;
import gr.uoa.di.madgik.grs.reader.IRecordReader;
import gr.uoa.di.madgik.grs.reader.RandomReader;
import gr.uoa.di.madgik.grs.reader.decorators.RecordReaderDelegate;
import gr.uoa.di.madgik.grs.reader.decorators.keepalive.KeepAliveReader;
import gr.uoa.di.madgik.grs.record.GRS2RecordDefinitionException;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.element.query.QueryHelper;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

import org.gcube.application.framework.contentmanagement.content.impl.DigitalObject;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.util.SessionConstants;
import org.gcube.application.framework.search.library.exception.InitialBridgingNotCompleteException;
import org.gcube.application.framework.search.library.exception.InternalErrorException;
import org.gcube.application.framework.search.library.exception.gRS2AvailableRecordsRetrievalException;
import org.gcube.application.framework.search.library.exception.gRS2BufferException;
import org.gcube.application.framework.search.library.exception.gRS2CreationException;
import org.gcube.application.framework.search.library.exception.gRS2NoRecordReadWithinTimeIntervalException;
import org.gcube.application.framework.search.library.exception.gRS2ReaderException;
import org.gcube.application.framework.search.library.exception.gRS2RecordDefinitionException;
import org.gcube.application.framework.search.library.interfaces.ResultSetConsumerI;
import org.gcube.application.framework.search.library.model.CollectionInfo;
import org.gcube.application.framework.search.library.util.DisableButtons;
import org.gcube.application.framework.search.library.util.FindFieldsInfo;
import org.gcube.application.framework.search.library.util.SearchConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSetConsumer implements ResultSetConsumerI{

	/** The logger. */
	private static final Logger logger = LoggerFactory.getLogger(ResultSetConsumer.class);

	IRecordReader<GenericRecord> reader;
	ListIterator<GenericRecord> iter;
	int pageNo = 1;
	int pageTotal = 0;
	int lastRequestedEnd = 0;
	int lastRequestedStart = 0;
	boolean out_of_end = false;
	boolean readTotal = false;
	ArrayList<String> selectedCollections;
	String rsLocator;
	String searchType;
	String genericSearchType;
	int numOfResultsRead = 0;
	boolean getTotalRead = false;
	HashMap<String, String> fieldsIDsNames = new HashMap<String, String>();
	boolean onlyPresentationFields = false;

	protected static AtomicInteger SMid = new AtomicInteger();

	ResultSetConsumer() {
		reader = null;
		pageNo = 1;
		pageTotal = 0;
		lastRequestedEnd = 0;
		lastRequestedStart = 0;
		out_of_end = false;
		readTotal = false;
		selectedCollections = new ArrayList<String>();
		searchType = "";
	}

	public ResultSetConsumer(String RSLocator, String searchType) throws URISyntaxException, gRS2CreationException {
		this.searchType = searchType;
		rsLocator = RSLocator;

		URI locator = new URI(RSLocator);
		try {
			long startTime = System.currentTimeMillis();
			reader = new RandomReader<GenericRecord>(locator);
			reader = new KeepAliveReader<GenericRecord>(reader, 20, TimeUnit.SECONDS, 20, TimeUnit.MINUTES);
			reader.setIteratorTimeout(1);
			reader.setIteratorTimeUnit(TimeUnit.MINUTES);
			iter = (ListIterator<GenericRecord>) reader.iterator();
			long endTime = System.currentTimeMillis();
			long diff = endTime - startTime;
			logger.debug("Portal Benchmarking - Time to get the RandomReader from ResultSet: " + diff);
		} catch (GRS2ReaderException e) {
			throw new gRS2CreationException(e);
		} catch (GRS2ReaderInvalidArgumentException e) {
			throw new gRS2CreationException(e);
		}
	}


	/**
	 * @param session the D4Science session to be used in order to remove the attributes
	 */
	public static void removeSessionVariables(ASLSession session) {
		logger.info("Removing session variables");
		session.removeAttribute(SessionConstants.page_no);
		session.removeAttribute(SessionConstants.page_total);
		session.removeAttribute(SessionConstants.lastRes);
		session.removeAttribute(SessionConstants.isLast);
		session.removeAttribute(SessionConstants.out_of_end);
		session.removeAttribute(SessionConstants.rsClient);
		session.removeAttribute(SessionConstants.theResultObjects);
		session.removeAttribute(SessionConstants.theThumbnails);
		session.removeAttribute(SessionConstants.startingPoint);
		session.removeAttribute(SessionConstants.sourcePortlet); 
		session.removeAttribute(SessionConstants.rsEPR);
		session.removeAttribute(SessionConstants.showRank);
		session.removeAttribute(SessionConstants.searchException);
		session.removeAttribute("QeuryIndexToPresent");
		session.removeAttribute("selectedCriteriaNames");
	}


	public List<DigitalObject> getFirst(int n, DisableButtons dis, ASLSession session) throws gRS2NoRecordReadWithinTimeIntervalException, gRS2RecordDefinitionException, gRS2ReaderException, gRS2AvailableRecordsRetrievalException, InitialBridgingNotCompleteException, InternalErrorException {

		logger.debug("Get First results!");
		long startTime = System.currentTimeMillis();
		dis.setBack(true);

		// Read first n results
		List<GenericRecord> results;
		try {
			long startTimeReadRs = System.currentTimeMillis();
			results = readRS(n, dis, false);
			long endTimeReadRs = System.currentTimeMillis();
			long diffReadRs = endTimeReadRs - startTimeReadRs;
			logger.debug("Portal Benchmarking - Reading Results Time: " + diffReadRs);
		} catch (GRS2ReaderException e1) {
			throw new gRS2ReaderException(e1);
		}
		try {
			if (reader.availableRecords() == 0)
				dis.setForward(true);
		} catch (GRS2ReaderException e1) {
			throw new gRS2AvailableRecordsRetrievalException(e1);
		}

		List<DigitalObject> resultsList = null;
		try {
			resultsList = transformToHTML(session, results);
		} catch (GRS2RecordDefinitionException e) {
			throw new gRS2RecordDefinitionException(e);
		} catch (GRS2BufferException e) {
			// TODO Auto-generated catch block
			logger.error("Exception:", e);
		}
		long endTime = System.currentTimeMillis();
		long diff = endTime - startTime;
		logger.debug("Portal Benchmarking - First page available: " + diff);
		if (results != null && results.size() != 0) {
			try {
				BufferEvent ev = reader.receive();
				while (ev != null) {
					KeyValueEvent kvev = (KeyValueEvent) ev;
					if (kvev != null) {
						String key = kvev.getKey();
						if (key.equals("resultsNumber")) {
							numOfResultsRead = Integer.parseInt(kvev.getValue());
							break;
						}
						else if (key.equals("resultsNumberFinal")) {
							numOfResultsRead = Integer.parseInt(kvev.getValue());
							getTotalRead = true;
							break;
						}
					}
					ev = reader.receive();
				}
			} catch (GRS2ReaderException e) {
				// TODO Auto-generated catch block
				logger.error("Exception:", e);
			}
		} else {
			numOfResultsRead = 0;
			getTotalRead = true;
		}
		return resultsList;

	}

	public List<DigitalObject> getNext(int n, DisableButtons dis, ASLSession session) throws gRS2NoRecordReadWithinTimeIntervalException, gRS2RecordDefinitionException, gRS2ReaderException, gRS2AvailableRecordsRetrievalException, InitialBridgingNotCompleteException, InternalErrorException {

		logger.debug("Get Next results!");
		dis.setBack(false);

		// Read first n results
		List<GenericRecord> results;
		try {
			results = readRS(n, dis, false);
		} catch (GRS2ReaderException e1) {
			throw new gRS2ReaderException(e1);
		}
		//		 try {
		//			if (reader.availableRecords() == 0)
		//				 dis.setForward(true);
		//		} catch (GRS2ReaderException e1) {
		//			throw new gRS2AvailableRecordsRetrievalException(e1);
		//		}

		List<DigitalObject> resultsList = null;
		try {
			resultsList = transformToHTML(session, results);
		} catch (GRS2RecordDefinitionException e) {
			throw new gRS2RecordDefinitionException(e);
		} catch (GRS2BufferException e) {
			// TODO Auto-generated catch block
			logger.error("Exception:", e);
		}

		try {
			BufferEvent ev = reader.receive();
			while (ev != null) {
				KeyValueEvent kvev = (KeyValueEvent) ev;
				if (kvev != null) {
					String key = kvev.getKey();
					if (key.equals("resultsNumber")) {
						numOfResultsRead = Integer.parseInt(kvev.getValue());
						break;
					}
					else if (key.equals("resultsNumberFinal")) {
						numOfResultsRead = Integer.parseInt(kvev.getValue());
						getTotalRead = true;
						break;
					}
				}
				ev = reader.receive();
			}
		} catch (GRS2ReaderException e) {
			// TODO Auto-generated catch block
			logger.error("Exception:", e);
		}
		return resultsList;

	}

	public List<DigitalObject> getPrevious(int n, DisableButtons dis, ASLSession session) throws gRS2NoRecordReadWithinTimeIntervalException, gRS2RecordDefinitionException, gRS2ReaderException, gRS2AvailableRecordsRetrievalException, InitialBridgingNotCompleteException, InternalErrorException {

		logger.debug("Get previous results.");
		List<GenericRecord> results;
		dis.setForward(false);
		try {
			results = readRS(n, dis, true);
		} catch (GRS2ReaderException e1) {
			throw new gRS2ReaderException(e1);
		}
		//		 try {
		//			if (reader.availableRecords() == 0)
		//				 dis.setForward(true);
		//		} catch (GRS2ReaderException e1) {
		//			throw new gRS2AvailableRecordsRetrievalException(e1);
		//		}

		List<DigitalObject> resultsList = null;
		try {
			resultsList = transformToHTML(session, results);
		} catch (GRS2RecordDefinitionException e) {
			throw new gRS2RecordDefinitionException(e);
		} catch (GRS2BufferException e) {
			// TODO Auto-generated catch block
			logger.error("Exception:", e);
		}
		return resultsList;

	}


	private List<DigitalObject> transformToHTML(ASLSession session, List<GenericRecord> results) throws GRS2RecordDefinitionException, GRS2BufferException, InitialBridgingNotCompleteException, InternalErrorException {
		List<DigitalObject> resultsList = new ArrayList<DigitalObject>();
		HashMap<String, String> idsNames = new HashMap<String, String>();
		long startTime = System.currentTimeMillis();
		logger.debug("Inside transform to HTML");
		for (int i = 0; i < results.size(); i++) {
			// Get the fields we need
			//Field docURI = results.get(i).getField("ObjectID");
			StringField docURI = (StringField)results.get(i).getField("ObjectID");;
			Field RankID = results.get(i).getField("rank");
			StringField rankId = (StringField)RankID;
			Field CollID = results.get(i).getField("gDocCollectionID");
			StringField colId = null;
			if (CollID != null)
				colId = (StringField)CollID;

			SearchHelper sh = new SearchHelper(session);

			DigitalObject resRec = null;
			if (colId == null) {
				logger.debug("the gDocCollection id is: ");
				if (docURI != null) {
					logger.debug("Creating digital object - the gDocCollection id is NULL: " + docURI.getPayload());
					resRec = new DigitalObject(session, docURI.getPayload());
				} else {
					logger.debug("The docId is null - probably browse distinct");
					resRec = new DigitalObject(session, "", "");
				}
				// set the collection info
				String cid = resRec.getCollectionID();
				logger.debug("cid: " + cid);
				CollectionInfo colI = sh.findCollectionInfo(cid);
				String colName;
				if (colI == null)
					colName = FindFieldsInfo.findCollectionName(cid, session.getScopeName());
				else
					colName = colI.getName();
				//resRec.setCollectionName(colName);
			}
			else {
				if (docURI != null) {
					logger.debug("Creating digital object - the gDocCollection id is NOT null: " + docURI.getPayload());
					resRec = new DigitalObject(session, docURI.getPayload(), colId.getPayload());
				} else {
					resRec = new DigitalObject(session, "", colId.getPayload());
				}
				CollectionInfo colI = sh.findCollectionInfo(colId.getPayload());
				//resRec.setCollectionName(colI.getName());
			}
			//CollectionInfo colInfo = sh.findCollectionInfo(resRec.getCollectionID());
			//resRec.setCollectionID(colId.getPayload());
			//resRec.setCollectionName(colInfo.getName());

			//if (rankId != null)
			//	resRec.setRank(rankId.getPayload());

			// TODO:
			// get all the fields except from the ones that will not be shown, apply the xslt to transform to html
			// set to html representation
			// add to resultsList
			String htmlRepresentation = new String();
			ArrayList<String> presentationIds = (ArrayList<String>)session.getAttribute("presentationFields");
			if (presentationIds != null && presentationIds.size() != 0) {
				for (int j = 0; j < presentationIds.size(); j++) {
					Field fld = results.get(i).getField(presentationIds.get(j));
					StringField stringField = (StringField) fld;

					if (fld != null) {		// there might be a case where we have asked for a field that cannot be presented
						String name = idsNames.get(fld.getFieldDefinition().getName());
						if (name == null || name.equals("")) {
							try {
								name = QueryHelper.GetFieldNameById(fld.getFieldDefinition().getName());
							} catch (ResourceRegistryException e) {
								logger.error("Error while retrieving field name", e);
							}
							idsNames.put(fld.getFieldDefinition().getName(), name);
						}
						if (stringField.getPayload() != null && stringField.getPayload().length() > 370)
							htmlRepresentation += "<p><b>" + name +  ":</b> " + stringField.getPayload().substring(0, 369) + "..." + "</p>";
						else
						{
							/* Add the field to the html representation, only if it has a non-empty payload. */
							if (stringField.getPayload() != null && !stringField.getPayload().equals("")) {
								if (name.trim().equalsIgnoreCase("S"))
									name = SearchConstants.SNIPPET;
								logger.info("Description was "+stringField.getPayload());
								String description = stringField.getPayload().replaceAll("&gt;", ">").replaceAll("&lt;", "<");
								htmlRepresentation += "<p><b>" + name +  ":</b> " + description + "</p>";
							}
						}

						if (resRec.getTitle() == null || resRec.getTitle().equals("")) {
							if (stringField != null && stringField.getPayload() != null) {
								if (stringField.getPayload().length() > 40)
									resRec.setTitle(name + ": " + stringField.getPayload().substring(0,40));
								else
									resRec.setTitle(name + ": " + stringField.getPayload());
							}
						}
					}
					//logger.debug("HTML Representation: " + htmlRepresentation);
				}
				//resRec.setTitle(htmlRepresentation.substring(0,20));
				resRec.setHTMLRepresentation(htmlRepresentation);
				resultsList.add(resRec);
			} else {
				// quick search - get all presentation fields
				Field[] allFields = results.get(i).getFields();
				for (int k = 0; k < allFields.length; k++) {
					try {
						logger.debug("Looking for name of the field: " + allFields[k].getFieldDefinition().getName());
						String name = QueryHelper.GetFieldNameById(allFields[k].getFieldDefinition().getName());
						logger.debug("The name is: " + name);
						if (name != null && !name.equals("ObjectID") && !name.equals("rank") && !name.equals("gDocCollectionID")) {
							StringField stringField = (StringField) allFields[k];
							htmlRepresentation += "<p><b>" + name +  ":</b> " + stringField.getPayload() + "</p>";
							if (resRec.getTitle() == null || resRec.getTitle().equals("")) {
								if (stringField.getPayload().length() > 40)
									resRec.setTitle(name + ": " + stringField.getPayload().substring(0,40));
								else
									resRec.setTitle(name + ": " + stringField.getPayload());
							}
						} 
					} catch (ResourceRegistryException e) {
						logger.error("Error while retrieving field name", e);
					}
				}
				//resRec.setTitle(htmlRepresentation.substring(0,20));
				resRec.setHTMLRepresentation(htmlRepresentation);
				resultsList.add(resRec);
			}
		}
		long endTime = System.currentTimeMillis();
		long diff = endTime - startTime;
		logger.debug("Portal Benchmarking - Records Transformation for Presentation (for whole page): " + diff);
		//session.removeAttribute("presentationFields");
		logger.info("---------------------------The number of results returned are: " + resultsList.size());
		return resultsList;
	}


	public List<String> getResultsToText (int n, int offset, ASLSession session) throws gRS2ReaderException, gRS2RecordDefinitionException, gRS2BufferException {
		int currentPlace;
		try {
			currentPlace = (int)reader.currentRecord(); //(int)reader.totalRecords() - reader.availableRecords();
		} catch (GRS2ReaderException e) {
			logger.error("Error while getting current place in ResultSet", e);
			throw new gRS2ReaderException(e);
		}

		logger.debug("Current Place of ResultSet: " + currentPlace + " and offset is: " + offset);
		logger.info("Current Place of ResultSet: " + currentPlace + " and offset is: " + offset);
		if (offset < 0) {
			return new ArrayList<String>();
		}
		if (offset > currentPlace) {

			int diff = offset - currentPlace;
			logger.debug("Seeking to: " + diff);
			logger.info("Seeking to: " + diff);
			try {
				reader.seek(diff);
			} catch (GRS2ReaderException e) {
				logger.error("Error while seeking resultSet.", e);
				logger.info("Error while seeking resultSet.");
				throw new gRS2ReaderException(e);
			}
		} else {
			int diff = currentPlace - offset;
			logger.debug("Seeking to: -" + diff);
			logger.info("Seeking to: -" + diff);
			try {
				reader.seek(-diff);
			} catch (GRS2ReaderException e) {
				logger.error("Error while seeking resultSet.", e);
				logger.info("Error while seeking resultSet.");
				throw new gRS2ReaderException(e);
			}
		}

		List<String> recs = new ArrayList<String>();
		try {
			recs = read(n, session);
		} catch (GRS2RecordDefinitionException e) {
			logger.error("Error while reading resultSet.", e);
			throw new gRS2RecordDefinitionException(e);
		} catch (GRS2ReaderException e) {
			logger.error("Error while reading resultSet.", e);
			throw new gRS2ReaderException(e);
		} catch (GRS2BufferException e) {
			logger.error("Error while reading resultSet.", e);
			throw new gRS2BufferException(e);
		} catch (ResourceRegistryException e) {
			logger.error("Error while reading field names from registry.", e);
			throw new gRS2BufferException(e);
		}
		return recs;
	}


	public void setOnlyPresentables() {
		this.onlyPresentationFields = true;
	}

	private List<String> read(int count, ASLSession session) throws GRS2ReaderException, GRS2RecordDefinitionException, GRS2BufferException, ResourceRegistryException
	{
		if (!onlyPresentationFields) {
			List<String> records = new ArrayList<String>();

			for(int i=0;i<count;i+=1)
			{
				if(reader.getStatus()==Status.Dispose || (reader.getStatus()==Status.Close && reader.availableRecords()==0)) {

					break;
				}
				GenericRecord rec=reader.get(30, TimeUnit.SECONDS);
				if(rec==null) 
					break;

				String recString = "<RSRecord>";
				Field[] fields = rec.getFields();
				for (int j = 0; j < fields.length; j++) {
					StringField stringField = (StringField)fields[j];
					//-- Convert value to UTF-8
					String stringValue = stringField.getPayload();
					String roundTrip = null;
					try {
						if (stringValue != null) {
							byte[] utf8Bytes = stringValue.getBytes("UTF8");
							roundTrip = new String(utf8Bytes, "UTF8");
						}
					} catch (UnsupportedEncodingException e) {
						// TODO Auto-generated catch block
						logger.error("Exception:", e);
					}

					//TODO: correct this...
					String key = fields[j].getFieldDefinition().getName();

					String name = null;//fieldsIDsNames.get(key);
					if (!fieldsIDsNames.containsKey(key)) {
						name = QueryHelper.GetFieldNameById(fields[j].getFieldDefinition().getName());
						fieldsIDsNames.put(fields[j].getFieldDefinition().getName(), name);
					}

					else
						name = fieldsIDsNames.get(key);

					if (roundTrip == null)
						recString += "<field><fieldId>" + fields[j].getFieldDefinition().getName() + "</fieldId><fieldValue>" + stringField.getPayload() + "</fieldValue><fieldName>" + name + "</fieldName></field>";
					else
						recString += "<field><fieldId>" + fields[j].getFieldDefinition().getName() + "</fieldId><fieldValue>" + roundTrip + "</fieldValue><fieldName>" + name + "</fieldName></field>";
				}
				//recString = recString.substring(0, recString.length() - 2);
				recString += "</RSRecord>";
				records.add(recString);
			}
			return records;
		} else {
			List<String> records = new ArrayList<String>();

			HashMap<String, String> idsNames = new HashMap<String, String>();

			for(int i=0;i<count;i+=1)
			{
				if(reader.getStatus()==Status.Dispose || (reader.getStatus()==Status.Close && reader.availableRecords()==0)) {

					break;
				}
				GenericRecord rec=reader.get(30, TimeUnit.SECONDS);
				if(rec==null) 
					break;

				Field DocId = rec.getField("ObjectID");
				StringField docId = (StringField)DocId;
				Field RankID = rec.getField("rank");
				StringField rankId = (StringField)RankID;
				Field CollID = rec.getField("gDocCollectionID");
				StringField colId = null;
				String docIdRecord;
				String colIdRecord = null;


				String recString = "<RSRecord>";
				ArrayList<String> presentationIds = (ArrayList<String>)session.getAttribute("presentationFields");
				if (presentationIds != null && presentationIds.size() != 0) {
					for (int j = 0; j < presentationIds.size(); j++) {
						Field fld = rec.getField(presentationIds.get(j));
						StringField stringField = (StringField) fld;

						if (fld != null) {
							String name = idsNames.get(fld.getFieldDefinition().getName());
							if (name == null || name.equals("")) {
								try {
									name = QueryHelper.GetFieldNameById(fld.getFieldDefinition().getName());
								} catch (ResourceRegistryException e) {
									logger.error("Error while retrieving field name", e);
								}
								idsNames.put(fld.getFieldDefinition().getName(), name);
							}

							recString += "<field><fieldId>" + fld.getFieldDefinition().getName() + "</fieldId><fieldValue>" + stringField.getPayload() + "</fieldValue><fieldName>" + name + "</fieldName></field>";
						}
					}
				}

				docIdRecord = "<field><fieldId>" + DocId.getFieldDefinition().getName() + "</fieldId><fieldValue>" + docId.getPayload() + "</fieldValue><fieldName>" + "ObjectID" + "</fieldName></field>";

				if (CollID  != null) {
					colId = (StringField)CollID;
					colIdRecord = "<field><fieldId>";
					if (CollID.getFieldDefinition() != null && CollID.getFieldDefinition().getName() != null)
						colIdRecord += CollID.getFieldDefinition().getName(); 

					colIdRecord += "</fieldId><fieldValue>";
					if (colId != null && colId.getPayload() != null)
						colIdRecord+= colId.getPayload();
					colIdRecord+= "</fieldValue><fieldName>"+ "gDocCollectionID" + "</fieldName></field>";
				}
				recString += docIdRecord;

				if (colIdRecord != null)
					recString += colIdRecord;

				DigitalObject mDO;
				if (colId == null) {
					logger.debug("the gDocCollection id is: ");
					logger.debug("Creating digital object - the gDocCollection id is NULL: " + docId.getPayload());
					mDO = new DigitalObject(session, docId.getPayload());
				}
				else {
					logger.debug("Creating digital object - the gDocCollection id is NOT null: " + docId.getPayload());
					mDO = new DigitalObject(session, docId.getPayload(), colId.getPayload());
				}

				String mimeRecord = "<field><fieldId>" + "mimeId" + "</fieldId><fieldValue>" + mDO.getMimeType() + "</fieldValue><fieldName>" + "mimeType" + "</fieldName></field>";
				recString+= mimeRecord;


				recString += "</RSRecord>";
				records.add(recString);
			}
			return records;
		}
	}

	public void setWindowSize(int windowSize) throws GRS2ReaderInvalidArgumentException {
		if (this.reader instanceof RecordReaderDelegate) {
			((RecordReaderDelegate<GenericRecord>)this.reader).changeWindowSize(windowSize);
		} else {
			throw new GRS2ReaderInvalidArgumentException("Reader not instance of RecordReaderDelegate");
		}
	}

	private List<GenericRecord> readRS(int count, DisableButtons dis, boolean back) throws GRS2ReaderException, gRS2NoRecordReadWithinTimeIntervalException {
		//		List<GenericRecord> results = new ArrayList<GenericRecord>();
		//		for (int i = 0; i < count; i++) {
		//			if (reader.getStatus() == Status.Dispose || (reader.getStatus() == Status.Close && reader.availableRecords() == 0)) {
		//				dis.setForward(true);
		//				return results;
		//			}
		//			
		//			GenericRecord rec = reader.get(60, TimeUnit.SECONDS);
		//			if (rec == null) {
		//				throw new gRS2NoRecordReadWithinTimeIntervalException();
		//			}
		//			results.add(rec);
		//		}
		if (!back) {
			List<GenericRecord> results = new ArrayList<GenericRecord>();
			int i = 0;
			while (iter.hasNext()) {
				if (i < count) {
					GenericRecord rec = iter.next();
					if (rec == null) {
						dis.setForward(true);
						break;
					} else {
						results.add(rec);
						i++;
					}
				} else 
					break;
			}
			if (!iter.hasNext())
				dis.setForward(true);
			return results;
		} else {
			List<GenericRecord> results = new ArrayList<GenericRecord>();
			int i = 0;
			while (iter.hasPrevious()) {
				if (i < count) {
					GenericRecord rec = iter.previous();
					if (rec == null) {
						dis.setForward(true);
						break;
					} else {
						results.add(rec);
						i++;
					}
				} else 
					break;
			}
			if (!iter.hasNext())
				dis.setForward(true);
			return results;
		}
	}

	public ArrayList<DigitalObject> getAllResultIds(ASLSession session) {
		ArrayList<DigitalObject> rsIds = new ArrayList<DigitalObject>();
		//		if (!iter.hasNext())
		//			logger.debug("NO RESULTS");
		//		while (iter.hasNext()) {
		//			GenericRecord rec = iter.next();
		//			Field DocId;
		//			try {
		//				DocId = rec.getField("ObjectID");
		//				StringField docId = (StringField)DocId;
		//				Field CollID = rec.getField("gDocCollectionID");
		//				StringField colId = null;
		//				if (CollID != null)
		//					colId = (StringField)CollID;
		//				DigitalObject dobj = new DigitalObject(session, docId.getPayload(), colId.getPayload());
		//				// TODO: get guid and put it as the do title!!
		//				Field[] flds = rec.getFields();
		//				for (int i = 0; i < flds.length; i++) {
		//					try {
		//						String name = QueryHelper.GetFieldNameById(flds[i].getFieldDefinition().getName());
		//						if (name != null && name.equals("guid")) {
		//							dobj.setTitle(name);
		//							logger.debug("The guid is: " + name);
		//						} else if (name == null)
		//							logger.debug("The guid is null");
		//							
		//					} catch (ResourceRegistryException e) {
		//						// TODO Auto-generated catch block
		//						logger.error("Exception:", e);
		//					}
		//				}
		//				rsIds.add(dobj);
		//			} catch (GRS2RecordDefinitionException e) {
		//				// TODO Auto-generated catch block
		//				logger.error("Exception:", e);
		//			} catch (GRS2BufferException e) {
		//				// TODO Auto-generated catch block
		//				logger.error("Exception:", e);
		//			}
		//		}
		//		logger.debug("Returning number of all ids: " + rsIds.size());
		try {
			while (true) {
				if (reader.getStatus()==Status.Dispose || (reader.getStatus()==Status.Close && reader.availableRecords()==0))
					break;
				GenericRecord rec = reader.get(120, TimeUnit.SECONDS);
				Field DocId;
				try {
					DocId = rec.getField("ObjectID");
					StringField docId = (StringField)DocId;
					Field CollID = rec.getField("gDocCollectionID");
					StringField colId = null;
					if (CollID != null)
						colId = (StringField)CollID;
					DigitalObject dobj = new DigitalObject(session, docId.getPayload(), colId.getPayload());
					// TODO: get guid and put it as the do title!!
					Field[] flds = rec.getFields();
					for (int i = 0; i < flds.length; i++) {
						try {
							String name = QueryHelper.GetFieldNameById(flds[i].getFieldDefinition().getName());
							if (name != null && name.equals("guid")) {
								StringField strFld = (StringField) flds[i];
								//dobj.setTitle(strFld.getPayload());
								logger.debug("The guid is: " + name);
							} else if (name == null)
								logger.debug("The guid is null");

						} catch (ResourceRegistryException e) {
							// TODO Auto-generated catch block
							logger.error("Exception:", e);
						}
					}
					rsIds.add(dobj);
				}
				catch (GRS2RecordDefinitionException e) {
					logger.error("Exception:", e);
				}
				catch (GRS2BufferException e) {
					logger.error("Exception:", e);
				}
			}
			logger.debug("Returning number of all ids: " + rsIds.size());
		}
		catch (GRS2ReaderException e) {
			// TODO Auto-generated catch block
			logger.error("Exception:", e);
		}
		return rsIds;
	}

	public void setGenericSearchType (String gst) {
		genericSearchType = gst;
	}

	public int getNumOfResultsRead () {
		return numOfResultsRead;
	}

	public boolean getTotalRead() {
		return readTotal;
	}



}
