/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.harvesting.common.db.is;

import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.List;
import org.gcube.application.framework.core.genericresources.model.ISGenericResource;
import org.gcube.application.framework.core.util.GenericResource;
import org.gcube.application.framework.harvesting.common.db.tools.DBConstants;
import org.gcube.application.framework.harvesting.common.db.tools.SourcePropsTools;
import org.gcube.application.framework.harvesting.common.dbXMLObjects.DBProps;
import org.gcube.application.framework.harvesting.common.dbXMLObjects.DBSource;
import org.gcube.common.database.DatabaseProvider;
import org.gcube.common.database.endpoint.DatabaseEndpoint;
import org.gcube.common.database.engine.DatabaseInstance;
import org.gcube.common.database.is.ISDatabaseProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ISResources {
    private static final Logger logger = LoggerFactory.getLogger(ISResources.class);
    private static DatabaseProvider isDBProvider = new ISDatabaseProvider();

    public static DBSource getDBSourceInfo(String dbName, String scope) throws MalformedURLException {
        ScopeProvider.instance.set(scope);
        System.out.println("Searching for dbName: " + dbName + " on scope: " + scope);
        DatabaseInstance db = isDBProvider.get(dbName);
        DatabaseEndpoint[] endpoints = db.getEndpoints().values().toArray(new DatabaseEndpoint[0]);
        System.out.println("Endpoints.length: " + endpoints.length);
        DBSource output = new DBSource();
        for (DatabaseEndpoint ep : endpoints) {
            if (!ep.getId().contains("jdbc")) continue;
            output.setSourceName(dbName);
            output.setDBType(DBConstants.getFixedFullNameOf(db.getPlatform().getName()));
            output.setConnectionString(ep.getConnectionString());
            output.setHostName(db.getHostingURL());
            output.setUserName(ep.getCredentials().getUsername());
            output.setPassword(ep.getCredentials().getPassword());
            output.setVersionMajor(db.getPlatform().getVersion());
            output.setVersionMinor(db.getMinorVersion().shortValue());
        }
        return output;
    }

    public static String getDBPropsByName(String scope, String dbName, String propsName) throws Exception {
        List allRes;
        try {
            allRes = GenericResource.getGenericResourcesByType((String)scope, (String)"HarvesterProps");
        }
        catch (RemoteException e) {
            return null;
        }
        String result = new String();
        for (ISGenericResource res : allRes) {
            DBProps props = SourcePropsTools.parseSourceProps(res.getBody());
            if (!res.getName().equals(propsName) || !props.getSourceName().equals(dbName)) continue;
            System.out.println("propsName: " + res.getName() + "\tdbName: " + props.getSourceName());
            result = res.getBody();
        }
        return result;
    }
}

