/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.contentmanagement.cache.factories;

import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import org.gcube.application.framework.contentmanagement.model.CollectionInfo;
import org.gcube.application.framework.core.util.QueryString;
import org.gcube.common.resources.gcore.ServiceInstance;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionInfoCacheEntryFactory
implements CacheEntryFactory {
    static DiscoveryClient<ServiceInstance> client = null;
    private static final String IS_NAMESPACE_DECL = "declare namespace is = 'http://gcube-system.org/namespaces/informationsystem/registry';\n";
    public static final String VIEWMANAGER = "ViewManager";
    public static final String XP_ISUSER = "//child::*[local-name()='property' and child::*[local-name()='name']/text()='isUserCollection']/child::*[local-name()='value']/text()";
    public static final String FACTORYID = "factory";
    public static final String XP_SCHEMANAME = "//child::*[local-name()='property' and child::*[local-name()='name']/text()='schemaName']/child::*[local-name()='value']/text()";
    public static final String XP_LANGUAGE = "//child::*[local-name()='property' and child::*[local-name()='name']/text()='language']/child::*[local-name()='value']/text()";
    public static final String XP_COLNAME = "//child::*[local-name()='property' and child::*[local-name()='name']/text()='name']/child::*[local-name()='value']/text()";
    public static final String XP_COLID = "//child::*[local-name()='id']/text()";
    public static final String XP_RELATEDCOLID = "//child::*[local-name()='collectionID']/text()";
    public static final String XP_SCHEMAURI = "//child::*[local-name()='property' and child::*[local-name()='name']/text()='schemaURI']/child::*[local-name()='value']/text()";
    private static final Logger logger = LoggerFactory.getLogger(CollectionInfoCacheEntryFactory.class);

    public CollectionInfoCacheEntryFactory() {
        if (client == null) {
            try {
                client = ICFactory.clientFor(ServiceInstance.class);
            }
            catch (Exception e) {
                logger.error("Failed to get implemetation of ISClient", (Throwable)e);
            }
        }
    }

    public Object createEntry(Object key) throws Exception {
        QueryString query = (QueryString)key;
        String colId = (String)query.get((Object)"colId");
        String scope = (String)query.get((Object)"scope");
        return this.harvestCollectionProfile(colId, scope);
    }

    public CollectionInfo harvestCollectionProfile(String colId, String scope) {
        ScopeProvider.instance.set(scope);
        XQuery query = null;
        Object queryResults = null;
        try {
            query = ICFactory.queryFor(ServiceInstance.class);
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
        }
        query.addCondition("$resource/Data/gcube:ServiceName/text() eq 'ViewManager'");
        CollectionInfo colInfo = new CollectionInfo();
        colInfo.setId(colId);
        return colInfo;
    }
}

