/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.contentmanagement.content.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyFileInputStream
extends FileInputStream {
    private static final Logger logger = LoggerFactory.getLogger(MyFileInputStream.class);
    long length;
    long read;

    public MyFileInputStream(File file, long length) throws FileNotFoundException {
        super(file);
        this.length = length;
        this.read = 0L;
    }

    @Override
    public int read() throws IOException {
        while (true) {
            if (this.read < this.length && this.available() > 0) {
                ++this.read;
                return super.read();
            }
            if (this.read == this.length) {
                return super.read();
            }
            try {
                Thread.sleep(2000L);
                continue;
            }
            catch (InterruptedException e) {
                logger.error("Exception:", (Throwable)e);
                continue;
            }
            break;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        while (true) {
            if (this.read < this.length && this.available() > 0) {
                int avail = this.available();
                int size = avail > len ? len : avail;
                int ret = super.read(b, off, size);
                this.read += (long)ret;
                return ret;
            }
            if (this.read == this.length) {
                return super.read(b, off, len);
            }
            try {
                Thread.sleep(2000L);
                continue;
            }
            catch (InterruptedException e) {
                logger.error("Exception:", (Throwable)e);
                continue;
            }
            break;
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }
}

