/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.contentmanagement.util;

import java.rmi.Remote;
import java.util.Random;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.application.framework.contentmanagement.content.impl.DigitalObject;
import org.gcube.application.framework.core.cache.RIsManager;
import org.gcube.application.framework.core.cache.factories.ApplicationCredentials;
import org.gcube.application.framework.core.security.ServiceContextManager;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.datatransformation.datatransformationservice.stubs.DataTransformationServicePortType;
import org.gcube.datatransformation.datatransformationservice.stubs.service.DataTransformationServiceAddressingLocator;
import org.gcube.informationsystem.cache.SrvType;
import org.ietf.jgss.GSSCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThumbnailUtils {
    private static final Logger logger = LoggerFactory.getLogger(ThumbnailUtils.class);
    public static final int chunkSize = 0x100000;

    public static String getContent(String oid, String scope) throws Exception {
        return DigitalObject.getContent(oid, scope);
    }

    public static String getMimeType(String oid, String scope) throws Exception {
        return "XML_URL";
    }

    public static DataTransformationServicePortType getDTSPortType(String scope) throws Exception {
        Object result = null;
        EndpointReference[] dtsURIs = null;
        try {
            dtsURIs = RIsManager.getInstance().getISCache(GCUBEScope.getScope((String)scope)).getEPRsFor("DataTransformation", "DataTransformationService", SrvType.SIMPLE.name());
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
        }
        Random random = new Random();
        String dtsAddress = dtsURIs[random.nextInt(dtsURIs.length)].getAddress().toString();
        EndpointReferenceType endpoint = new EndpointReferenceType();
        endpoint.setAddress((AttributedURI)new Address(dtsAddress));
        DataTransformationServiceAddressingLocator dtsLocator = new DataTransformationServiceAddressingLocator();
        DataTransformationServicePortType dts = dtsLocator.getDataTransformationServicePortTypePort(endpoint);
        try {
            dts = (DataTransformationServicePortType)ServiceContextManager.applySecurity((Remote)dts, (GCUBEScope)GCUBEScope.getScope((String)scope), (GSSCredential)ApplicationCredentials.getInstance().getCredential(scope));
        }
        catch (GCUBEScope.MalformedScopeExpressionException e) {
            logger.error("Exception:", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
        }
        return dts;
    }
}

