/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.contentmanagement.util;

public class XMLTokenReplacer {
    private static String replaceXMLTokens(String token, char replacer, String str) {
        StringBuffer sb = new StringBuffer(str);
        int index = sb.indexOf(token);
        if (index == -1) {
            return str;
        }
        while (index != -1) {
            sb.replace(index, index + token.length(), new Character(replacer).toString());
            index = sb.indexOf(token);
        }
        return sb.toString();
    }

    public static String XMLResolve(String str) {
        String LT = "&lt;";
        String GT = "&gt;";
        String APOS = "&apos;";
        String AMP = "&amp;";
        String QUOT = "&quot;";
        String NULL = "&#x0;";
        String SLASH_R = "&#x0D;";
        char LTReplace = '<';
        char GTReplace = '>';
        char APOSReplace = '\'';
        char AMPReplace = '&';
        char QUOTReplace = '\"';
        char NULLReplace = '\u0000';
        char SLASH_RReplace = '\r';
        str = XMLTokenReplacer.replaceXMLTokens(LT, LTReplace, str);
        str = XMLTokenReplacer.replaceXMLTokens(GT, GTReplace, str);
        str = XMLTokenReplacer.replaceXMLTokens(APOS, APOSReplace, str);
        str = XMLTokenReplacer.replaceXMLTokens(QUOT, QUOTReplace, str);
        str = XMLTokenReplacer.replaceXMLTokens(NULL, NULLReplace, str);
        str = XMLTokenReplacer.replaceXMLTokens(SLASH_R, SLASH_RReplace, str);
        str = XMLTokenReplacer.replaceXMLTokens(AMP, AMPReplace, str);
        return str;
    }

    public static String XMLUnresolve(String str) {
        String AMP = "&amp;";
        String LT = "&lt;";
        String GT = "&gt;";
        String APOS = "&apos;";
        String QUOT = "&quot;";
        String NULL = "&#x0;";
        String SLASH_R = "&#x0D;";
        char AMPReplace = '&';
        char LTReplace = '<';
        char GTReplace = '>';
        char APOSReplace = '\'';
        char QUOTReplace = '\"';
        char NULLReplace = '\u0000';
        char SLASH_RReplace = '\r';
        str = XMLTokenReplacer.replace2XMLTokens(AMP, AMPReplace, str);
        str = XMLTokenReplacer.replace2XMLTokens(LT, LTReplace, str);
        str = XMLTokenReplacer.replace2XMLTokens(GT, GTReplace, str);
        str = XMLTokenReplacer.replace2XMLTokens(APOS, APOSReplace, str);
        str = XMLTokenReplacer.replace2XMLTokens(QUOT, QUOTReplace, str);
        str = XMLTokenReplacer.replace2XMLTokens(NULL, NULLReplace, str);
        str = XMLTokenReplacer.replace2XMLTokens(SLASH_R, SLASH_RReplace, str);
        return str;
    }

    private static String replace2XMLTokens(String replacer, char original, String str) {
        StringBuffer sb = new StringBuffer(str);
        int index = sb.indexOf(new Character(original).toString());
        if (index == -1) {
            return str;
        }
        while (index != -1) {
            sb.replace(index, index + 1, replacer);
            index = sb.indexOf(new Character(original).toString(), index + 1);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        System.out.println(args[0]);
        System.out.println(XMLTokenReplacer.XMLUnresolve(args[0]));
        System.out.println(XMLTokenReplacer.XMLResolve(XMLTokenReplacer.XMLUnresolve(args[0])));
    }
}

