/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.contentmanagement.datatransformation.util;

import java.net.URI;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.xml.rpc.ServiceException;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.types.URI;
import org.gcube.application.framework.contentmanagement.datatransformation.util.DataTransformationUtils;
import org.gcube.application.framework.contentmanagement.exceptions.ContentReaderCreationException;
import org.gcube.application.framework.contentmanagement.exceptions.OCRException;
import org.gcube.application.framework.contentmanagement.exceptions.ReadingRSException;
import org.gcube.application.framework.contentmanagement.exceptions.ServiceEPRRetrievalException;
import org.gcube.application.framework.contentmanagement.exceptions.TransformationException;
import org.gcube.application.framework.contentmanagement.util.DocumentInfos;
import org.gcube.application.framework.core.cache.RIsManager;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.faults.GCUBEUnrecoverableFault;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.types.VOID;
import org.gcube.contentmanagement.contentmanager.stubs.model.protocol.URIs;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentReader;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentWriter;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projections;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeDocument;
import org.gcube.execution.ocrservice.stubs.InputResource;
import org.gcube.execution.ocrservice.stubs.OCRServiceFactoryPortType;
import org.gcube.execution.ocrservice.stubs.OCRServicePortType;
import org.gcube.execution.ocrservice.stubs.StatusResponseType;
import org.gcube.execution.ocrservice.stubs.Submit;
import org.gcube.execution.ocrservice.stubs.service.OCRServiceAddressingLocator;
import org.gcube.execution.ocrservice.stubs.service.OCRServiceFactoryServiceAddressingLocator;
import org.gcube.informationsystem.cache.SrvType;

public class TestDTSClient {
    public static void main(String[] args) {
        try {
            ArrayList<String> colid = new ArrayList<String>();
            colid.add("");
            String resultsEpr = DataTransformationUtils.transformPDFDocumentsToText("dl10.di.uoa.gr:8181/documentLocations.txt", colid, "testpdfcol", "gcube/devNext");
            ArrayList<String> wrong = new ArrayList<String>();
            ArrayList<DocumentInfos> failures = DataTransformationUtils.getReports(resultsEpr, wrong);
            TestDTSClient.performOCRtoPDF_HTTPInput(failures, colid.get(0), "/gcube/devNext");
        }
        catch (ServiceEPRRetrievalException e) {
            e.printStackTrace();
        }
        catch (TransformationException e) {
            e.printStackTrace();
        }
        catch (ReadingRSException e) {
            e.printStackTrace();
        }
        catch (OCRException e) {
            e.printStackTrace();
        }
    }

    public static ArrayList<String> performOCRtoPDF_HTTPInput(ArrayList<DocumentInfos> documents, String outputCollectionId, String scope) throws ServiceEPRRetrievalException, OCRException {
        ArrayList<String> HocrOutputSSIDs = new ArrayList<String>();
        String ocrEPR = TestDTSClient.getOCRServiceEPR("/gcube/devNext");
        EndpointReferenceType factoryEPR = new EndpointReferenceType();
        try {
            factoryEPR.setAddress((AttributedURI)new Address(ocrEPR));
        }
        catch (URI.MalformedURIException e) {
            e.printStackTrace();
            throw new ServiceEPRRetrievalException(e);
        }
        OCRServiceFactoryPortType stub = null;
        try {
            stub = new OCRServiceFactoryServiceAddressingLocator().getOCRServiceFactoryPortTypePort(factoryEPR);
            stub = (OCRServiceFactoryPortType)GCUBERemotePortTypeContext.getProxy((Remote)stub, (GCUBEScope)GCUBEScope.getScope((String)scope), (GCUBESecurityManager[])new GCUBESecurityManager[0]);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            throw new ServiceEPRRetrievalException(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceEPRRetrievalException(e);
        }
        int numDocs = 0;
        for (int i = 0; i < documents.size(); ++i) {
            OCRServicePortType stub2;
            InputResource input = new InputResource();
            System.out.println("Printing...");
            if (documents.get(i) == null) {
                System.out.println("IT IS NULL " + documents.size());
            }
            System.out.println("The document id is: " + documents.get(i).getDocumentId() + " " + documents.get(i).getPdfURI());
            input.setResourceKey(documents.get(i).getDocumentId().trim());
            input.setResourceAccess("Reference");
            input.setResourceReference(documents.get(i).getPdfURI().trim());
            Submit sub = new Submit();
            sub.setInputResource(input);
            EndpointReferenceType resourceEPR = null;
            try {
                resourceEPR = stub.submit(sub).getEndpointReference();
            }
            catch (GCUBEUnrecoverableFault e) {
                e.printStackTrace();
                throw new ServiceEPRRetrievalException(e);
            }
            catch (RemoteException e) {
                e.printStackTrace();
                throw new ServiceEPRRetrievalException(e);
            }
            try {
                stub2 = new OCRServiceAddressingLocator().getOCRServicePortTypePort(resourceEPR);
                stub2 = (OCRServicePortType)GCUBERemotePortTypeContext.getProxy((Remote)stub2, (GCUBEScope)GCUBEScope.getScope((String)scope), (GCUBESecurityManager[])new GCUBESecurityManager[0]);
            }
            catch (ServiceException e) {
                e.printStackTrace();
                throw new ServiceEPRRetrievalException(e);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ServiceEPRRetrievalException(e);
            }
            StatusResponseType status = null;
            do {
                try {
                    status = stub2.status(new VOID());
                    Thread.sleep(10000L);
                }
                catch (GCUBEUnrecoverableFault e) {
                    e.printStackTrace();
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } while (!status.isCompleted());
            System.out.println("Number of documents transformed: " + ++numDocs);
            HocrOutputSSIDs.add(status.getHocrOutputSSID());
            String error = status.getJoberrSSID();
            System.out.println("The JOBERRSSID is: " + error);
        }
        DocumentWriter cmWriter = null;
        DocumentReader cmReader = null;
        GCubeDocument doc = null;
        try {
            boolean first = true;
            cmWriter = new DocumentWriter(outputCollectionId, GCUBEScope.getScope((String)scope));
            System.out.println(HocrOutputSSIDs.size());
            for (int i = 0; i < HocrOutputSSIDs.size(); ++i) {
                if (HocrOutputSSIDs.get(i) == null) {
                    System.out.println("CRY");
                } else {
                    System.out.println("CRY NOT");
                }
                URI theUri = new URI(HocrOutputSSIDs.get(i).trim());
                String oid = URIs.documentID((URI)theUri);
                String colID = URIs.collectionID((URI)theUri);
                if (!first) continue;
                try {
                    cmReader = new DocumentReader(colID, GCUBEScope.getScope((String)scope));
                    cmWriter = new DocumentWriter(outputCollectionId, GCUBEScope.getScope((String)scope));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ContentReaderCreationException(e);
                }
                doc = cmReader.get(oid, (Projection)Projections.document());
                String myNewDocumentId = cmWriter.add(doc);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OCRException(e);
        }
        return HocrOutputSSIDs;
    }

    private static String getOCRServiceEPR(String scope) {
        EndpointReference[] ocrService = null;
        System.out.println("Looking for an OCRService epr");
        try {
            ocrService = RIsManager.getInstance().getISCache(GCUBEScope.getScope((String)scope)).getEPRsFor("Execution", "OCRService", SrvType.FACTORY.name());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("The ocrService epr is NULL");
        return "http://dl20.di.uoa.gr:8485/wsrf/services/gcube/execution/ocrservice/OCRServiceFactory";
    }
}

