package org.gcube.application.framework.harvesting.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLStreamException;

import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.application.framework.harvesting.common.db.exceptions.DBConnectionException;
import org.gcube.application.framework.harvesting.common.db.is.ISResources;
import org.gcube.application.framework.harvesting.common.db.tools.SourcePropsTools;
import org.gcube.application.framework.harvesting.common.dbXMLObjects.DBSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;



//@WebServlet("/HarvestDB")
public class HarvestDB extends HttpServlet {
	private static final long serialVersionUID = 1L;
	
	/** The logger. */
	private static final Logger logger = LoggerFactory.getLogger(HarvestDB.class);
	
    public HarvestDB() {
        super();
        // TODO Auto-generated constructor stub
    }


	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException{
		try {
			stax_version(request, response);
		} catch (IOException e) {
			response.sendError(500);
		} catch (DBConnectionException e){
			response.sendError(500);
		} catch (XMLStreamException e){
			response.sendError(500);
		} catch (Exception e) {
			e.printStackTrace();
		}
		
	}

	
//	private void dom_version(HttpServletRequest request, HttpServletResponse response) throws IOException{
//		String user = request.getParameter("user");
//		DBDataDom dbData = new DBDataDom(user,null);
//		try {
//			response.setContentType("text/xml;charset=UTF-8");
//			PrintWriter output = response.getWriter();
//			output.print(dbData.getUserData());
//			output.close();
//		} catch (SQLException e) {
//			e.printStackTrace();
//		}
//	}
	
	/**
	 * Edit root table sql of dbDataStax to return only the recordid specified
	 */
	private DBDataStax filterRootSqlBy(DBDataStax dbDataStax, String recordid){
		for(int i=0;i<dbDataStax.getSourceProps().getTables().size();i++){
			if(dbDataStax.getSourceProps().getTables().get(i).getName().equalsIgnoreCase(dbDataStax.getRootTableName())){
				String tableName = dbDataStax.getSourceProps().getTables().get(i).getName();
				String sql = dbDataStax.getSourceProps().getTables().get(i).getSql();
				String [] keys = SourcePropsTools.getPKeyOfTable(dbDataStax.getSourceProps(), tableName).split(",");
				String [] keysVals = recordid.split(",");
				if(sql.toLowerCase().contains(" where ")){
					for(int k=0;k<keys.length;k++)
						sql += " and "+keys[k]+"='"+keysVals[k]+"'";
					dbDataStax.getSourceProps().getTables().get(i).setSql(sql);
				}
				else{
					sql += " where "+keys[0]+"='"+keysVals[0]+"'";
					for(int k=1;k<keys.length;k++)
						sql += " and "+keys[k]+"='"+keysVals[k]+"'";
					dbDataStax.getSourceProps().getTables().get(i).setSql(sql);
				}
			}
		}
		return dbDataStax;
	}
	
	
	private void stax_version(HttpServletRequest request, HttpServletResponse response) throws Exception{
		String scope = request.getParameter("scope");
	 	String sourcename = request.getParameter("sourcename");
		String sourceprops = request.getParameter("sourceprops");
		//get the properties file from the IS for the specified {sourcename, sourceprops} 
		DBSource dbSource = ISResources.getDBSourceInfo(sourcename, scope);
		String propsXML = ISResources.getDBPropsByName(scope, sourcename, sourceprops);
		
		DBDataStax dbDataStax = new DBDataStax(dbSource, propsXML, scope);
		String recordid = request.getParameter("recordid");
		if((recordid!=null)&&(!recordid.isEmpty())) //means that the caller has ordered a specific record
			dbDataStax = filterRootSqlBy(dbDataStax,recordid);
		//by now, if user has ordered a specific field, we have modified accordingly the sql of the root table
		dbDataStax.writeSourceData(response,request.getHeader("host"));
		//close writer
		response.getWriter().close();		
		
	}
	
	
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		
	}

}
