/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.harvesting.db;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLStreamException;
import org.gcube.application.framework.harvesting.common.db.exceptions.DBConnectionException;
import org.gcube.application.framework.harvesting.common.db.tools.SourcePropsTools;
import org.gcube.application.framework.harvesting.common.dbXMLObjects.DBSource;
import org.gcube.application.framework.harvesting.common.dbXMLObjects.Table;
import org.gcube.application.framework.harvesting.db.DBDataStax;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HarvestDB
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(HarvestDB.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            this.stax_version(request, response);
        }
        catch (IOException e) {
            response.sendError(500);
        }
        catch (DBConnectionException e) {
            response.sendError(500);
        }
        catch (XMLStreamException e) {
            response.sendError(500);
        }
    }

    private DBDataStax filterRootSqlBy(DBDataStax dbDataStax, String recordid) {
        for (int i = 0; i < dbDataStax.getSourceProps().getTables().size(); ++i) {
            int k;
            if (!((Table)dbDataStax.getSourceProps().getTables().get(i)).getName().equalsIgnoreCase(dbDataStax.getRootTableName())) continue;
            String tableName = ((Table)dbDataStax.getSourceProps().getTables().get(i)).getName();
            String sql = ((Table)dbDataStax.getSourceProps().getTables().get(i)).getSql();
            String[] keys = SourcePropsTools.getPKeyOfTable((DBSource)dbDataStax.getSourceProps(), (String)tableName).split(",");
            String[] keysVals = recordid.split(",");
            if (sql.toLowerCase().contains(" where ")) {
                for (k = 0; k < keys.length; ++k) {
                    sql = sql + " and " + keys[k] + "='" + keysVals[k] + "'";
                }
                ((Table)dbDataStax.getSourceProps().getTables().get(i)).setSql(sql);
                continue;
            }
            sql = sql + " where " + keys[0] + "='" + keysVals[0] + "'";
            for (k = 1; k < keys.length; ++k) {
                sql = sql + " and " + keys[k] + "='" + keysVals[k] + "'";
            }
            ((Table)dbDataStax.getSourceProps().getTables().get(i)).setSql(sql);
        }
        return dbDataStax;
    }

    private void stax_version(HttpServletRequest request, HttpServletResponse response) throws IOException, XMLStreamException, DBConnectionException {
        String sourceid = request.getParameter("sourceid");
        DBDataStax dbDataStax = new DBDataStax(sourceid, null);
        String recordid = request.getParameter("recordid");
        if (recordid != null && !recordid.isEmpty()) {
            dbDataStax = this.filterRootSqlBy(dbDataStax, recordid);
        }
        dbDataStax.writeSourceData(response, request.getHeader("host"));
        response.getWriter().close();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }
}

