/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.harvesting.db;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.TransformerException;
import org.gcube.application.framework.harvesting.common.ElementGenerator;
import org.gcube.application.framework.harvesting.common.db.exceptions.DBConnectionException;
import org.gcube.application.framework.harvesting.common.db.exceptions.SourceIDNotFoundException;
import org.gcube.application.framework.harvesting.common.db.tools.SourcePropsTools;
import org.gcube.application.framework.harvesting.common.dbXMLObjects.DBSource;
import org.gcube.application.framework.harvesting.common.dbXMLObjects.Edge;
import org.gcube.application.framework.harvesting.common.dbXMLObjects.Table;
import org.gcube.application.framework.harvesting.db.toolbox.GenericTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DBDataStax {
    private static final Logger logger = LoggerFactory.getLogger(DBDataStax.class);
    private Connection conn;
    private DBSource dbSource;
    private String rootTableName;
    private static HashMap<String, String> dbNameToDriverClass = new HashMap();

    public DBDataStax(String sourceID, String filepath) {
        if (filepath == null) {
            filepath = System.getProperty("catalina.base") + "/shared/d4s/asl/sqlDBMappings.xml";
        }
        try {
            this.dbSource = SourcePropsTools.parseSourceProps((String)filepath, (String)sourceID);
        }
        catch (SourceIDNotFoundException e) {
            e.printStackTrace();
        }
        this.intitateRootTable();
    }

    public DBSource getSourceProps() {
        return this.dbSource;
    }

    public String getRootTableName() {
        return this.rootTableName;
    }

    public void intitateRootTable() {
        for (Table table : this.dbSource.getTables()) {
            boolean root = true;
            for (Edge edge : this.dbSource.getEdges()) {
                if (!table.getName().equalsIgnoreCase(edge.getChild())) continue;
                root = false;
            }
            if (!root) continue;
            this.rootTableName = table.getName();
            break;
        }
        logger.debug("root table is : " + this.rootTableName);
    }

    public void writeSourceData(HttpServletResponse response, String hostname) throws XMLStreamException, IOException, DBConnectionException {
        response.setContentType("text/xml;charset=UTF-8");
        this.conn = this.connectToDatabaseOrDieTrying();
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        XMLStreamWriter writer = factory.createXMLStreamWriter(response.getWriter());
        writer.writeStartDocument();
        writer.writeStartElement("collection");
        writer.writeStartElement("name");
        writer.writeCharacters(this.dbSource.getDBName() + " " + "Database");
        writer.writeEndElement();
        writer.writeStartElement("provenance");
        writer.writeCharacters(this.dbSource.getDBType() + " Database");
        writer.writeEndElement();
        writer.writeStartElement("timestamp");
        writer.writeCharacters(GenericTools.getCurrentTimestamp());
        writer.writeEndElement();
        writer.writeStartElement("records");
        try {
            this.formSubElement(writer, this.rootTableName, new HashMap(), hostname);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndDocument();
        writer.flush();
        writer.close();
        try {
            this.conn.close();
        }
        catch (SQLException e) {
            throw new DBConnectionException("Error closing the connection with the database", (Throwable)e);
        }
    }

    public Element formSubElement(XMLStreamWriter writer, String tableName, HashMap<String, String> keysVals, String hostname) throws SQLException, XMLStreamException, TransformerException {
        Document doc = ElementGenerator.getDocument();
        ResultSet rs = this.getFilteredTableResultSet(tableName, this.conn, keysVals);
        ResultSetMetaData fields = rs.getMetaData();
        Element elementList = doc.createElement(tableName + "_list");
        ArrayList edges = SourcePropsTools.getEdges((DBSource)this.dbSource, (String)tableName);
        if (keysVals.size() == 0) {
            while (rs.next()) {
                writer.writeStartElement("record");
                writer.writeStartElement("id");
                String[] rootKeys = new String[1];
                for (Edge edge : this.dbSource.getEdges()) {
                    if (!edge.getParent().equals(tableName)) continue;
                    rootKeys = edge.getPKeys().split(",");
                }
                writer.writeCharacters("http://" + hostname + "/aslHarvestersHttpDB/HarvestDB");
                writer.writeCharacters("?sourceid=" + this.dbSource.getSourceID());
                String idStr = "";
                for (String key : rootKeys) {
                    idStr = idStr + rs.getString(key) + ",";
                }
                idStr = idStr.substring(0, idStr.length() - 1);
                writer.writeCharacters("&recordid=" + idStr);
                writer.writeEndElement();
                writer.writeStartElement("fields");
                writer.writeStartElement("field");
                writer.writeStartElement("name");
                writer.writeCharacters(tableName);
                writer.writeEndElement();
                writer.writeStartElement("mimetype");
                writer.writeCharacters("text/xml");
                writer.writeEndElement();
                writer.writeStartElement("payload");
                Element subTable = doc.createElement(tableName);
                for (int i = 1; i <= fields.getColumnCount(); ++i) {
                    Element el = doc.createElement(fields.getColumnLabel(i));
                    String val = rs.getString(i);
                    if (val == null) {
                        val = "";
                    }
                    el.appendChild(doc.createTextNode(val));
                    subTable.appendChild(el);
                }
                for (Edge edge : edges) {
                    HashMap<String, String> kv = new HashMap<String, String>();
                    String[] pkeys = edge.getPKeys().split(",");
                    String[] ckeys = edge.getCKeys().split(",");
                    for (int i = 0; i < ckeys.length; ++i) {
                        kv.put(ckeys[i], rs.getString(pkeys[i]));
                    }
                    Element e = this.formSubElement(writer, edge.getChild(), kv, hostname);
                    if (!e.hasChildNodes()) continue;
                    subTable.appendChild(e);
                }
                writer.writeCData(ElementGenerator.domToXML((Element)subTable));
                writer.writeEndElement();
                writer.writeEndElement();
                writer.writeEndElement();
                writer.writeEndElement();
                writer.flush();
            }
        } else {
            while (rs.next()) {
                Element subTable = doc.createElement(tableName);
                for (int i = 1; i <= fields.getColumnCount(); ++i) {
                    Element el = doc.createElement(fields.getColumnLabel(i));
                    String val = rs.getString(i);
                    if (val == null) {
                        val = "";
                    }
                    el.appendChild(doc.createTextNode(val));
                    subTable.appendChild(el);
                }
                for (Edge edge : edges) {
                    HashMap<String, String> kv = new HashMap<String, String>();
                    String[] pkeys = edge.getPKeys().split(",");
                    String[] ckeys = edge.getCKeys().split(",");
                    for (int i = 0; i < ckeys.length; ++i) {
                        kv.put(ckeys[i], rs.getString(pkeys[i]));
                    }
                    Element e = this.formSubElement(writer, edge.getChild(), kv, hostname);
                    if (!e.hasChildNodes()) continue;
                    subTable.appendChild(e);
                }
                elementList.appendChild(subTable);
            }
        }
        return elementList;
    }

    private ResultSet getDefaultTableResultSet(String table, Connection conn) throws SQLException {
        Statement st = conn.createStatement();
        return st.executeQuery(SourcePropsTools.getSqlOfTable((DBSource)this.dbSource, (String)table));
    }

    private ResultSet getFilteredTableResultSet(String table, Connection conn, HashMap<String, String> keysValues) throws SQLException {
        Statement st = conn.createStatement();
        String sql = SourcePropsTools.getSqlOfTable((DBSource)this.dbSource, (String)table);
        if (keysValues.isEmpty()) {
            return st.executeQuery(sql);
        }
        if (sql.toLowerCase().contains(" where ")) {
            for (String key : keysValues.keySet()) {
                sql = sql + " and " + key + "='" + keysValues.get(key) + "'";
            }
        } else {
            sql = sql + " where ";
            for (String key : keysValues.keySet()) {
                sql = sql + key + "='" + keysValues.get(key) + "' and ";
            }
        }
        if (sql.endsWith(" and ")) {
            sql = sql.substring(0, sql.length() - 5);
        }
        return st.executeQuery(sql);
    }

    private Connection connectToDatabaseOrDieTrying() throws DBConnectionException {
        Connection conn = null;
        try {
            Class.forName((String)dbNameToDriverClass.get(this.dbSource.getDBType()));
            String url = "jdbc:" + this.dbSource.getDBType() + "://" + this.dbSource.getHost() + "/" + this.dbSource.getDBName();
            Properties props = new Properties();
            props.setProperty("user", this.dbSource.getDBUsername());
            props.setProperty("password", this.dbSource.getDBPassword());
            props.setProperty("tcpKeepAlive", "true");
            conn = DriverManager.getConnection(url, props);
        }
        catch (ClassNotFoundException e) {
            throw new DBConnectionException("Could not find the jdbc connection class", (Throwable)e);
        }
        catch (SQLException e) {
            throw new DBConnectionException("Error connecting to the database through the jdbc class ", (Throwable)e);
        }
        return conn;
    }

    static {
        dbNameToDriverClass.put("mysql", "com.mysql.jdbc.Driver");
        dbNameToDriverClass.put("postgresql", "org.postgresql.Driver");
        dbNameToDriverClass.put("sqlite", "org.sqlite.JDBC");
    }
}

