/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.http.search;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.gcube.application.framework.http.anonymousaccess.management.AuthenticationResponse;
import org.gcube.application.framework.http.anonymousaccess.management.CallAuthenticationManager;
import org.gcube.application.framework.search.library.impl.SearchHelper;
import org.gcube.application.framework.search.library.model.CollectionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ShowCollections
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(ShowCollections.class);
    private static final long serialVersionUID = 1L;
    private static final String operationID = "ShowCollections";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession session = request.getSession();
        logger.debug("The jsession id of the request on ShowCollections is: " + session.getId());
        AuthenticationResponse authenticationResp = CallAuthenticationManager.authenticateCall((HttpServletRequest)request, (String)operationID);
        if (!authenticationResp.isAuthenticated()) {
            response.sendError(401, authenticationResp.getUnauthorizedErrorMessage());
            return;
        }
        String username = authenticationResp.getUserId();
        HashMap collectionInfos = null;
        try {
            SearchHelper s_h = new SearchHelper(username, request.getSession().getId());
            collectionInfos = s_h.getAvailableCollections();
        }
        catch (Exception e) {
            logger.debug("Got an exception from Search Helper!");
            logger.error("Exception:", (Throwable)e);
            response.sendError(401, "Login to a Scope is needed");
            return;
        }
        if (request.getParameter("responseType") == null || request.getParameter("responseType").equals("") || request.getParameter("responseType").equals("json")) {
            JSONArray jArrayCollectionGroups = new JSONArray();
            for (CollectionInfo col : collectionInfos.keySet()) {
                JSONObject jsonColGroup = new JSONObject();
                jsonColGroup.put((Object)"name", (Object)col.getName());
                JSONArray jArrayCollections = new JSONArray();
                for (int j = 0; j < ((ArrayList)collectionInfos.get(col)).size(); ++j) {
                    JSONObject jsonCol = new JSONObject();
                    jsonCol.put((Object)"name", (Object)((CollectionInfo)((ArrayList)collectionInfos.get(col)).get(j)).getName());
                    jsonCol.put((Object)"colId", (Object)((CollectionInfo)((ArrayList)collectionInfos.get(col)).get(j)).getId());
                    jArrayCollections.add((Object)jsonCol);
                }
                jsonColGroup.put((Object)"collections", (Object)jArrayCollections);
                jArrayCollectionGroups.add((Object)jsonColGroup);
            }
            PrintWriter out = response.getWriter();
            out.print(jArrayCollectionGroups);
            out.flush();
            out.close();
        } else {
            PrintWriter out = response.getWriter();
            DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = null;
            try {
                docBuilder = dbfac.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                logger.error("Exception:", (Throwable)e);
            }
            Document doc = docBuilder.newDocument();
            Element root = doc.createElement("Collections");
            doc.appendChild(root);
            for (CollectionInfo col : collectionInfos.keySet()) {
                Element collectionGroupEl = doc.createElement("CollectionGroup");
                collectionGroupEl.setAttribute("name", col.getName());
                for (int j = 0; j < ((ArrayList)collectionInfos.get(col)).size(); ++j) {
                    Element collectionEl = doc.createElement("Collection");
                    Element collectionNameEl = doc.createElement("name");
                    collectionNameEl.setTextContent(((CollectionInfo)((ArrayList)collectionInfos.get(col)).get(j)).getName());
                    collectionEl.appendChild(collectionNameEl);
                    Element collectionIdEl = doc.createElement("colId");
                    collectionIdEl.setTextContent(((CollectionInfo)((ArrayList)collectionInfos.get(col)).get(j)).getId());
                    collectionEl.appendChild(collectionIdEl);
                    collectionGroupEl.appendChild(collectionEl);
                }
                root.appendChild(collectionGroupEl);
            }
            response.setContentType("text/xml");
            String xmlToStr = "";
            StringWriter writer = new StringWriter();
            try {
                DOMSource domSource = new DOMSource(doc);
                StreamResult result = new StreamResult(writer);
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer transformer = tf.newTransformer();
                transformer.transform(domSource, result);
            }
            catch (Exception e) {
                logger.error("Exception:", (Throwable)e);
            }
            xmlToStr = writer.toString();
            logger.debug(xmlToStr);
            out.write(xmlToStr);
            out.close();
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }
}

