/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.http.search;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.application.framework.http.anonymousaccess.management.AuthenticationResponse;
import org.gcube.application.framework.http.anonymousaccess.management.CallAuthenticationManager;
import org.gcube.application.framework.http.error.messages.HTTPErrorMessages;
import org.gcube.application.framework.http.search.SearchClientImpl;
import org.gcube.application.framework.search.library.exception.InitialBridgingNotCompleteException;
import org.gcube.application.framework.search.library.exception.InternalErrorException;
import org.gcube.application.framework.search.library.exception.NoSearchMasterEPRFoundException;
import org.gcube.application.framework.search.library.exception.QuerySyntaxException;
import org.gcube.application.framework.search.library.exception.gRS2BufferException;
import org.gcube.application.framework.search.library.exception.gRS2ReaderException;
import org.gcube.application.framework.search.library.exception.gRS2RecordDefinitionException;
import org.gcube.application.framework.search.library.impl.SearchHelper;
import org.gcube.application.framework.search.library.interfaces.ResultSetConsumerI;
import org.gcube.application.framework.search.library.model.CollectionInfo;
import org.gcube.application.framework.search.library.model.Criterion;
import org.gcube.application.framework.search.library.model.Field;
import org.gcube.application.framework.search.library.model.GeospatialInfo;
import org.gcube.application.framework.search.library.model.ISearchClient;
import org.gcube.application.framework.search.library.model.Query;
import org.gcube.application.framework.search.library.model.SearchASLException;
import org.gcube.application.framework.search.library.util.Order;
import org.gcube.application.framework.search.library.util.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Search
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(Search.class);
    private static final long serialVersionUID = 1L;
    private static final String operationID = "Search";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        JSONArray rsArrayJS;
        JSONObject resultsJS;
        int ofst;
        int num;
        HashMap<String, ResultSetConsumerI> rsEPRs;
        String queryRep;
        HashMap collectionInfos;
        AuthenticationResponse authenticationResp = CallAuthenticationManager.authenticateCall((HttpServletRequest)request, (String)operationID);
        if (!authenticationResp.isAuthenticated()) {
            response.sendError(401, authenticationResp.getUnauthorizedErrorMessage());
            return;
        }
        String username = authenticationResp.getUserId();
        if (request.getParameter("searchType") == null) {
            response.sendError(400, HTTPErrorMessages.MissingParameter((String)"searchType"));
            return;
        }
        String searchType = request.getParameter("searchType");
        HttpSession session = request.getSession();
        ASLSession mysession = null;
        mysession = SessionManager.getInstance().getASLSession(session.getId(), username);
        ResultSetConsumerI rs = null;
        Query q = new Query();
        ArrayList<String> selcols = new ArrayList<String>();
        String[] criteriaIds = null;
        String[] criteriaValues = null;
        String criterion = new String();
        String order = null;
        String distinct = null;
        String language = new String();
        String browseBy = new String();
        if (request.getParameter("allFields") != null && request.getParameter("allFields").equalsIgnoreCase("true")) {
            logger.info("allFields flag is true, getting all fields!");
            q.setSemanticEnrichment(true);
        } else {
            logger.info("allFields flag was false or not set -> return normal fileds!");
        }
        try {
            logger.info("Getting Available Collections");
            SearchHelper s_h = new SearchHelper(username, session.getId());
            collectionInfos = s_h.getAvailableCollections();
            if (collectionInfos != null) {
                logger.info("Number of collection infos: " + collectionInfos.size());
            }
        }
        catch (Exception e) {
            response.sendError(401, "Login to a VRE is needed");
            return;
        }
        boolean found = false;
        JSONArray selectedCollectionsJS = null;
        if (searchType.equals("browse") || searchType.equals("simple") || searchType.equals("advanced") || searchType.equals("geospatial")) {
            int i;
            try {
                JSONObject seleColsParam = (JSONObject)JSONSerializer.toJSON((Object)request.getParameter("selectedCollections"));
                selectedCollectionsJS = (JSONArray)seleColsParam.get("SelectedCollections");
            }
            catch (Exception e) {
                response.sendError(400, HTTPErrorMessages.WrongJSONInput((String)"selectedCollections"));
                return;
            }
            String[] selectedCollections = new String[selectedCollectionsJS.size()];
            for (i = 0; i < selectedCollectionsJS.size(); ++i) {
                selectedCollections[i] = (String)selectedCollectionsJS.get(i);
            }
            logger.info("Passed here");
            block56: for (i = 0; i < selectedCollections.length; ++i) {
                for (CollectionInfo colInfo : collectionInfos.keySet()) {
                    ArrayList cols = (ArrayList)collectionInfos.get(colInfo);
                    for (int j = 0; j < cols.size(); ++j) {
                        if (!((CollectionInfo)cols.get(j)).getId().equals(selectedCollections[i])) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    continue block56;
                }
            }
            logger.info("Found is: " + found);
            if (!found) {
                response.sendError(400, "Wrong selected collections");
                return;
            }
            for (i = 0; i < selectedCollections.length; ++i) {
                selcols.add(selectedCollections[i]);
            }
            logger.info("The scope is: " + mysession.getScopeName());
            logger.info("Number of sel cols: " + selcols.size());
            q.selectCollections(selcols, true, mysession);
            if (request.getParameter("presentFields") != null) {
                JSONArray presentationFieldsJS;
                try {
                    JSONObject jsonO = (JSONObject)JSONSerializer.toJSON((Object)request.getParameter("presentFields"));
                    presentationFieldsJS = jsonO.getJSONArray("presentFields");
                }
                catch (Exception e) {
                    response.sendError(400, HTTPErrorMessages.WrongJSONInput((String)"presentFields"));
                    return;
                }
                ArrayList<String> presFields = new ArrayList<String>();
                for (int i2 = 0; i2 < presentationFieldsJS.size(); ++i2) {
                    presFields.add((String)presentationFieldsJS.get(i2));
                }
            }
        }
        if (searchType.equals("browse")) {
            List brFields = q.getAvailableBrowseFields();
            if (brFields == null || brFields.size() == 0) {
                response.sendError(400, "No available browse fields");
                return;
            }
            order = request.getParameter("order");
            if (order != null) {
                if (order.equalsIgnoreCase("ASC")) {
                    q.setOrder(Order.ASC);
                } else {
                    q.setOrder(Order.DESC);
                }
            }
            if ((distinct = request.getParameter("distinct")) != null) {
                if (distinct.equalsIgnoreCase("true")) {
                    q.setDistinct(true);
                } else {
                    q.setDistinct(false);
                }
            }
            browseBy = request.getParameter("browseBy");
            q.setBrowseBy(browseBy);
            if (browseBy != null && !browseBy.equals("")) {
                found = false;
                for (int i = 0; i < brFields.size(); ++i) {
                    if (!((Field)brFields.get(i)).getId().equals(browseBy)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    response.sendError(400, "Wrong browse field selected");
                    return;
                }
            } else {
                response.sendError(400, "No search term defined");
                return;
            }
            try {
                rs = q.browse(mysession, (ISearchClient)new SearchClientImpl());
            }
            catch (InitialBridgingNotCompleteException e) {
                response.sendError(500, "Internal Server Error!");
                return;
            }
            catch (InternalErrorException e) {
                response.sendError(500, "Internal Server Error!");
                return;
            }
            catch (SearchASLException e) {
                logger.error("Exception:", (Throwable)e);
                response.sendError(500, "Search service has failed to fulfill the request!");
            }
        } else if (searchType.equals("simple")) {
            queryRep = "simple ";
            criterion = request.getParameter("searchTerms");
            if (criterion == null || criterion.equals("")) {
                response.sendError(400, "No search term specified");
                return;
            }
            q.setSearchTerm(criterion);
            queryRep = queryRep + criterion + " ";
            String sortBy = request.getParameter("sortBy");
            if (sortBy != null && !sortBy.equals("")) {
                q.setSortBy(sortBy);
            }
            if ((rsEPRs = (HashMap<String, ResultSetConsumerI>)mysession.getAttribute("rsEPRs")) != null) {
                rs = (ResultSetConsumerI)rsEPRs.get(queryRep);
                if (rs == null) {
                    logger.info("New rsEPR!!");
                    try {
                        rs = q.search(mysession, true, (ISearchClient)new SearchClientImpl());
                    }
                    catch (QuerySyntaxException e) {
                        logger.error("Exception:", (Throwable)e);
                    }
                    catch (NoSearchMasterEPRFoundException e) {
                        logger.error("Exception:", (Throwable)e);
                    }
                    catch (InitialBridgingNotCompleteException e) {
                        response.sendError(500, "Internal Server Error!");
                        return;
                    }
                    catch (InternalErrorException e) {
                        response.sendError(500, "Internal Server Error!");
                        return;
                    }
                    catch (SearchASLException e) {
                        logger.error("Exception:", (Throwable)e);
                        response.sendError(500, "Search service has failed to fulfill the request!");
                    }
                    rsEPRs.put(q.getQueryString(), rs);
                    mysession.setAttribute("rsEPRs", (Object)rsEPRs);
                } else {
                    logger.info("Use the same rsEPR :)");
                }
            } else {
                rsEPRs = new HashMap<String, ResultSetConsumerI>();
                logger.info("New epr!! - adding attribute to the session");
                try {
                    rs = q.search(mysession, true, (ISearchClient)new SearchClientImpl());
                }
                catch (QuerySyntaxException e) {
                    logger.error("Exception:", (Throwable)e);
                }
                catch (NoSearchMasterEPRFoundException e) {
                    logger.error("Exception:", (Throwable)e);
                }
                catch (InitialBridgingNotCompleteException e) {
                    response.sendError(500, "Internal Server Error!");
                    return;
                }
                catch (InternalErrorException e) {
                    response.sendError(500, "Internal Server Error!");
                    return;
                }
                catch (SearchASLException e) {
                    logger.error("Exception:", (Throwable)e);
                    response.sendError(500, "Search service has failed to fulfill the request!");
                }
                rsEPRs.put(q.getQueryString(), rs);
                mysession.setAttribute("rsEPRs", rsEPRs);
            }
        } else if (searchType.equals("advanced") || searchType.equals("geospatial")) {
            queryRep = "advanced ";
            for (int i = 0; i < selcols.size(); ++i) {
                queryRep = queryRep + (String)selcols.get(i) + " ";
            }
            language = request.getParameter("language");
            if (language == null || language.equals("")) {
                response.sendError(400, "No language selected");
                return;
            }
            List avLanguages = q.getAvailableLanguages();
            logger.info("Language: " + language);
            for (int i = 0; i < avLanguages.size(); ++i) {
                logger.info("lang: " + (String)avLanguages.get(i));
            }
            if (!avLanguages.contains(language)) {
                response.sendError(400, "The language parameter is wrong.");
                return;
            }
            try {
                q.setSelectedLanguage(language, mysession);
            }
            catch (InitialBridgingNotCompleteException e) {
                response.sendError(500, "Internal Server Error!");
                return;
            }
            catch (InternalErrorException e) {
                response.sendError(500, "Internal Server Error!");
                return;
            }
            if (request.getParameter("criteria") != null) {
                JSONArray criteriaJS;
                try {
                    criteriaJS = (JSONArray)JSONSerializer.toJSON((Object)request.getParameter("criteria"));
                }
                catch (Exception e) {
                    response.sendError(400, HTTPErrorMessages.WrongJSONInput((String)"criteria"));
                    return;
                }
                ArrayList<String> criteriaIdsList = new ArrayList<String>();
                ArrayList<String> criteriaValuesList = new ArrayList<String>();
                for (int i = 0; i < criteriaJS.size(); ++i) {
                    JSONObject criterionJS = (JSONObject)JSONSerializer.toJSON((Object)criteriaJS.get(i));
                    criteriaIdsList.add(criterionJS.getString("id"));
                    criteriaValuesList.add(criterionJS.getString("value"));
                    logger.info("---------------------- Adding criterion: " + criterionJS.getString("id"));
                    logger.info("---------------------- Adding criterion value: " + criterionJS.getString("value"));
                }
                String sortBy = request.getParameter("sortBy");
                List avSearchFields = q.getAvailableSearchFields();
                ArrayList<String> avSF = new ArrayList<String>();
                for (int m = 0; m < avSearchFields.size(); ++m) {
                    avSF.add(((Field)avSearchFields.get(m)).getId());
                }
                criteriaIds = new String[criteriaIdsList.size()];
                criteriaIdsList.toArray(criteriaIds);
                criteriaValues = new String[criteriaValuesList.size()];
                criteriaValuesList.toArray(criteriaValues);
                if (criteriaIds != null) {
                    for (int j = 0; j < criteriaIds.length; ++j) {
                        if (!avSF.contains(criteriaIds[j])) {
                            response.sendError(400, "Wrong criterion selected");
                            return;
                        }
                        Criterion newCrit = new Criterion();
                        newCrit.setSearchFieldId(criteriaIds[j]);
                        newCrit.setSearchFieldName(criteriaIds[j]);
                        newCrit.setSearchFieldValue(criteriaValues[j]);
                        queryRep = queryRep + criteriaIds[j] + " " + criteriaValues[j] + " ";
                        q.addCriterion(newCrit);
                    }
                }
                List sortFields = q.getAvailableSortFields();
                ArrayList<String> sortFieldIds = new ArrayList<String>();
                for (int i = 0; i < sortFields.size(); ++i) {
                    sortFieldIds.add(((Field)sortFields.get(i)).getId());
                }
                if (sortBy != null) {
                    if (!sortFieldIds.contains(sortBy)) {
                        response.sendError(400, "Wrong sortable field given");
                        return;
                    }
                    q.setSortBy(sortBy);
                    queryRep = queryRep + "sortBy " + sortBy;
                }
            }
            if (searchType.equals("geospatial")) {
                String startinDate = request.getParameter("start");
                String[] startingArray = startinDate.split("-");
                String startYear = startingArray[0];
                String startMonth = startingArray[1];
                String[] splitDay = startingArray[2].split("T");
                String startDay = splitDay[0];
                String endinDate = request.getParameter("end");
                startingArray = endinDate.split("-");
                String endYear = startingArray[0];
                String endMonth = startingArray[1];
                String[] endDaySplit = startingArray[2].split("T");
                String endDay = endDaySplit[0];
                queryRep = queryRep + startDay + "" + startMonth + "" + startYear + "" + endDay + "" + endMonth + "" + endYear + " ";
                String[] latitude = new String[4];
                String[] longitude = new String[4];
                String bbox = request.getParameter("bbox");
                String[] coordinates = bbox.split(",");
                latitude[0] = coordinates[0];
                latitude[1] = coordinates[2];
                latitude[2] = coordinates[4];
                latitude[3] = coordinates[6];
                longitude[0] = coordinates[1];
                longitude[1] = coordinates[3];
                longitude[2] = coordinates[5];
                longitude[3] = coordinates[7];
                String relation = request.getParameter("relation");
                Calendar cal = Calendar.getInstance();
                if (cal == null) {
                    logger.info("The calendar is null :)");
                }
                Calendar cal1 = Calendar.getInstance();
                Date startingDate = cal.getTime();
                Date endingDate = cal1.getTime();
                if (startDay != null && startMonth != null && startYear != null && endDay != null && endMonth != null && endYear != null) {
                    int dayInt = Integer.parseInt(startDay);
                    int monthInt = Integer.parseInt(startMonth);
                    int yearInt = Integer.parseInt(startYear);
                    logger.info("Year: " + yearInt);
                    cal.set(1, yearInt);
                    cal.set(2, monthInt);
                    cal.set(5, dayInt);
                    dayInt = Integer.parseInt(endDay);
                    monthInt = Integer.parseInt(endMonth);
                    yearInt = Integer.parseInt(endYear);
                    cal1.set(1, yearInt);
                    cal1.set(2, monthInt);
                    cal1.set(5, dayInt);
                } else {
                    startingDate = null;
                    endingDate = null;
                }
                Point[] point = new Point[latitude.length];
                for (int i = 0; i < latitude.length; ++i) {
                    point[i] = new Point();
                    queryRep = queryRep + latitude[i] + " " + longitude[i] + " ";
                    Double lat = Double.parseDouble(latitude[i]);
                    logger.info("latitude: " + lat);
                    if (point[i] == null) {
                        logger.info("The point is null");
                    }
                    point[i].setLatitude(lat.doubleValue());
                    Double longt = Double.parseDouble(longitude[i]);
                    point[i].setLongitude(longt.doubleValue());
                }
                queryRep = queryRep + relation;
                GeospatialInfo geoInfo = new GeospatialInfo();
                if (startingDate != null && endingDate != null) {
                    geoInfo.setStartingDate(startingDate);
                    geoInfo.setEndingDate(endingDate);
                }
                geoInfo.setBounds(point);
                geoInfo.setRelation(relation);
                q.setGeospatial(geoInfo);
            }
            rsEPRs = (HashMap<String, ResultSetConsumerI>)mysession.getAttribute("rsEPRs");
            logger.info("The queryRep is: " + queryRep);
            if (rsEPRs != null) {
                rs = (ResultSetConsumerI)rsEPRs.get(queryRep);
                if (rs == null) {
                    logger.info("New epr!!");
                    try {
                        rs = q.search(mysession, false, (ISearchClient)new SearchClientImpl());
                    }
                    catch (QuerySyntaxException e) {
                        logger.error("Exception:", (Throwable)e);
                    }
                    catch (NoSearchMasterEPRFoundException e) {
                        logger.error("Exception:", (Throwable)e);
                    }
                    catch (InitialBridgingNotCompleteException e) {
                        response.sendError(500, "Internal Server Error!");
                        return;
                    }
                    catch (InternalErrorException e) {
                        response.sendError(500, "Internal Server Error!");
                        return;
                    }
                    catch (SearchASLException e) {
                        logger.error("Exception:", (Throwable)e);
                        response.sendError(500, "Search service has failed to fulfill the request!");
                    }
                    rsEPRs.put(q.getQueryString(), rs);
                    mysession.setAttribute("rsEPRs", rsEPRs);
                } else {
                    logger.info("Use the same rsEPR :)");
                }
            } else {
                rsEPRs = new HashMap<String, ResultSetConsumerI>();
                logger.info("New epr!!! - adding attribute to the session");
                try {
                    rs = q.search(mysession, false, (ISearchClient)new SearchClientImpl());
                }
                catch (QuerySyntaxException e) {
                    logger.error("Exception:", (Throwable)e);
                }
                catch (NoSearchMasterEPRFoundException e) {
                    logger.error("Exception:", (Throwable)e);
                }
                catch (InitialBridgingNotCompleteException e) {
                    response.sendError(500, "Internal Server Error!");
                    return;
                }
                catch (InternalErrorException e) {
                    response.sendError(500, "Internal Server Error!");
                    return;
                }
                catch (SearchASLException e) {
                    logger.error("Exception:", (Throwable)e);
                    response.sendError(500, "Search service has failed to fulfill the request!");
                }
                rsEPRs.put(q.getQueryString(), rs);
                mysession.setAttribute("rsEPRs", rsEPRs);
            }
        } else if (searchType.equals("quick")) {
            queryRep = "quick ";
            criterion = request.getParameter("searchTerms");
            if (criterion == null) {
                response.sendError(400, "No search term specified");
                return;
            }
            queryRep = queryRep + criterion;
            HashMap<String, ResultSetConsumerI> rsEPRs2 = (HashMap<String, ResultSetConsumerI>)mysession.getAttribute("rsEPRs");
            if (rsEPRs2 != null) {
                rs = (ResultSetConsumerI)rsEPRs2.get(queryRep);
                if (rs == null) {
                    logger.info("New epr!!");
                    try {
                        rs = q.quickSearch(mysession, criterion, (ISearchClient)new SearchClientImpl());
                    }
                    catch (SearchASLException e) {
                        logger.error("Exception:", (Throwable)e);
                        response.sendError(500, "Search service has failed to fulfill the request!");
                    }
                    rsEPRs2.put(q.getQueryString(), rs);
                    mysession.setAttribute("rsEPRs", rsEPRs2);
                } else {
                    logger.info("Use the same rsEPR :)");
                }
            } else {
                rsEPRs2 = new HashMap<String, ResultSetConsumerI>();
                logger.info("New epr!!! - adding attribute to the session");
                try {
                    rs = q.quickSearch(mysession, criterion, (ISearchClient)new SearchClientImpl());
                }
                catch (SearchASLException e) {
                    logger.error("Exception:", (Throwable)e);
                    response.sendError(500, "Search service has failed to fulfill the request!");
                }
                rsEPRs2.put(q.getQueryString(), rs);
                mysession.setAttribute("rsEPRs", rsEPRs2);
            }
        } else {
            response.sendError(400, "Wrong Search Type selected");
            return;
        }
        String numResults = request.getParameter("count");
        if (numResults != null) {
            num = Integer.parseInt(numResults);
        } else {
            num = 10;
            numResults = "10";
        }
        String offset = request.getParameter("startIndex");
        if (offset != null) {
            ofst = offset.equals("0") && searchType.equals("browse") ? 1 : Integer.parseInt(offset);
        } else if (!searchType.equals("browse")) {
            ofst = 0;
            offset = "0";
        } else {
            ofst = 1;
            offset = "1";
        }
        List xmlResults = new ArrayList();
        mysession = SessionManager.getInstance().getASLSession(session.getId(), username);
        try {
            rs.setOnlyPresentables();
            xmlResults = rs.getResultsToText(num, ofst, mysession);
        }
        catch (gRS2ReaderException e1) {
            logger.error("Exception:", (Throwable)e1);
        }
        catch (gRS2RecordDefinitionException e1) {
            logger.error("Exception:", (Throwable)e1);
        }
        catch (gRS2BufferException e1) {
            logger.error("Exception:", (Throwable)e1);
        }
        logger.info("NUMBER OF HTTP RESULTS: " + xmlResults.size());
        if (request.getParameter("responseType") == null || request.getParameter("responseType").equals("json")) {
            response.setContentType("application/json");
            resultsJS = new JSONObject();
            rsArrayJS = new JSONArray();
            for (int j = 0; j < xmlResults.size(); ++j) {
                logger.info("Result: " + (String)xmlResults.get(j));
                JSONObject resultJS = new JSONObject();
                resultJS.put((Object)"Record", xmlResults.get(j));
                rsArrayJS.add((Object)resultJS);
            }
        } else {
            DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = null;
            try {
                docBuilder = dbfac.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                logger.error("Exception:", (Throwable)e);
            }
            Document doc = docBuilder.newDocument();
            Element root = doc.createElement("Results");
            doc.appendChild(root);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = null;
            try {
                builder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                logger.error("Exception:", (Throwable)e);
            }
            Document document = null;
            for (int j = 0; j < xmlResults.size(); ++j) {
                logger.info("Result: " + (String)xmlResults.get(j));
                try {
                    document = builder.parse(new InputSource(new StringReader((String)xmlResults.get(j))));
                }
                catch (SAXException e) {
                    logger.error("Exception:", (Throwable)e);
                }
                Element element = document.getDocumentElement();
                Node dup = doc.importNode(element, true);
                root.appendChild(dup);
            }
            response.setContentType("text/xml");
            PrintWriter out = response.getWriter();
            StringWriter writer = new StringWriter();
            try {
                DOMSource domSource = new DOMSource(doc);
                StreamResult result = new StreamResult(writer);
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer transformer = tf.newTransformer();
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.transform(domSource, result);
            }
            catch (Exception e) {
                logger.error("Exception:", (Throwable)e);
            }
            logger.info("Writing resultsString!!");
            out.write(writer.toString());
            out.close();
            return;
        }
        resultsJS.put((Object)"Results", (Object)rsArrayJS);
        PrintWriter out = response.getWriter();
        out.print(resultsJS);
        out.flush();
        out.close();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }
}

