/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.http.search;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.application.framework.http.anonymousaccess.management.AuthenticationResponse;
import org.gcube.application.framework.http.anonymousaccess.management.CallAuthenticationManager;
import org.gcube.application.framework.http.search.SearchClientImpl;
import org.gcube.application.framework.search.library.exception.InitialBridgingNotCompleteException;
import org.gcube.application.framework.search.library.exception.InternalErrorException;
import org.gcube.application.framework.search.library.exception.QuerySyntaxException;
import org.gcube.application.framework.search.library.exception.gRS2BufferException;
import org.gcube.application.framework.search.library.exception.gRS2ReaderException;
import org.gcube.application.framework.search.library.exception.gRS2RecordDefinitionException;
import org.gcube.application.framework.search.library.impl.SearchHelper;
import org.gcube.application.framework.search.library.interfaces.ResultSetConsumerI;
import org.gcube.application.framework.search.library.model.CollectionInfo;
import org.gcube.application.framework.search.library.model.Field;
import org.gcube.application.framework.search.library.model.ISearchClient;
import org.gcube.application.framework.search.library.model.Query;
import org.gcube.application.framework.search.library.model.SearchASLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class GenericSearch
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(GenericSearch.class);
    private static final long serialVersionUID = 1L;
    private static final String operationID = "Search";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int off_t;
        int num;
        AuthenticationResponse authenticationResp = CallAuthenticationManager.authenticateCall((HttpServletRequest)request, (String)operationID);
        if (!authenticationResp.isAuthenticated()) {
            response.sendError(401, authenticationResp.getUnauthorizedErrorMessage());
            return;
        }
        String username = authenticationResp.getUserId();
        HttpSession session = request.getSession();
        ASLSession mysession = null;
        mysession = SessionManager.getInstance().getASLSession(session.getId(), username);
        ResultSetConsumerI rs = null;
        Query q = new Query();
        if (request.getParameter("allFields") != null && request.getParameter("allFields").equalsIgnoreCase("true")) {
            logger.info("allFields flag is true, getting all fields!");
            q.setSemanticEnrichment(true);
        } else {
            logger.info("allFields flag was false or not set -> return normal fileds!");
        }
        try {
            String[] parameters;
            ArrayList<String> paramsList = new ArrayList<String>();
            for (String param : parameters = request.getParameterValues("searchTerms")) {
                paramsList.add(param);
            }
            rs = q.genericSearch(mysession, paramsList, (ISearchClient)new SearchClientImpl());
        }
        catch (InitialBridgingNotCompleteException e) {
            logger.error("Exception:", (Throwable)e);
            response.sendError(500, "Internal Server Error!");
            return;
        }
        catch (InternalErrorException e) {
            logger.error("Exception:", (Throwable)e);
            response.sendError(500, "Internal Server Error!");
            return;
        }
        catch (QuerySyntaxException e) {
            logger.error("Exception:", (Throwable)e);
            return;
        }
        catch (SearchASLException e) {
            logger.error("Exception:", (Throwable)e);
            response.sendError(500, "Search service has failed to fulfill the request!");
        }
        String numResults = request.getParameter("count");
        if (numResults != null) {
            num = Integer.parseInt(numResults);
        } else {
            num = 10;
            numResults = "10";
        }
        String offset = request.getParameter("startIndex");
        if (offset != null) {
            off_t = Integer.parseInt(offset);
        } else {
            off_t = 1;
            offset = "1";
        }
        try {
            logger.info("Getting Available Collections");
            SearchHelper s_h = new SearchHelper(username, session.getId());
            HashMap collectionInfos = s_h.getAvailableCollections();
            logger.info("collectionInfos.size()" + collectionInfos.size());
            logger.info("collectionInfos.keySet().size()" + collectionInfos.keySet().size());
            for (CollectionInfo ci : collectionInfos.keySet()) {
                logger.info("ci.getName()" + ci.getName());
                logger.info("ci.getPresentationFields().toArray().toString()" + ci.getPresentationFields().toArray().toString());
                logger.info("ci.getBrowsableFields().toArray().toString()" + ci.getBrowsableFields().toArray().toString());
            }
            if (collectionInfos != null) {
                logger.info("Number of collection infos: " + collectionInfos.size());
            }
        }
        catch (Exception e) {
            response.sendError(401, "Login to a VRE is needed");
            return;
        }
        List xmlResults = new ArrayList();
        mysession = SessionManager.getInstance().getASLSession(session.getId(), username);
        try {
            xmlResults = rs.getResultsToText(num, off_t, mysession);
        }
        catch (gRS2ReaderException e1) {
            logger.error("Exception:", (Throwable)e1);
            return;
        }
        catch (gRS2RecordDefinitionException e1) {
            logger.error("Exception:", (Throwable)e1);
            return;
        }
        catch (gRS2BufferException e1) {
            logger.error("Exception:", (Throwable)e1);
            return;
        }
        if (request.getParameter("responseType") == null || request.getParameter("responseType").equals("") || request.getParameter("responseType").equals("json")) {
            response.setContentType("application/json");
            JSONArray jArrayL = new JSONArray();
            List languages = q.getAvailableLanguages();
            if (languages != null) {
                jArrayL.addAll((Collection)languages);
                JSONObject languagesJS = new JSONObject();
                languagesJS.put((Object)"Languages", (Object)jArrayL);
            }
            JSONArray jArrayB = new JSONArray();
            List browseFields = q.getAvailableBrowseFields();
            if (browseFields != null) {
                for (int i = 0; i < browseFields.size(); ++i) {
                    JSONObject bJson = new JSONObject();
                    bJson.put((Object)"id", (Object)((Field)browseFields.get(i)).getId());
                    bJson.put((Object)"name", (Object)((Field)browseFields.get(i)).getName());
                    jArrayB.add((Object)bJson);
                }
            }
            JSONArray jArraySo = new JSONArray();
            List sortFields = q.getAvailableSortFields();
            if (sortFields != null) {
                for (int i = 0; i < sortFields.size(); ++i) {
                    JSONObject bJson = new JSONObject();
                    bJson.put((Object)"id", (Object)((Field)sortFields.get(i)).getId());
                    bJson.put((Object)"name", (Object)((Field)sortFields.get(i)).getName());
                    jArraySo.add((Object)bJson);
                }
            }
            JSONArray jArraySe = new JSONArray();
            List searchFields = q.getAvailableSearchFields();
            if (searchFields != null) {
                for (int i = 0; i < searchFields.size(); ++i) {
                    JSONObject bJson = new JSONObject();
                    bJson.put((Object)"id", (Object)((Field)searchFields.get(i)).getId());
                    bJson.put((Object)"name", (Object)((Field)searchFields.get(i)).getName());
                    jArraySe.add((Object)bJson);
                }
            }
            JSONObject responseJS = new JSONObject();
            responseJS.put((Object)"Languages", (Object)jArrayL);
            responseJS.put((Object)"AvailableBrowseFields", (Object)jArrayB);
            responseJS.put((Object)"AvailableSortFields", (Object)jArraySo);
            responseJS.put((Object)"AvailableSearchFields", (Object)jArraySe);
            PrintWriter out = response.getWriter();
            out.print(responseJS);
            out.flush();
            out.close();
        } else {
            DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = null;
            try {
                docBuilder = dbfac.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                logger.error("Exception:", (Throwable)e);
                return;
            }
            Document doc = docBuilder.newDocument();
            Element root = doc.createElement("Results");
            doc.appendChild(root);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = null;
            try {
                builder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                logger.error("Exception:", (Throwable)e);
                return;
            }
            Document document = null;
            for (int j = 0; j < xmlResults.size(); ++j) {
                logger.info("Result: " + (String)xmlResults.get(j));
                try {
                    document = builder.parse(new InputSource(new StringReader((String)xmlResults.get(j))));
                }
                catch (SAXException e) {
                    logger.error("Exception:", (Throwable)e);
                    return;
                }
                Element element = document.getDocumentElement();
                Node dup = doc.importNode(element, true);
                root.appendChild(dup);
            }
            response.setContentType("text/xml; charset=UTF-8");
            PrintWriter out = response.getWriter();
            StringWriter writer = new StringWriter();
            try {
                DOMSource domSource = new DOMSource(doc);
                StreamResult result = new StreamResult(writer);
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer transformer = tf.newTransformer();
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.transform(domSource, result);
            }
            catch (Exception e) {
                logger.error("Exception:", (Throwable)e);
            }
            finally {
                out.write(writer.toString());
                out.flush();
                out.close();
            }
        }
    }
}

