/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.http.search;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.application.framework.http.anonymousaccess.management.AuthenticationResponse;
import org.gcube.application.framework.http.anonymousaccess.management.CallAuthenticationManager;
import org.gcube.application.framework.http.error.messages.HTTPErrorMessages;
import org.gcube.application.framework.search.library.exception.InitialBridgingNotCompleteException;
import org.gcube.application.framework.search.library.exception.InternalErrorException;
import org.gcube.application.framework.search.library.impl.SearchHelper;
import org.gcube.application.framework.search.library.model.CollectionInfo;
import org.gcube.application.framework.search.library.model.Field;
import org.gcube.application.framework.search.library.model.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CollectionInfos
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(CollectionInfos.class);
    private static final long serialVersionUID = 1L;
    private static final String operationID = "ShowCollectionInfos";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        JSONObject jsonO;
        HttpSession session = request.getSession();
        AuthenticationResponse authenticationResp = CallAuthenticationManager.authenticateCall((HttpServletRequest)request, (String)operationID);
        if (!authenticationResp.isAuthenticated()) {
            response.sendError(401, authenticationResp.getUnauthorizedErrorMessage());
            return;
        }
        String username = authenticationResp.getUserId();
        HashMap collectionInfos = null;
        try {
            SearchHelper s_h = new SearchHelper(username, request.getSession().getId());
            collectionInfos = s_h.getAvailableCollections();
        }
        catch (Exception e) {
            response.sendError(401, "Login to a VRE is needed");
            return;
        }
        ASLSession mysession = SessionManager.getInstance().getASLSession(session.getId(), username);
        if (request.getParameter("selectedCollections") == null) {
            response.sendError(400, "Wrong Parameters given. No collections selected.");
            return;
        }
        try {
            jsonO = (JSONObject)JSONSerializer.toJSON((Object)request.getParameter("selectedCollections"));
        }
        catch (Exception e) {
            response.sendError(400, HTTPErrorMessages.WrongJSONInput((String)"selectedCollections"));
            return;
        }
        if (jsonO == null) {
            response.sendError(400, "selectedCollections parameter must be in JSON format.");
            return;
        }
        JSONArray selColArray = (JSONArray)jsonO.get("SelectedCollections");
        String[] selectedCollections = new String[selColArray.size()];
        for (int i = 0; i < selColArray.size(); ++i) {
            selectedCollections[i] = (String)selColArray.get(i);
        }
        if (selectedCollections == null || selectedCollections.length == 0) {
            response.sendError(400, "No collections selected");
            return;
        }
        Query q = new Query();
        ArrayList<String> selCols = new ArrayList<String>();
        ArrayList<String> avCols = new ArrayList<String>();
        for (CollectionInfo key : collectionInfos.keySet()) {
            ArrayList cols = (ArrayList)collectionInfos.get(key);
            for (int i = 0; i < cols.size(); ++i) {
                CollectionInfo col = (CollectionInfo)cols.get(i);
                avCols.add(col.getId());
            }
        }
        for (int i = 0; i < selectedCollections.length; ++i) {
            if (!avCols.contains(selectedCollections[i])) {
                response.sendError(400, "Wrong selected collection id given");
                return;
            }
            selCols.add(selectedCollections[i]);
        }
        try {
            q.selectCollections(selCols, true, mysession);
        }
        catch (Exception e) {
            response.sendError(400, "Wrong collection id given");
            return;
        }
        if (request.getParameter("responseType") == null || request.getParameter("responseType").equals("") || request.getParameter("responseType").equals("json")) {
            response.setContentType("application/json");
            JSONArray jArrayL = new JSONArray();
            List languages = q.getAvailableLanguages();
            jArrayL.addAll((Collection)languages);
            JSONObject languagesJS = new JSONObject();
            languagesJS.put((Object)"Languages", (Object)jArrayL);
            JSONArray jArrayB = new JSONArray();
            List browseFields = q.getAvailableBrowseFields();
            for (int i = 0; i < browseFields.size(); ++i) {
                JSONObject bJson = new JSONObject();
                bJson.put((Object)"id", (Object)((Field)browseFields.get(i)).getId());
                bJson.put((Object)"name", (Object)((Field)browseFields.get(i)).getName());
                jArrayB.add((Object)bJson);
            }
            JSONArray jArraySo = new JSONArray();
            List sortFields = q.getAvailableSortFields();
            for (int i = 0; i < sortFields.size(); ++i) {
                JSONObject bJson = new JSONObject();
                bJson.put((Object)"id", (Object)((Field)sortFields.get(i)).getId());
                bJson.put((Object)"name", (Object)((Field)sortFields.get(i)).getName());
                jArraySo.add((Object)bJson);
            }
            JSONArray jArraySe = new JSONArray();
            List searchFields = q.getAvailableSearchFields();
            for (int i = 0; i < searchFields.size(); ++i) {
                JSONObject bJson = new JSONObject();
                bJson.put((Object)"id", (Object)((Field)searchFields.get(i)).getId());
                bJson.put((Object)"name", (Object)((Field)searchFields.get(i)).getName());
                jArraySe.add((Object)bJson);
            }
            JSONObject responseJS = new JSONObject();
            responseJS.put((Object)"Languages", (Object)jArrayL);
            responseJS.put((Object)"AvailableBrowseFields", (Object)jArrayB);
            responseJS.put((Object)"AvailableSortFields", (Object)jArraySo);
            responseJS.put((Object)"AvailableSearchFields", (Object)jArraySe);
            PrintWriter out = response.getWriter();
            out.print(responseJS);
            out.flush();
            out.close();
        } else {
            DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = null;
            try {
                docBuilder = dbfac.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                logger.error("Exception:", (Throwable)e);
            }
            Document doc = docBuilder.newDocument();
            Element root = doc.createElement("CollectionsInfos");
            doc.appendChild(root);
            Element availableLanguagesEl = doc.createElement("AvailableLanguages");
            List languages = q.getAvailableLanguages();
            if (languages != null) {
                for (int i = 0; i < languages.size(); ++i) {
                    Element languageEl = doc.createElement("language");
                    Element languageNameEl = doc.createElement("name");
                    languageNameEl.setTextContent((String)languages.get(i));
                    languageEl.appendChild(languageNameEl);
                    availableLanguagesEl.appendChild(languageEl);
                }
            }
            root.appendChild(availableLanguagesEl);
            Element browseFieldsEl = doc.createElement("AvailableBrowseFields");
            List browseFields = q.getAvailableBrowseFields();
            if (browseFields != null) {
                for (int i = 0; i < browseFields.size(); ++i) {
                    Element browseFieldEl = doc.createElement("browseField");
                    Element fieldIdEl = doc.createElement("id");
                    fieldIdEl.setTextContent(((Field)browseFields.get(i)).getId());
                    Element fieldNameEl = doc.createElement("name");
                    fieldNameEl.setTextContent(((Field)browseFields.get(i)).getLabel());
                    browseFieldEl.appendChild(fieldIdEl);
                    browseFieldEl.appendChild(fieldNameEl);
                    browseFieldsEl.appendChild(browseFieldEl);
                }
            }
            root.appendChild(browseFieldsEl);
            Element sortFieldsEl = doc.createElement("AvailablesortFields");
            List sortFields = q.getAvailableSortFields();
            if (sortFields != null) {
                for (int i = 0; i < sortFields.size(); ++i) {
                    Element sortFieldEl = doc.createElement("sortField");
                    Element fieldIdEl = doc.createElement("id");
                    fieldIdEl.setTextContent(((Field)sortFields.get(i)).getId());
                    Element fieldNameEl = doc.createElement("name");
                    fieldNameEl.setTextContent(((Field)sortFields.get(i)).getLabel());
                    sortFieldEl.appendChild(fieldIdEl);
                    sortFieldEl.appendChild(fieldNameEl);
                    sortFieldsEl.appendChild(sortFieldEl);
                }
            }
            root.appendChild(sortFieldsEl);
            Element searchFieldsEl = doc.createElement("AvailableSearchFields");
            String language = request.getParameter("language");
            if (language != null) {
                try {
                    q.setSelectedLanguage(language, mysession);
                }
                catch (InitialBridgingNotCompleteException e) {
                    response.sendError(500, "Internal Server Error!");
                    return;
                }
                catch (InternalErrorException e) {
                    response.sendError(500, "Internal Server Error!");
                    return;
                }
            }
            List searchFields = q.getAvailableSearchFields();
            for (int i = 0; i < searchFields.size(); ++i) {
                Element searchFieldEl = doc.createElement("searchField");
                Element fieldIdEl = doc.createElement("id");
                fieldIdEl.setTextContent(((Field)searchFields.get(i)).getId());
                Element fieldNameEl = doc.createElement("name");
                fieldNameEl.setTextContent(((Field)searchFields.get(i)).getLabel());
                searchFieldEl.appendChild(fieldIdEl);
                searchFieldEl.appendChild(fieldNameEl);
                searchFieldsEl.appendChild(searchFieldEl);
            }
            root.appendChild(searchFieldsEl);
            response.setContentType("text/xml");
            PrintWriter out = response.getWriter();
            String xmlToStr = "";
            StringWriter writer = new StringWriter();
            try {
                DOMSource domSource = new DOMSource(doc);
                StreamResult result = new StreamResult(writer);
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer transformer = tf.newTransformer();
                transformer.transform(domSource, result);
            }
            catch (Exception e) {
                logger.error("Exception:", (Throwable)e);
            }
            xmlToStr = writer.toString();
            logger.info(xmlToStr);
            out.write(xmlToStr);
            out.close();
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }
}

