/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.http.content.access;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gcube.application.framework.contentmanagement.content.impl.DigitalObject;
import org.gcube.application.framework.contentmanagement.content.impl.DigitalObjectType;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.application.framework.http.anonymousaccess.management.AuthenticationResponse;
import org.gcube.application.framework.http.anonymousaccess.management.CallAuthenticationManager;
import org.gcube.application.framework.http.content.access.tools.ContentConsumers;
import org.gcube.application.framework.http.content.access.tools.ContentParsers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentViewer
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(ContentViewer.class);
    private static final long serialVersionUID = 1L;
    private static final String operationID = "GetContent";

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws IOException {
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AuthenticationResponse authenticationResp = CallAuthenticationManager.authenticateCall((HttpServletRequest)request, (String)operationID);
        if (!authenticationResp.isAuthenticated()) {
            response.sendError(401, authenticationResp.getUnauthorizedErrorMessage());
            return;
        }
        String username = authenticationResp.getUserId();
        String mime = "";
        String name = "";
        String collectionType = "";
        long length = 0L;
        try {
            String save = request.getParameter("save");
            String uri = request.getParameter("documentURI");
            logger.info("The document URI: " + uri);
            if (uri == null || uri.equals("")) {
                response.sendError(404);
                return;
            }
            ASLSession session = SessionManager.getInstance().getASLSession(request.getSession().getId(), username);
            DigitalObject digObj = new DigitalObject(session, uri);
            logger.debug("Session ID of request: " + request.getSession().getId());
            if (session != null) {
                logger.debug("Matches on ASL session with id:" + session.getExternalSessionID() + " of user: " + session.getUsername() + " and scope: " + session.getScope().toString());
            }
            mime = digObj.getMimeType();
            length = digObj.getLength();
            name = digObj.getCollectionName();
            if (digObj.getType() != null) {
                collectionType = digObj.getType().toString();
            }
            String oid = digObj.getObjectId();
            response.addHeader("Content-Name", name);
            response.addHeader("contentID", oid);
            String secondaryURLs = request.getParameter("secondaryURLs");
            if (secondaryURLs == null) {
                secondaryURLs = "";
            }
            String link = null;
            if (uri.contains("http://") && uri.contains("/tree/")) {
                logger.info("About to get tree object");
                String content = digObj.getContent();
                TreeMap links = null;
                if (collectionType.equalsIgnoreCase(DigitalObjectType.FIGIS.toString())) {
                    links = ContentParsers.parseFIGIS_Payload((String)content);
                }
                if (collectionType.equalsIgnoreCase(DigitalObjectType.OAI.toString())) {
                    links = ContentParsers.parseOAI_Payload((String)content);
                }
                if (links != null) {
                    if (secondaryURLs.equalsIgnoreCase("true")) {
                        List alternativeURLs = (List)links.get("alternativeURLs");
                        if (alternativeURLs != null && alternativeURLs.size() > 0) {
                            link = (String)alternativeURLs.get(0);
                        }
                    } else {
                        List mainURLs = (List)links.get("mainURLs");
                        if (mainURLs != null && mainURLs.size() > 0) {
                            link = (String)mainURLs.get(0);
                        }
                    }
                }
            } else {
                logger.info("link is probably from OpenSearch...");
                link = uri.contains("?") ? uri.split("?")[0] : uri;
            }
            ServletOutputStream out = response.getOutputStream();
            if (link != null && link != "") {
                URLConnection urlConn = new URL(link).openConnection();
                String mimeType = urlConn.getContentType();
                int fileSize = urlConn.getContentLength();
                logger.debug("Detected MIME type: " + mimeType);
                response.setContentType(mimeType);
                response.setContentLength(fileSize);
                ContentConsumers.getRawContent((String)link, (OutputStream)out);
            } else {
                logger.error("No data link found");
            }
            out.flush();
            out.close();
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }
}

