/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.speciesmanager.stubs.model;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.application.speciesmanager.stubs.model.CommonName;
import org.gcube.application.speciesmanager.stubs.model.DataSet;
import org.gcube.application.speciesmanager.stubs.model.Product;
import org.gcube.application.speciesmanager.stubs.model.Taxon;
import org.gcube.application.speciesmanager.stubs.pluginhelper.Capabilities;
import org.gcube.data.trees.data.Edge;
import org.gcube.data.trees.data.InnerNode;
import org.gcube.data.trees.data.Leaf;
import org.gcube.data.trees.data.Node;
import org.gcube.data.trees.data.Nodes;
import org.gcube.data.trees.data.Tree;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class ResultItem
extends Taxon {
    @XmlElement(required=true, nillable=false)
    private String provider;
    @XmlElement
    private List<Product> products;
    @XmlElement
    private List<CommonName> commonNames = new ArrayList<CommonName>();
    @XmlElement(required=true, nillable=false)
    private DataSet dataSet;
    @XmlElement(required=true, nillable=false)
    private String credits;

    protected ResultItem() {
    }

    private ResultItem(String id) {
        super(id);
    }

    public ResultItem(String id, String scientificName) {
        super(id, scientificName);
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
    }

    public List<Product> getProducts() {
        return this.products;
    }

    public void setProducts(List<Product> products) {
        this.products = products;
    }

    public String getCredits() {
        return this.credits;
    }

    public void setCredits(String credits) {
        this.credits = credits;
    }

    public List<CommonName> getCommonNames() {
        return this.commonNames;
    }

    public void setCommonNames(List<CommonName> commonNames) {
        this.commonNames = commonNames;
    }

    public Tree toTree() {
        Tree tree = this.node();
        tree.setAttribute("provider", this.getProvider());
        tree.add(Nodes.e((String)"dataSet", (Node)this.dataSet.node()));
        ArrayList<Edge> commonNameEdges = new ArrayList<Edge>();
        for (CommonName entry : this.commonNames) {
            commonNameEdges.add(Nodes.e((String)"commonName", (Node)Nodes.n((Edge[])new Edge[]{Nodes.e((String)"name", (Object)entry.getName()), Nodes.e((String)"language", (Object)entry.getLanguage())})));
        }
        if (commonNameEdges.size() > 0) {
            tree.add(Nodes.e((String)"commonNames", (Node)Nodes.n((Edge[])commonNameEdges.toArray(new Edge[commonNameEdges.size()]))));
        }
        if (this.products != null) {
            ArrayList<Edge> productsEdges = new ArrayList<Edge>();
            for (Product product : this.products) {
                productsEdges.add(Nodes.e((String)"product", (Node)Nodes.n((String)product.getKey(), (Edge[])new Edge[]{Nodes.e((String)"type", (Object)((Object)product.getType())), Nodes.e((String)"count", (Object)product.getCount())})));
            }
            if (productsEdges.size() > 0) {
                tree.add(Nodes.e((String)"products", (Node)Nodes.n((Edge[])productsEdges.toArray(new Edge[productsEdges.size()]))));
            }
        }
        return tree;
    }

    public static ResultItem fromTree(Tree tree) throws Exception {
        Node node;
        Field field;
        ResultItem item = new ResultItem(tree.id());
        if (tree.hasAttribute("provider")) {
            item.setProvider(tree.attribute("provider"));
        }
        Object object = ResultItem.class.getDeclaredFields();
        int n = ((Field[])object).length;
        int n2 = 0;
        while (n2 < n) {
            field = object[n2];
            if (tree.hasEdge(field.getName()) && tree.edge(field.getName()).target() instanceof Leaf) {
                field.setAccessible(true);
                node = tree.edge(field.getName()).target();
                field.set(item, ((Leaf)node).value());
            }
            ++n2;
        }
        object = Taxon.class.getDeclaredFields();
        n = ((Field[])object).length;
        n2 = 0;
        while (n2 < n) {
            field = object[n2];
            if (tree.hasEdge(field.getName()) && tree.edge(field.getName()).target() instanceof Leaf) {
                field.setAccessible(true);
                node = tree.edge(field.getName()).target();
                field.set(item, ((Leaf)node).value());
            }
            ++n2;
        }
        ArrayList<CommonName> commonNames = new ArrayList<CommonName>();
        if (tree.hasEdge("commonNames")) {
            InnerNode commonNamesNode = (InnerNode)tree.edge("commonNames").target();
            for (Edge edge : commonNamesNode.edges("commonName")) {
                String language = ((Leaf)((InnerNode)edge.target()).edge("language").target()).value();
                String commonName = ((Leaf)((InnerNode)edge.target()).edge("name").target()).value();
                commonNames.add(new CommonName(language, commonName));
            }
            item.setCommonNames(commonNames);
        }
        ArrayList<Product> products = new ArrayList<Product>();
        if (tree.hasEdge("products")) {
            InnerNode productsNode = (InnerNode)tree.edge("products").target();
            for (Edge edge : productsNode.edges("product")) {
                String type = ((Leaf)((InnerNode)edge.target()).edge("type").target()).value();
                String count = ((Leaf)((InnerNode)edge.target()).edge("count").target()).value();
                String key = edge.target().id();
                Product prod = new Product(Capabilities.valueOf(type), key);
                prod.setCount(Integer.parseInt(count));
                products.add(prod);
            }
            item.setProducts(products);
        }
        if (tree.hasEdge("parent")) {
            item.parent = Taxon.fromNode((InnerNode)tree.child("parent"));
        }
        if (tree.hasEdge("dataSet")) {
            item.dataSet = DataSet.fromNode((InnerNode)tree.child("dataSet"));
        }
        return item;
    }

    @Override
    public String toString() {
        StringBuilder toReturn = new StringBuilder();
        toReturn.append("[provider: " + this.provider + "]");
        if (this.products != null && this.products.size() > 0) {
            toReturn.append("[products: " + Arrays.toString(this.products.toArray(new Product[0])) + "]");
        }
        if (this.commonNames != null && this.commonNames.size() > 0) {
            toReturn.append("[commonNames: " + Arrays.toString(this.commonNames.toArray(new CommonName[0])) + "]");
        }
        toReturn.append("[credits: " + this.credits + "]");
        toReturn.append("[dataSet: " + this.dataSet + "]");
        toReturn.append(super.toString());
        return toReturn.toString();
    }
}

