package org.gcube.application.speciesmanager.stubs.pluginhelper.capabilities;

import java.util.Set;

import org.gcube.application.speciesmanager.stubs.pluginhelper.PropertySupport;

public interface NamesMappingCapability extends PropertySupport{

	/**
	 * 
	 * this method returns a set of common names related to the scientific name passed as input
	 * 
	 * @param scientificName to Map
	 * @return a set of commonNames
	 * @throws Exception
	 */
	public Set<String> scientificNameToCommonNamesMapping(String scientificName) throws Exception;
	
	/**
	 * 
	 * this method returns a set of scientific names related to the common name passed as input
	 *  
	 * @param commonName to Map
	 * @return a set of scientificNames
	 * @throws Exception
	 */
	public Set<String> commonNameToScientificNamesMapping(String commonName) throws Exception;
}
