/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.speciesmanager.specieslink;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gcube.application.speciesmanager.parser.DarwinRecord;
import org.gcube.application.speciesmanager.parser.RecordsIterator;
import org.gcube.application.speciesmanager.specieslink.OccurrencesCapabilityImpl;
import org.gcube.application.speciesmanager.stubs.model.DataProvider;
import org.gcube.application.speciesmanager.stubs.model.DataSet;
import org.gcube.application.speciesmanager.stubs.model.Product;
import org.gcube.application.speciesmanager.stubs.model.ResultItem;
import org.gcube.application.speciesmanager.stubs.model.Taxon;
import org.gcube.application.speciesmanager.stubs.pluginhelper.AbstractPlugin;
import org.gcube.application.speciesmanager.stubs.pluginhelper.Capabilities;
import org.gcube.application.speciesmanager.stubs.pluginhelper.Coordinate;
import org.gcube.application.speciesmanager.stubs.pluginhelper.Property;
import org.gcube.application.speciesmanager.stubs.pluginhelper.SearchTypes;
import org.gcube.application.speciesmanager.stubs.pluginhelper.capabilities.OccurrencesCapability;
import org.gcube.application.speciesmanager.stubs.pluginhelper.writers.ObjectWriter;
import org.gcube.common.core.resources.GCUBERuntimeResource;
import org.gcube.common.core.resources.runtime.AccessPoint;
import org.gcube.common.core.utils.logging.GCUBELog;

public class SpeciesLinkPlugin
extends AbstractPlugin {
    GCUBELog logger = new GCUBELog(SpeciesLinkPlugin.class);
    public static String baseurl;
    public static String model;

    public void initialize(GCUBERuntimeResource res) throws Exception {
        this.logger.trace((Object)"SpeciesPlugin starting initialization");
        for (AccessPoint ap : res.getAccessPoints()) {
            if (!ap.getEntryname().equals("tapir")) continue;
            baseurl = ap.getEndpoint();
            model = ap.getProperty("model");
            this.logger.trace((Object)("baseURL is " + baseurl + " and model is " + model));
        }
        this.logger.trace((Object)"SpeciesPlugin initialized");
        super.initialize(res);
    }

    public void update(GCUBERuntimeResource res) throws Exception {
        for (AccessPoint ap : res.getAccessPoints()) {
            if (!ap.getEntryname().equals("tapir")) continue;
            baseurl = ap.getEndpoint();
            model = ap.getProperty("model");
        }
    }

    public String getDescription() {
        return "Species Link Plugin";
    }

    public String getRepositoryName() {
        return "SpeciesLink";
    }

    public Set<SearchTypes> getSupportedSearch() {
        return Collections.singleton(SearchTypes.ScientificName);
    }

    public Set<Capabilities> getSupportedCapabilities() {
        return new HashSet<Capabilities>(){
            {
                this.add(Capabilities.Occurences);
            }
        };
    }

    public OccurrencesCapability getOccurrencesInterface() {
        return new OccurrencesCapabilityImpl();
    }

    public void searchByCommonName(String arg0, ObjectWriter<ResultItem> arg1, Property ... arg2) {
    }

    public void searchByScientificName(String scientificName, ObjectWriter<ResultItem> writer, Property ... p) {
        String f = "";
        try {
            f = SpeciesLinkPlugin.elaborateProps(p);
        }
        catch (Exception e) {
            this.logger.error((Object)"error elaborating properties", (Throwable)e);
            writer.close();
            return;
        }
        String filter = "http://rs.tdwg.org/dwc/dwcore/ScientificName%20like%20%22" + scientificName.replace(" ", "%20") + "%22" + f + "%20&orderBy=http://rs.tdwg.org/dwc/dwcore/InstitutionCode";
        RecordsIterator set = new RecordsIterator(baseurl, filter, model);
        RecordsIterator it = set.iterator();
        DarwinRecord element = null;
        DarwinRecord element1 = null;
        int count = 0;
        boolean flag = false;
        while (it.hasNext()) {
            flag = true;
            element = (DarwinRecord)it.next();
            if (element1 == null) {
                element1 = element;
            }
            if (element1.institutionCode.equals(element.institutionCode) & element1.scientificName.equals(element.scientificName)) {
                ++count;
                continue;
            }
            this.setResult(element1, count, writer);
            element1 = element;
            count = 1;
        }
        if (flag) {
            this.setResult(element1, count, writer);
        }
        writer.close();
    }

    private void setResult(DarwinRecord element, int count, ObjectWriter<ResultItem> writer) {
        ResultItem rs = new ResultItem(Integer.toString(element.globalUniqueIdentifier), element.scientificName);
        rs.setRank("species");
        rs.setCitation(element.authorYearOfScientificName);
        DataSet dataSet = new DataSet(element.collectionCode);
        dataSet.setName(element.collectionCode);
        rs.setDataSet(dataSet);
        DataProvider dp = new DataProvider(element.institutionCode);
        dp.setName(element.institutionCode);
        dataSet.setDataProvider(dp);
        Product prod = new Product(Capabilities.Occurences, "http://rs.tdwg.org/dwc/dwcore/ScientificName%20like%20%22" + element.scientificName.replace(" ", "%20") + "%22%20and%20http://rs.tdwg.org/dwc/dwcore/CollectionCode%20like%20%22" + element.collectionCode + "%22");
        prod.setCount(count);
        rs.setProducts(Collections.singletonList(prod));
        Taxon last = null;
        if (element.kingdom != "") {
            Taxon k = new Taxon("");
            k.setRank("kingdom");
            k.setScientificName(element.kingdom);
            last = k;
        }
        if (element.phylum != "") {
            Taxon p = new Taxon("");
            p.setRank("phylum");
            p.setScientificName(element.phylum);
            if (last != null) {
                p.setParent(last);
            }
            last = p;
        }
        if (element.clazz != "") {
            Taxon c = new Taxon("");
            c.setRank("class");
            c.setScientificName(element.clazz);
            if (last != null) {
                c.setParent(last);
            }
            last = c;
        }
        if (element.order != "") {
            Taxon o = new Taxon("");
            o.setRank("order");
            o.setScientificName(element.order);
            if (last != null) {
                o.setParent(last);
            }
            last = o;
        }
        if (element.family != "") {
            Taxon f = new Taxon("");
            f.setRank("family");
            f.setScientificName(element.family);
            if (last != null) {
                f.setParent(last);
            }
            last = f;
        }
        if (element.genus != "") {
            Taxon g = new Taxon("");
            g.setRank("genus");
            g.setScientificName(element.genus);
            if (last != null) {
                g.setParent(last);
            }
            last = g;
        }
        if (last != null) {
            rs.setParent(last);
        }
        this.logger.trace((Object)"putting result");
        writer.put((Object)rs);
    }

    private static String elaborateProps(Property[] properties) throws Exception {
        StringBuilder props = new StringBuilder();
        Property[] propertyArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            Property prop = propertyArray[n2];
            switch (prop.getProp()) {
                case CoordinateFrom: {
                    Coordinate coordFrom = (Coordinate)prop.getValue();
                    props.append("%20and%20http://rs.tdwg.org/dwc/geospatial/DecimalLatitude%20greaterThanOrEquals%20%22" + coordFrom.getLatitude() + "%22");
                    props.append("%20and%20http://rs.tdwg.org/dwc/geospatial/DecimalLongitude%20greaterThanOrEquals%20%22" + coordFrom.getLongitude() + "%22");
                    break;
                }
                case CoordinateTo: {
                    Coordinate coordTo = (Coordinate)prop.getValue();
                    props.append("%20and%20http://rs.tdwg.org/dwc/geospatial/DecimalLatitude%20lessThanOrEqual%20%22" + coordTo.getLatitude() + "%22");
                    props.append("%20and%20http://rs.tdwg.org/dwc/geospatial/DecimalLongitude%20lessThanOrEqual%20%22" + coordTo.getLongitude() + "%22");
                    break;
                }
                case DateFrom: {
                    Calendar dateFrom = (Calendar)prop.getValue();
                    SimpleDateFormat dfFrom = new SimpleDateFormat("yyyy-MM-dd");
                    props.append("%20and%20http://rs.tdwg.org/dwc/dwcore/DateLastModified%20greaterThanOrEquals%20%22" + dfFrom.format(dateFrom.getTime()) + "%22");
                    break;
                }
                case DateTo: {
                    Calendar dateTo = (Calendar)prop.getValue();
                    SimpleDateFormat dfTo = new SimpleDateFormat("yyyy-MM-dd");
                    props.append("%20and%20http://rs.tdwg.org/dwc/dwcore/DateLastModified%20lessThanOrEquals%20%22" + dfTo.format(dateTo.getTime()) + "%22");
                    break;
                }
            }
            ++n2;
        }
        return props.toString();
    }
}

