/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.speciesmanager.specieslink;

import java.util.HashSet;
import java.util.Set;
import org.gcube.application.speciesmanager.parser.DarwinRecord;
import org.gcube.application.speciesmanager.parser.RecordsIterator;
import org.gcube.application.speciesmanager.specieslink.SpeciesLinkPlugin;
import org.gcube.application.speciesmanager.stubs.model.BasisOfRecord;
import org.gcube.application.speciesmanager.stubs.model.Occurrence;
import org.gcube.application.speciesmanager.stubs.pluginhelper.Properties;
import org.gcube.application.speciesmanager.stubs.pluginhelper.capabilities.OccurrencesCapability;
import org.gcube.application.speciesmanager.stubs.pluginhelper.writers.ObjectWriter;

public class OccurrencesCapabilityImpl
implements OccurrencesCapability {
    public Set<Properties> getSupportedProperties() {
        return new HashSet<Properties>(){
            {
                this.add(Properties.DateFrom);
                this.add(Properties.DateTo);
                this.add(Properties.CoordinateFrom);
                this.add(Properties.CoordinateTo);
            }
        };
    }

    public void getOccurrencesById(ObjectWriter<Occurrence> writer, String ... ids) throws Exception {
        int i = 0;
        while (i < ids.length) {
            String filter = ids[i].replace(" ", "%20");
            RecordsIterator set = new RecordsIterator(SpeciesLinkPlugin.baseurl, filter, SpeciesLinkPlugin.model);
            RecordsIterator it = set.iterator();
            DarwinRecord element = null;
            while (it.hasNext()) {
                element = (DarwinRecord)it.next();
                Occurrence a = new Occurrence();
                a.setBasisOfRecord(OccurrencesCapabilityImpl.matchBasisOfRecord(element.basisOfRecord));
                a.setCatalogueNumber(element.catalogNumber);
                a.setCitation(element.identifiedBy);
                a.setCollectionCode(element.collectionCode);
                a.setCountry(element.country);
                a.setDecimalLatitude(element.decimalLatitude);
                a.setDecimalLongitude(element.decimalLongitude);
                a.setEventDate(null);
                a.setFamily(element.family);
                a.setInstitutionCode(element.institutionCode);
                a.setKingdom(element.kingdom);
                a.setLocality(element.country);
                a.setMaxDepth((double)element.maximumDepthInMeters);
                a.setMinDepth((double)element.minimumDepthInMeters);
                a.setModified(element.dateLastModified);
                a.setRecordedBy(element.identifiedBy);
                a.setScientificName(element.scientificName);
                writer.put((Object)a);
            }
            writer.close();
            ++i;
        }
    }

    private static BasisOfRecord matchBasisOfRecord(String value) {
        BasisOfRecord[] basisOfRecordArray = BasisOfRecord.values();
        int n = basisOfRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            BasisOfRecord record = basisOfRecordArray[n2];
            if (record.name().toLowerCase().equals(value.toLowerCase())) {
                return record;
            }
            ++n2;
        }
        if (value.toLowerCase().equals("S".toLowerCase())) {
            return BasisOfRecord.PreservedSpecimen;
        }
        if (value.toLowerCase().equals("Fotot".toLowerCase())) {
            return BasisOfRecord.MachineObservation;
        }
        return BasisOfRecord.HumanObservation;
    }
}

