/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.shlink.discovery;

import java.util.List;
import java.util.Map;
import org.gcube.application.shlink.FetchUrlShortenerResource;
import org.gcube.common.encryption.encrypter.StringEncrypter;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchUrlShortenerFromOldIS
extends FetchUrlShortenerResource {
    protected static Logger logger = LoggerFactory.getLogger(FetchUrlShortenerFromOldIS.class);

    public FetchUrlShortenerFromOldIS(String scope) throws Exception {
        super(scope);
        this.fetchUrlShortener();
    }

    @Override
    protected void fetchUrlShortener() throws Exception {
        try {
            logger.info("Trying to read the Runtime Resource with name {}, in the scope: {}", (Object)"HTTP-URL-Shortener-Shlink", (Object)this.scope);
            if (this.scope == null || this.scope.isEmpty()) {
                String msg = "Scope is null or empty!";
                throw new Exception(msg);
            }
            XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
            query.addCondition("$resource/Profile/Name/text() eq 'HTTP-URL-Shortener-Shlink'").setResult("$resource/Profile/AccessPoint");
            DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.AccessPoint.class);
            List endpoints = client.submit((Query)query);
            if (endpoints.size() == 0) {
                this.isAvailable = false;
                logger.warn("Runtime Resource HTTP-URL-Shortener-Shlink not found");
                throw new Exception("No Runtime Resource with name: HTTP-URL-Shortener-Shlink is available in the scope: " + this.scope);
            }
            ServiceEndpoint.AccessPoint shortnerAP = (ServiceEndpoint.AccessPoint)endpoints.get(0);
            if (shortnerAP != null) {
                this.config.setShortnerServiceUrl(shortnerAP.address());
                Map propertiesMap = shortnerAP.propertyMap();
                if (propertiesMap == null || propertiesMap.size() == 0) {
                    throw new Exception("You need to add the configurations as properties to HTTP-URL-Shortener-Shlink");
                }
                String encrKey = this.readPropertyValue(propertiesMap, "API_KEY", true);
                logger.debug("Read property with name {} and value {}", (Object)"API_KEY", (Object)encrKey);
                if (encrKey == null) {
                    logger.warn("The property {} is not available in the Runtime Resource {}", (Object)"API_KEY", (Object)"HTTP-URL-Shortener-Shlink");
                    this.config.setApiKey(null);
                    throw new Exception("The property API_KEY is not available in the Runtime Resource HTTP-URL-Shortener-Shlink");
                }
                String decryptedKey = StringEncrypter.getEncrypter().decrypt(encrKey);
                this.config.setApiKey(decryptedKey);
                logger.debug("Decrypted {}: {}+++MASKED-KEY+++", (Object)"API_KEY", (Object)decryptedKey.substring(0, decryptedKey.length() - 20));
                String domainValue = this.readPropertyValue(propertiesMap, "DOMAIN", false);
                this.config.setDomain(domainValue);
                logger.debug("Read property with name {} and value {}", (Object)"DOMAIN", (Object)domainValue);
            }
            if (this.config.getShortnerServiceUrl() == null || this.config.getApiKey() == null) {
                String error = "The access point in the RR: HTTP-URL-Shortener-Shlink for scope " + this.scope + " is not available correctly. Impossible to read the service URL or decrypt the password";
                logger.warn(error);
                throw new Exception(error);
            }
            logger.info("HTTP-URL-Shortener found in scope {}, shortnerServiceUrl: {}.", (Object)this.scope, (Object)this.config.getShortnerServiceUrl());
            this.isAvailable = true;
        }
        catch (Exception e) {
            logger.error("An error occurred reading Runtime Resource for name: HTTP-URL-Shortener-Shlink, the scope is: " + this.scope, (Throwable)e);
            this.isAvailable = false;
            throw new Exception("No HTTP-URL-Shortener-Shlink available!");
        }
    }

    @Override
    public boolean isAvailable() {
        return this.isAvailable;
    }
}

