/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.shlink;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Properties;
import org.gcube.application.shlink.FetchUrlShortenerResource;
import org.gcube.application.shlink.ShlinkRequest;
import org.gcube.application.shlink.discovery.FetchUrlShortenerFromNewIS;
import org.gcube.application.shlink.discovery.FetchUrlShortenerFromOldIS;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShlinkShortener {
    private static final String TAG_KEYWORDS_PROPERTIES = "tag-keywords.properties";
    public static final String SHORTENER = "HTTP-URL-Shortener-Shlink";
    public static final String KEY = "API_KEY";
    public static final String DOMAIN = "DOMAIN";
    private static final String DEFAULT_TAG = "workspace";
    protected static Logger LOGGER = LoggerFactory.getLogger(ShlinkShortener.class);
    private static final String[] TAG_KEYWORDS = ShlinkShortener.loadTagKeywords();
    private boolean isAvailable;
    private FetchUrlShortenerResource fetchUrlShortener;

    public ShlinkShortener(String scope) throws Exception {
        LOGGER.info("Initialized ShlinkShortener with keywords: " + Arrays.toString(TAG_KEYWORDS));
        this.fetchUrlShortener(scope);
        LOGGER.info("ShlinkShortener is available: " + this.isAvailable);
    }

    private void fetchUrlShortener(String scope) throws Exception {
        try {
            LOGGER.info("Trying to read the Runtime Resource with name {}, in the scope: {}", (Object)SHORTENER, (Object)scope);
            if (scope == null || scope.isEmpty()) {
                String msg = "Scope is null or empty!";
                throw new Exception(msg);
            }
            this.fetchUrlShortener = new FetchUrlShortenerFromNewIS(scope);
            this.isAvailable = this.fetchUrlShortener.isAvailable();
            if (!this.isAvailable) {
                LOGGER.warn("The URL Shortener from New IS is not available, trying to fetch from Old IS");
                this.fetchUrlShortener = new FetchUrlShortenerFromOldIS(scope);
                this.isAvailable = this.fetchUrlShortener.isAvailable();
            }
            this.fetchUrlShortener = new FetchUrlShortenerFromOldIS(scope);
            this.isAvailable = this.fetchUrlShortener.isAvailable();
        }
        catch (Exception e) {
            LOGGER.error("An error occurred reading Runtime Resource for name: HTTP-URL-Shortener-Shlink, the scope is: " + scope, (Throwable)e);
            this.isAvailable = false;
            throw new Exception("No HTTP-URL-Shortener-Shlink available!");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String[] loadTagKeywords() {
        Properties props = new Properties();
        ArrayList<String> keywords = new ArrayList<String>();
        try (InputStream input = ShlinkShortener.class.getClassLoader().getResourceAsStream(TAG_KEYWORDS_PROPERTIES);){
            String[] stringArray;
            String keyword;
            if (input == null) {
                LOGGER.warn("tag-keywords.properties file not found, using default keywords");
                String[] stringArray2 = ShlinkShortener.getDefaultKeywords();
                return stringArray2;
            }
            props.load(input);
            int index = 1;
            while ((keyword = props.getProperty("tag.keyword." + index)) != null && !keyword.trim().isEmpty()) {
                keywords.add(keyword.trim());
                ++index;
            }
            if (keywords.isEmpty()) {
                LOGGER.warn("No keywords found in properties file, using defaults");
                stringArray = ShlinkShortener.getDefaultKeywords();
                return stringArray;
            }
            LOGGER.info("Loaded " + keywords.size() + " tag keywords from properties file");
            stringArray = keywords.toArray(new String[0]);
            return stringArray;
        }
        catch (IOException e) {
            LOGGER.error("Error loading tag keywords from tag-keywords.properties properties file", (Throwable)e);
            return ShlinkShortener.getDefaultKeywords();
        }
    }

    private static String[] getDefaultKeywords() {
        return new String[]{"shub", "workspace-explorer-app", "gis", "analytics", "knime", "wekeo", "geo", "ctlg", "smp"};
    }

    private String[] extractTags(String longUrl) {
        if (longUrl == null || longUrl.trim().isEmpty()) {
            return new String[]{DEFAULT_TAG};
        }
        ArrayList<String> foundTags = new ArrayList<String>();
        String lowerUrl = longUrl.toLowerCase();
        for (String keyword : TAG_KEYWORDS) {
            if (!lowerUrl.contains(keyword)) continue;
            foundTags.add(keyword);
        }
        if (foundTags.isEmpty()) {
            foundTags.add(DEFAULT_TAG);
        }
        LOGGER.debug("Extracted tags from URL: " + String.valueOf(foundTags));
        return foundTags.toArray(new String[0]);
    }

    private String[] combineTags(String longUrl, String[] additionalTags) {
        String[] defaultTags = this.extractTags(longUrl);
        if (additionalTags == null || additionalTags.length == 0) {
            return defaultTags;
        }
        LinkedHashSet<String> uniqueTags = new LinkedHashSet<String>();
        for (String tag : defaultTags) {
            if (tag == null || tag.trim().isEmpty()) continue;
            uniqueTags.add(tag.trim());
        }
        for (String tag : additionalTags) {
            if (tag == null || tag.trim().isEmpty()) continue;
            uniqueTags.add(tag.trim());
        }
        Object[] result = uniqueTags.toArray(new String[0]);
        LOGGER.debug("Combined tags: " + Arrays.toString(result));
        return result;
    }

    public String shorten(String longUrl, String[] additionalTags, boolean findIfExists) throws Exception {
        if (longUrl == null) {
            return longUrl;
        }
        String domain = this.fetchUrlShortener.getDomain();
        String shlikServiceUrl = this.fetchUrlShortener.getShortnerServiceUrl();
        String apiKey = this.fetchUrlShortener.getApiKey();
        LOGGER.debug("shorten the input longUrl: " + longUrl + ", with domain: " + domain + ", and additional tags: " + (additionalTags != null ? Arrays.toString(additionalTags) : "none") + ", findIfExists: " + findIfExists);
        if (!this.isAvailable) {
            LOGGER.warn("The URL Shortener is not available, returning the original long URL");
            return longUrl;
        }
        ShlinkRequest request = new ShlinkRequest.Builder().shlinkBaseUrl(shlikServiceUrl).shlinkAPIKey(apiKey).longUrl(longUrl).domain(domain).additionalTags(additionalTags).findIfExists(findIfExists).build();
        String shortUrl = this.createShortUrl(request);
        if (shortUrl != null) {
            LOGGER.debug("Shortened URL: " + shortUrl);
            return shortUrl;
        }
        LOGGER.error("Failed to create short URL for: " + longUrl);
        return longUrl;
    }

    public String createShortUrl(String shlinkBaseUrl, String shlinkAPIKey, String longUrl) {
        ShlinkRequest shlinkRequest = new ShlinkRequest.Builder().shlinkBaseUrl(shlinkBaseUrl).shlinkAPIKey(shlinkAPIKey).longUrl(longUrl).build();
        return this.createShortUrl(shlinkRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String createShortUrl(ShlinkRequest shlinkRequest) {
        block34: {
            HttpURLConnection connection = null;
            try {
                String jsonInputString;
                LOGGER.debug("shlinkBaseUrl: " + shlinkRequest.getShlinkBaseUrl());
                Object apiEndpoint = shlinkRequest.getShlinkBaseUrl();
                if (!((String)apiEndpoint).endsWith("/")) {
                    apiEndpoint = (String)apiEndpoint + "/";
                }
                apiEndpoint = (String)apiEndpoint + "rest/v3/short-urls";
                try {
                    Object[] finalTags;
                    JSONObject jsonRequest = new JSONObject();
                    jsonRequest.put("longUrl", (Object)shlinkRequest.getLongUrl());
                    if (shlinkRequest.getDomain() != null && !shlinkRequest.getDomain().trim().isEmpty()) {
                        jsonRequest.put("domain", (Object)shlinkRequest.getDomain().trim());
                        LOGGER.info("Using custom domain: " + shlinkRequest.getDomain());
                    }
                    if ((finalTags = this.combineTags(shlinkRequest.getLongUrl(), shlinkRequest.getAdditionalTags())) != null && finalTags.length > 0) {
                        jsonRequest.put("tags", (Object)finalTags);
                        LOGGER.info("Using tags: " + Arrays.toString(finalTags));
                    }
                    if (shlinkRequest.isFindIfExists()) {
                        jsonRequest.put("findIfExists", true);
                        LOGGER.info("Using findIfExists: true");
                    }
                    jsonInputString = jsonRequest.toString();
                }
                catch (JSONException e) {
                    LOGGER.error("Failed to build JSON request", (Throwable)e);
                    String finalTags = null;
                    if (connection != null) {
                        connection.disconnect();
                    }
                    return finalTags;
                }
                LOGGER.info("Request JSON: " + jsonInputString);
                URL url = new URL((String)apiEndpoint);
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("X-Api-Key", shlinkRequest.getShlinkAPIKey());
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setRequestProperty("Accept", "application/json");
                connection.setDoOutput(true);
                LOGGER.debug("Sending POST request to: " + (String)apiEndpoint);
                try (OutputStream os = connection.getOutputStream();){
                    byte[] input = jsonInputString.getBytes(StandardCharsets.UTF_8);
                    os.write(input, 0, input.length);
                }
                int responseCode = connection.getResponseCode();
                LOGGER.debug("Response Code: " + responseCode);
                InputStream inputStream = responseCode >= 200 && responseCode < 300 ? connection.getInputStream() : connection.getErrorStream();
                StringBuilder response = new StringBuilder();
                try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                    String line;
                    while ((line = br.readLine()) != null) {
                        response.append(line.trim());
                    }
                }
                LOGGER.debug("Response Body: " + String.valueOf(response));
                if (responseCode >= 200 && responseCode < 300) {
                    try {
                        JSONObject jsonObject = new JSONObject(response.toString());
                        String shortUrl = jsonObject.getString("shortUrl");
                        LOGGER.info("Short URL created: " + shortUrl);
                        String string = shortUrl;
                        return string;
                    }
                    catch (JSONException e) {
                        LOGGER.error("Failed to parse JSON response: " + String.valueOf(response), (Throwable)e);
                        String string = null;
                        if (connection != null) {
                            connection.disconnect();
                        }
                        return string;
                    }
                }
                LOGGER.error("Request failed! Response: " + String.valueOf(response));
                String string = null;
                return string;
                {
                    catch (IOException e) {
                        LOGGER.error("Exception occurred while creating short URL", (Throwable)e);
                        break block34;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
        return null;
    }
}

