/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.shlink.discovery;

import java.io.InputStream;
import java.util.Properties;
import org.gcube.application.shlink.FetchUrlShortenerResource;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClient;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClientFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchUrlShortenerFromNewIS
extends FetchUrlShortenerResource {
    private static final String GCUBE_URL_SHORTENER_DEFAULT_QUERY_TEMPLATE = "gcube-url-shortener";
    protected static Logger logger = LoggerFactory.getLogger(FetchUrlShortenerFromNewIS.class);

    public FetchUrlShortenerFromNewIS(String scope) throws Exception {
        super(scope);
        this.fetchUrlShortener();
    }

    @Override
    protected void fetchUrlShortener() throws Exception {
        try {
            String trimmedResponse;
            logger.info("Trying to read from new IS the Resource with name {}, in the scope: {}", (Object)"HTTP-URL-Shortener-Shlink", (Object)this.scope);
            if (this.scope == null || this.scope.isEmpty()) {
                String msg = "Scope is null or empty!";
                throw new Exception(msg);
            }
            String queryTemplateName = this.readFromQueryTemplate();
            if (queryTemplateName == null || queryTemplateName.isEmpty()) {
                queryTemplateName = GCUBE_URL_SHORTENER_DEFAULT_QUERY_TEMPLATE;
                logger.info("Using default query template name: {}", (Object)queryTemplateName);
            }
            logger.info("Query template is: {}", (Object)queryTemplateName);
            ResourceRegistryClient resourceRegistryClient = ResourceRegistryClientFactory.create();
            String jsonString = resourceRegistryClient.runQueryTemplate(queryTemplateName);
            logger.debug("Query template response: {}", (Object)jsonString);
            if (jsonString != null && !jsonString.trim().isEmpty()) {
                trimmedResponse = jsonString.trim();
                if (this.isEmptyJsonResponse(trimmedResponse)) {
                    this.isAvailable = false;
                    logger.warn("Query template returned empty JSON: {}", (Object)trimmedResponse);
                    throw new Exception("No resources found in query template response: " + queryTemplateName);
                }
            } else {
                this.isAvailable = false;
                throw new Exception("Empty response from query template: " + queryTemplateName);
            }
            this.parseJsonResponse(trimmedResponse);
            logger.info("Successfully retrieved configuration from query template: {}", (Object)queryTemplateName);
            logger.info("Endpoint: {}", (Object)this.config.getShortnerServiceUrl());
            logger.info("DOMAIN: {}", (Object)this.config.getDomain());
            logger.info("API_KEY: {}***MASKED***", (Object)(this.config.getApiKey() != null ? this.config.getApiKey().substring(0, Math.min(10, this.config.getApiKey().length())) : "null"));
            this.isAvailable = true;
        }
        catch (Exception e) {
            logger.error("An error occurred fetching shortener configuration from new IS for: HTTP-URL-Shortener-Shlink, in the the scope: " + this.scope, (Throwable)e);
            this.isAvailable = false;
        }
    }

    @Override
    public boolean isAvailable() {
        return this.isAvailable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readFromQueryTemplate() {
        String queryTemplatePath = "query_template_shortener.properties";
        String propertyName = "IS_QUERY_TEMPLATE_SHORTENER";
        Properties properties = new Properties();
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(queryTemplatePath);){
            if (inputStream != null) {
                properties.load(inputStream);
                String value = properties.getProperty(propertyName);
                if (value != null && !value.trim().isEmpty()) {
                    String string = value.trim();
                    return string;
                }
                logger.warn("Property " + propertyName + " not found or empty");
                String string = null;
                return string;
            }
        }
        catch (Exception e) {
            logger.warn("Could not load from classpath: " + queryTemplatePath, (Throwable)e);
            return null;
        }
        logger.warn("Could not load from classpath: " + queryTemplatePath);
        return null;
    }

    private boolean isEmptyJsonResponse(String jsonResponse) {
        if (jsonResponse == null || jsonResponse.trim().isEmpty()) {
            return true;
        }
        String trimmed = jsonResponse.trim();
        if (trimmed.equals("[]")) {
            return true;
        }
        if (trimmed.equals("{}")) {
            return true;
        }
        if (trimmed.length() <= 2) {
            return true;
        }
        try {
            if (trimmed.startsWith("[") && trimmed.endsWith("]")) {
                JSONArray jsonArray = new JSONArray(trimmed);
                return jsonArray.length() == 0;
            }
            if (trimmed.startsWith("{") && trimmed.endsWith("}")) {
                JSONObject jsonObject = new JSONObject(trimmed);
                return jsonObject.length() == 0;
            }
        }
        catch (Exception e) {
            logger.debug("Could not parse JSON response, assuming not empty: {}", (Object)e.getMessage());
            return false;
        }
        return false;
    }

    private void parseJsonResponse(String jsonResponse) throws Exception {
        try {
            JSONArray jsonArray = new JSONArray(jsonResponse);
            if (jsonArray.length() == 0) {
                throw new Exception("JSON array is empty");
            }
            JSONObject configObject = jsonArray.getJSONObject(0);
            if (!configObject.has("ENDPOINT")) {
                throw new Exception("Missing required property: ENDPOINT");
            }
            this.config.setShortnerServiceUrl(configObject.getString("ENDPOINT"));
            if (!configObject.has("API_KEY")) {
                throw new Exception("Missing required property: API_KEY");
            }
            this.config.setApiKey(configObject.getString("API_KEY"));
            if (configObject.has("DOMAIN")) {
                this.config.setDomain(configObject.getString("DOMAIN"));
            }
            if (this.config.getShortnerServiceUrl() == null || this.config.getShortnerServiceUrl().trim().isEmpty()) {
                throw new Exception("ENDPOINT property is null or empty");
            }
            if (this.config.getApiKey() == null || this.config.getApiKey().trim().isEmpty()) {
                throw new Exception("API_KEY property is null or empty");
            }
            logger.debug("Successfully parsed configuration - Endpoint: {}, Domain: {}, API Key length: {}", new Object[]{this.config.getShortnerServiceUrl(), this.config.getDomain(), this.config.getApiKey() != null ? this.config.getApiKey().length() : 0});
        }
        catch (Exception e) {
            logger.error("Error parsing JSON response: {}", (Object)jsonResponse, (Object)e);
            throw new Exception("Failed to parse configuration from JSON response: " + e.getMessage());
        }
    }
}

