package org.gcube.application.shlink;

import java.util.Map;

import org.gcube.application.shlink.discovery.UrlShortenerConfig;
import org.gcube.common.resources.gcore.ServiceEndpoint.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * The abstract class FetchUrlShortenerResource provides a template for fetching
 * and managing the URL shortener service configuration from a runtime resource.
 * It defines methods to read properties and check availability of the service.
 * 
 * @author Francesco Mangiacrapa
 * @since July 2025
 */
public abstract class FetchUrlShortenerResource {

	protected static Logger logger = LoggerFactory.getLogger(FetchUrlShortenerResource.class);
	// protected static String suffixOption = null;

	protected UrlShortenerConfig config = new UrlShortenerConfig();

	/** Name of the runtime resource for URL shortener service */
	public final String SHORTENER = "HTTP-URL-Shortener-Shlink";
	public final String KEY = "API_KEY";
	public final String DOMAIN = "DOMAIN";
	protected boolean isAvailable = false;

	protected String scope;

	protected FetchUrlShortenerResource(String scope) throws Exception {
		this.scope = scope;
	}

	protected abstract void fetchUrlShortener() throws Exception;

	protected abstract boolean isAvailable();

	/**
	 * Read property value.
	 *
	 * @param propertiesMap the properties map
	 * @param key           the key
	 * @return the string
	 * @throws Exception the exception
	 */
	protected String readPropertyValue(Map<String, Property> propertiesMap, String key, boolean failOnNull)
			throws Exception {
		Property theProperty = propertiesMap.get(key) != null ? propertiesMap.get(key) : null;
		if (theProperty == null && failOnNull) {
			logger.error("The property {} is not available in the Runtime Resource {}", key, SHORTENER);
			throw new Exception("You need to add the " + key + " Property in the " + SHORTENER);
		}

		return theProperty.value();
	}

	protected String getScope() {
		return scope;
	}

	protected String getShortnerServiceUrl() {
		return config.getShortnerServiceUrl();
	}

	protected String getDomain() {
		return config.getDomain();
	}

	protected String getApiKey() {
		return config.getApiKey();
	}

}