/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.shlink;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Properties;
import org.gcube.application.shlink.FetchUrlShortenerResource;
import org.gcube.application.shlink.ShlinkRequest;
import org.gcube.application.shlink.discovery.FetchUrlShortenerFromNewIS;
import org.gcube.application.shlink.discovery.FetchUrlShortenerFromOldIS;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShlinkShortener {
    private static final String TAG_KEYWORDS_PROPERTIES = "tag-keywords.properties";
    public static final String SHORTENER = "HTTP-URL-Shortener-Shlink";
    public static final String KEY = "API_KEY";
    public static final String DOMAIN = "DOMAIN";
    private static final String DEFAULT_TAG = "workspace";
    protected static Logger LOGGER = LoggerFactory.getLogger(ShlinkShortener.class);
    private static final String[] TAG_KEYWORDS = ShlinkShortener.loadTagKeywords();
    private boolean isAvailable;
    private FetchUrlShortenerResource fetchUrlShortener;

    public ShlinkShortener(String scope) throws Exception {
        LOGGER.info("Initialized ShlinkShortener with keywords: " + Arrays.toString(TAG_KEYWORDS));
        this.fetchUrlShortener(scope);
        LOGGER.info("ShlinkShortener is available: " + this.isAvailable);
    }

    private void fetchUrlShortener(String scope) throws Exception {
        try {
            LOGGER.info("Trying to read the Runtime Resource with name {}, in the scope: {}", (Object)SHORTENER, (Object)scope);
            if (scope == null || scope.isEmpty()) {
                String msg = "Scope is null or empty!";
                throw new Exception(msg);
            }
            this.fetchUrlShortener = new FetchUrlShortenerFromNewIS(scope);
            this.isAvailable = this.fetchUrlShortener.isAvailable();
            if (!this.isAvailable) {
                LOGGER.warn("The URL Shortener from New IS is not available, trying to fetch from Old IS");
                this.fetchUrlShortener = new FetchUrlShortenerFromOldIS(scope);
                this.isAvailable = this.fetchUrlShortener.isAvailable();
            }
            this.fetchUrlShortener = new FetchUrlShortenerFromOldIS(scope);
            this.isAvailable = this.fetchUrlShortener.isAvailable();
        }
        catch (Exception e) {
            LOGGER.error("An error occurred reading Runtime Resource for name: HTTP-URL-Shortener-Shlink, the scope is: " + scope, (Throwable)e);
            this.isAvailable = false;
            throw new Exception("No HTTP-URL-Shortener-Shlink available!");
        }
    }

    private static String[] loadTagKeywords() {
        Properties props = new Properties();
        ArrayList<String> keywords = new ArrayList<String>();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream input = ShlinkShortener.class.getClassLoader().getResourceAsStream(TAG_KEYWORDS_PROPERTIES);){
                String keyword;
                if (input == null) {
                    LOGGER.warn("tag-keywords.properties file not found, using default keywords");
                    return ShlinkShortener.getDefaultKeywords();
                }
                props.load(input);
                int index = 1;
                while ((keyword = props.getProperty("tag.keyword." + index)) != null && !keyword.trim().isEmpty()) {
                    keywords.add(keyword.trim());
                    ++index;
                }
                if (keywords.isEmpty()) {
                    LOGGER.warn("No keywords found in properties file, using defaults");
                    return ShlinkShortener.getDefaultKeywords();
                }
                LOGGER.info("Loaded " + keywords.size() + " tag keywords from properties file");
                return keywords.toArray(new String[0]);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.error("Error loading tag keywords from tag-keywords.properties properties file", (Throwable)e);
            return ShlinkShortener.getDefaultKeywords();
        }
    }

    private static String[] getDefaultKeywords() {
        return new String[]{"shub", "workspace-explorer-app", "gis", "analytics", "knime", "wekeo", "geo", "ctlg", "smp"};
    }

    private String[] extractTags(String longUrl) {
        if (longUrl == null || longUrl.trim().isEmpty()) {
            return new String[]{DEFAULT_TAG};
        }
        ArrayList<String> foundTags = new ArrayList<String>();
        String lowerUrl = longUrl.toLowerCase();
        String[] stringArray = TAG_KEYWORDS;
        int n = TAG_KEYWORDS.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            if (lowerUrl.contains(keyword)) {
                foundTags.add(keyword);
            }
            ++n2;
        }
        if (foundTags.isEmpty()) {
            foundTags.add(DEFAULT_TAG);
        }
        LOGGER.debug("Extracted tags from URL: " + foundTags);
        return foundTags.toArray(new String[0]);
    }

    private String[] combineTags(String longUrl, String[] additionalTags) {
        String tag;
        String[] defaultTags = this.extractTags(longUrl);
        if (additionalTags == null || additionalTags.length == 0) {
            return defaultTags;
        }
        LinkedHashSet<String> uniqueTags = new LinkedHashSet<String>();
        String[] stringArray = defaultTags;
        int n = defaultTags.length;
        int n2 = 0;
        while (n2 < n) {
            tag = stringArray[n2];
            if (tag != null && !tag.trim().isEmpty()) {
                uniqueTags.add(tag.trim());
            }
            ++n2;
        }
        stringArray = additionalTags;
        n = additionalTags.length;
        n2 = 0;
        while (n2 < n) {
            tag = stringArray[n2];
            if (tag != null && !tag.trim().isEmpty()) {
                uniqueTags.add(tag.trim());
            }
            ++n2;
        }
        Object[] result = uniqueTags.toArray(new String[0]);
        LOGGER.debug("Combined tags: " + Arrays.toString(result));
        return result;
    }

    public String shorten(String longUrl, String[] additionalTags, boolean findIfExists) throws Exception {
        if (longUrl == null) {
            return longUrl;
        }
        String domain = this.fetchUrlShortener.getDomain();
        String shlikServiceUrl = this.fetchUrlShortener.getShortnerServiceUrl();
        String apiKey = this.fetchUrlShortener.getApiKey();
        LOGGER.debug("shorten the input longUrl: " + longUrl + ", with domain: " + domain + ", and additional tags: " + (additionalTags != null ? Arrays.toString(additionalTags) : "none") + ", findIfExists: " + findIfExists);
        if (!this.isAvailable) {
            LOGGER.warn("The URL Shortener is not available, returning the original long URL");
            return longUrl;
        }
        ShlinkRequest request = new ShlinkRequest.Builder().shlinkBaseUrl(shlikServiceUrl).shlinkAPIKey(apiKey).longUrl(longUrl).domain(domain).additionalTags(additionalTags).findIfExists(findIfExists).build();
        String shortUrl = this.createShortUrl(request);
        if (shortUrl != null) {
            LOGGER.debug("Shortened URL: " + shortUrl);
            return shortUrl;
        }
        LOGGER.error("Failed to create short URL for: " + longUrl);
        return longUrl;
    }

    public String createShortUrl(String shlinkBaseUrl, String shlinkAPIKey, String longUrl) {
        ShlinkRequest shlinkRequest = new ShlinkRequest.Builder().shlinkBaseUrl(shlinkBaseUrl).shlinkAPIKey(shlinkAPIKey).longUrl(longUrl).build();
        return this.createShortUrl(shlinkRequest);
    }

    /*
     * Loose catch block
     */
    private String createShortUrl(ShlinkRequest shlinkRequest) {
        block41: {
            HttpURLConnection connection = null;
            try {
                Object input;
                String jsonInputString;
                Object finalTags;
                LOGGER.debug("shlinkBaseUrl: " + shlinkRequest.getShlinkBaseUrl());
                String apiEndpoint = shlinkRequest.getShlinkBaseUrl();
                if (!apiEndpoint.endsWith("/")) {
                    apiEndpoint = String.valueOf(apiEndpoint) + "/";
                }
                apiEndpoint = String.valueOf(apiEndpoint) + "rest/v3/short-urls";
                try {
                    JSONObject jsonRequest = new JSONObject();
                    jsonRequest.put("longUrl", (Object)shlinkRequest.getLongUrl());
                    if (shlinkRequest.getDomain() != null && !shlinkRequest.getDomain().trim().isEmpty()) {
                        jsonRequest.put("domain", (Object)shlinkRequest.getDomain().trim());
                        LOGGER.info("Using custom domain: " + shlinkRequest.getDomain());
                    }
                    if ((finalTags = this.combineTags(shlinkRequest.getLongUrl(), shlinkRequest.getAdditionalTags())) != null && ((String[])finalTags).length > 0) {
                        jsonRequest.put("tags", finalTags);
                        LOGGER.info("Using tags: " + Arrays.toString((Object[])finalTags));
                    }
                    if (shlinkRequest.isFindIfExists()) {
                        jsonRequest.put("findIfExists", true);
                        LOGGER.info("Using findIfExists: true");
                    }
                    jsonInputString = jsonRequest.toString();
                }
                catch (JSONException e) {
                    LOGGER.error("Failed to build JSON request", (Throwable)e);
                    if (connection != null) {
                        connection.disconnect();
                    }
                    return null;
                }
                LOGGER.info("Request JSON: " + jsonInputString);
                URL url = new URL(apiEndpoint);
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("X-Api-Key", shlinkRequest.getShlinkAPIKey());
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setRequestProperty("Accept", "application/json");
                connection.setDoOutput(true);
                LOGGER.debug("Sending POST request to: " + apiEndpoint);
                finalTags = null;
                Object var7_11 = null;
                try (OutputStream os = connection.getOutputStream();){
                    input = jsonInputString.getBytes(StandardCharsets.UTF_8);
                    os.write((byte[])input, 0, ((byte[])input).length);
                }
                catch (Throwable throwable) {
                    if (finalTags == null) {
                        finalTags = throwable;
                    } else if (finalTags != throwable) {
                        ((Throwable)finalTags).addSuppressed(throwable);
                    }
                    throw finalTags;
                }
                int responseCode = connection.getResponseCode();
                LOGGER.debug("Response Code: " + responseCode);
                InputStream inputStream = responseCode >= 200 && responseCode < 300 ? connection.getInputStream() : connection.getErrorStream();
                StringBuilder response = new StringBuilder();
                input = null;
                Object var10_16 = null;
                try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                    String line;
                    while ((line = br.readLine()) != null) {
                        response.append(line.trim());
                    }
                }
                catch (Throwable throwable) {
                    if (input == null) {
                        input = throwable;
                    } else if (input != throwable) {
                        ((Throwable)input).addSuppressed(throwable);
                    }
                    throw input;
                }
                LOGGER.debug("Response Body: " + response);
                if (responseCode >= 200 && responseCode < 300) {
                    try {
                        JSONObject jsonObject = new JSONObject(response.toString());
                        String shortUrl = jsonObject.getString("shortUrl");
                        LOGGER.info("Short URL created: " + shortUrl);
                        String string = shortUrl;
                        return string;
                    }
                    catch (JSONException e) {
                        LOGGER.error("Failed to parse JSON response: " + response, (Throwable)e);
                        if (connection != null) {
                            connection.disconnect();
                        }
                        return null;
                    }
                }
                LOGGER.error("Request failed! Response: " + response);
                return null;
                {
                    catch (IOException e) {
                        LOGGER.error("Exception occurred while creating short URL", (Throwable)e);
                        break block41;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
        return null;
    }
}

