# Shlink Shortener

Shlink Shortener is a Java library that provides a simple and efficient way to create, manage, and track shortened URLs using the [Shlink](https://shlink.io/) service. This library is specifically designed to work with the Shlink instance hosted by the D4Science Infrastructure, offering seamless integration for applications that need URL shortening capabilities within the gCube ecosystem.

### Key Features

- **URL Shortening**: Create short, manageable URLs from long web addresses
- **URL Management**: Retrieve, update, and delete existing short URLs
- **Analytics**: Access detailed statistics and tracking information for shortened URLs
- **API Integration**: Full integration with Shlink REST API
- **D4Science Integration**: Optimized for use within the D4Science infrastructure

## Built With

* [OpenJDK](https://openjdk.java.net/) - Java 17
* [Maven](https://maven.apache.org/) - Dependency Management

## Documentation

## Change log

See the [Shlink Shortener Releases](https://code-repo.d4science.org/gCubeSystem/gcube-url-shortener/releases)

## Authors

* **Francesco Mangiacrapa** ([ORCID](https://orcid.org/0000-0002-6528-664X)) Computer Scientist at [ISTI-CNR Infrascience Group](https://infrascience.isti.cnr.it/)

## How to Cite this Software

Tell people how to cite this software.

* Cite an associated paper?
* Use a specific BibTeX entry for the software?

```Latex
    @Manual{,
        title = {Shlink Shortener},
        author = {Francesco Mangiacrapa at ISTI-CNR Infrascience Group},
        organization = {ISTI - CNR},
        address = {Pisa, Italy},
        year = 2025,
        note = {A Java library to interact with the [Shlink](https://shlink.io/) service hosted by D4Science Infrastructure},
        url = {http://www.http://gcube-system.org/}
    } 
```

* More information in [CITATION.cff](CITATION.cff) 

## License

This project is licensed under the terms specified in the [LICENSE.md](LICENSE.md) file


## About the gCube Framework

This software is part of the [gCubeFramework](https://www.gcube-system.org/): an
open-source software toolkit used for building and operating Hybrid Data
Infrastructures enabling the dynamic deployment of Virtual Research Environments
by favouring the realisation of reuse oriented policies.

The projects leading to this software have received funding from a series of European Union programmes see [FUNDING.md](FUNDING.md)
