/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.perform.service.engine.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.UUID;
import org.gcube.application.perform.service.engine.impl.Query;
import org.gcube.application.perform.service.engine.model.DBField;
import org.gcube.application.perform.service.engine.model.anagraphic.Batch;
import org.gcube.application.perform.service.engine.model.anagraphic.Farm;
import org.gcube.application.perform.service.engine.model.importer.ImportRoutineDescriptor;
import org.gcube.application.perform.service.engine.model.importer.ImportStatus;
import org.gcube.application.perform.service.engine.utils.CommonUtils;
import org.gcube.application.perform.service.engine.utils.ScopeUtils;

public class Queries {
    public static final Query GET_BATCH_BY_DESCRIPTIVE_KEY = new Query("Select * from batches where farmid=? AND type=? AND name= ?", new DBField[]{(DBField)DBField.Batch.fields.get("farmid"), (DBField)DBField.Batch.fields.get("type"), (DBField)DBField.Batch.fields.get("name")});
    public static final Query INSERT_BATCH = new Query("INSERT INTO batches (uuid,farmid,type,name) VALUES (?,?,?,?) ON CONFLICT DO NOTHING", new DBField[]{(DBField)DBField.Batch.fields.get("uuid"), (DBField)DBField.Batch.fields.get("farmid"), (DBField)DBField.Batch.fields.get("type"), (DBField)DBField.Batch.fields.get("name")});
    public static final Query GET_FARM_BY_ID = new Query("SELECT * from completefarms WHERE id = ?", new DBField[]{(DBField)DBField.Farm.fields.get("id")});
    public static final Query GET_BATCH_BY_ID = new Query("Select * from batches where id = ?", new DBField[]{(DBField)DBField.Batch.fields.get("id")});
    public static final Query GET_BATCH_BY_FARM_ID = new Query("Select * from batches where farmid = ?", new DBField[]{(DBField)DBField.Batch.fields.get("farmid")});
    public static final Query GET_OLDER_EQUIVALENT_IMPORT_ROUTINE = new Query("Select * from imports WHERE farmid=? AND batch_type=? AND sourceurl=? AND id<>? AND (end_time<? OR end_time IS NULL) ", new DBField[]{(DBField)DBField.ImportRoutine.fields.get("farmid"), (DBField)DBField.ImportRoutine.fields.get("batch_type"), (DBField)DBField.ImportRoutine.fields.get("sourceurl"), (DBField)DBField.ImportRoutine.fields.get("id"), (DBField)DBField.ImportRoutine.fields.get("end_time")});
    public static final Query ORPHAN_IMPORTS = new Query("SELECT * from imports where lock = ? OR lock IS NULL ", new DBField[]{(DBField)DBField.ImportRoutine.fields.get("lock")});
    public static final Query ACQUIRE_IMPORT_ROUTINE = new Query("UPDATE imports SET lock=? WHERE id = ? AND lock IS NULL", new DBField[]{(DBField)DBField.ImportRoutine.fields.get("lock"), (DBField)DBField.ImportRoutine.fields.get("id")});
    public static final Query GET_IMPORT_ROUTINE_BY_ID = new Query("SELECT *  from imports WHERE id = ?", new DBField[]{(DBField)DBField.ImportRoutine.fields.get("id")});
    public static final Query INSERT_ROUTINE = new Query("INSERT INTO imports(batch_type,caller,computation_id,computation_opid,computation_opname,computation_req,computation_url,farmid,lock,sourceurl,sourceversion,start_time,status) values (?,?,?,?,?,?,?,?,?,?,?,?,?)", new DBField[]{(DBField)DBField.ImportRoutine.fields.get("batch_type"), (DBField)DBField.ImportRoutine.fields.get("caller"), (DBField)DBField.ImportRoutine.fields.get("computation_id"), (DBField)DBField.ImportRoutine.fields.get("computation_opid"), (DBField)DBField.ImportRoutine.fields.get("computation_opname"), (DBField)DBField.ImportRoutine.fields.get("computation_req"), (DBField)DBField.ImportRoutine.fields.get("computation_url"), (DBField)DBField.ImportRoutine.fields.get("farmid"), (DBField)DBField.ImportRoutine.fields.get("lock"), (DBField)DBField.ImportRoutine.fields.get("sourceurl"), (DBField)DBField.ImportRoutine.fields.get("sourceversion"), (DBField)DBField.ImportRoutine.fields.get("start_time"), (DBField)DBField.ImportRoutine.fields.get("status")});
    public static final Query FILTER_IMPORTS = new Query("SELECT *  from imports WHERE farmid = ?", new DBField[]{(DBField)DBField.ImportRoutine.fields.get("farmid")});
    public static final Query LAST_GROUPED_IMPORTS = new Query("Select * from imports where farmid=? AND (batch_type,end_time) IN (Select batch_type,max(end_time) as end_time from imports WHERE farmid=? AND status = ? group by batch_type)", new DBField[]{(DBField)DBField.ImportRoutine.fields.get("farmid"), (DBField)DBField.ImportRoutine.fields.get("farmid"), (DBField)DBField.ImportRoutine.fields.get("status")});
    public static final Query UPDATE_IMPORT_STATUS = new Query("UPDATE imports SET status= ?, end_time=? WHERE id=?", new DBField[]{(DBField)DBField.ImportRoutine.fields.get("status"), (DBField)DBField.ImportRoutine.fields.get("end_time"), (DBField)DBField.ImportRoutine.fields.get("id")});

    public static Batch rowToBatch(ResultSet rs) throws SQLException {
        Batch toReturn = new Batch();
        toReturn.setFarmId(Long.valueOf(rs.getLong("farmid")));
        toReturn.setId(Long.valueOf(rs.getLong("id")));
        toReturn.setName(rs.getString("name"));
        toReturn.setType(rs.getString("type"));
        toReturn.setUuid((UUID)rs.getObject("uuid"));
        return toReturn;
    }

    public static Farm rowToFarm(ResultSet rs) throws SQLException {
        Farm toReturn = new Farm();
        toReturn.setAssociationId(Long.valueOf(rs.getLong("associationid")));
        toReturn.setAssociationUUID((UUID)rs.getObject("associationuuid"));
        toReturn.setCompanyId(Long.valueOf(rs.getLong("companyid")));
        toReturn.setCompanyUUID((UUID)rs.getObject("companyuuid"));
        toReturn.setId(Long.valueOf(rs.getLong("id")));
        toReturn.setUUID((UUID)rs.getObject("uuid"));
        return toReturn;
    }

    public static ImportRoutineDescriptor rowToDescriptor(ResultSet rs) throws SQLException {
        ImportRoutineDescriptor toReturn = new ImportRoutineDescriptor();
        toReturn.setBatch_type(rs.getString("batch_type"));
        toReturn.setCaller(rs.getString("caller"));
        toReturn.setComputationId(rs.getString("computation_id"));
        toReturn.setComputationOperator(rs.getString("computation_opid"));
        toReturn.setComputationOperatorName(rs.getString("computation_opname"));
        toReturn.setComputationRequest(rs.getString("computation_req"));
        toReturn.setComputationUrl(rs.getString("computation_url"));
        Timestamp endTime = rs.getTimestamp("end_time");
        if (endTime != null) {
            toReturn.setEndTime(endTime.toInstant());
        }
        toReturn.setFarmId(Long.valueOf(rs.getLong("farmid")));
        toReturn.setId(Long.valueOf(rs.getLong("id")));
        toReturn.setLock(rs.getString("lock"));
        toReturn.setSourceUrl(rs.getString("sourceurl"));
        toReturn.setSourceVersion(rs.getString("sourceversion"));
        toReturn.setStartTime(rs.getTimestamp("start_time").toInstant());
        toReturn.setStatus(ImportStatus.valueOf((String)rs.getString("status")));
        try {
            toReturn.setSubmitterIdentity(ScopeUtils.getClientId((String)CommonUtils.decryptString((String)rs.getString("caller"))));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return toReturn;
    }
}

