/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.perform.service.engine.impl;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.gcube.application.perform.service.LocalConfiguration;
import org.gcube.application.perform.service.engine.DataBaseManager;
import org.gcube.application.perform.service.engine.PerformanceManager;
import org.gcube.application.perform.service.engine.dm.DMException;
import org.gcube.application.perform.service.engine.dm.DMUtils;
import org.gcube.application.perform.service.engine.impl.Queries;
import org.gcube.application.perform.service.engine.impl.Query;
import org.gcube.application.perform.service.engine.impl.SchemaDefinition;
import org.gcube.application.perform.service.engine.model.CSVExportRequest;
import org.gcube.application.perform.service.engine.model.DBField;
import org.gcube.application.perform.service.engine.model.DBQueryDescriptor;
import org.gcube.application.perform.service.engine.model.InternalException;
import org.gcube.application.perform.service.engine.model.InvalidRequestException;
import org.gcube.application.perform.service.engine.model.importer.AnalysisType;
import org.gcube.application.perform.service.engine.model.importer.ImportRoutineDescriptor;
import org.gcube.application.perform.service.engine.model.importer.ImportedTable;
import org.gcube.data.analysis.dataminermanagercl.shared.data.computations.ComputationId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class PerformanceManagerImpl
implements PerformanceManager {
    private static final Logger log = LoggerFactory.getLogger(PerformanceManagerImpl.class);
    private static Map<AnalysisType, Set<ImportedTable>> analysisConfiguration = new HashMap();
    private static final String FLOAT_REGEX = "\\d*\\.\\d*";
    private static final String INTEGER_REGEX = "\\d*";

    public static Map<AnalysisType, Set<ImportedTable>> getAnalysisConfiguration() {
        return analysisConfiguration;
    }

    public Map<String, String> generateCSV(CSVExportRequest request) throws SQLException, InvalidRequestException, InternalException, IOException {
        log.trace("Serving {} ", (Object)request);
        HashMap<String, String> toReturn = new HashMap<String, String>();
        Set tables = PerformanceManagerImpl.getAnalysisSet((AnalysisType)request.getType());
        log.debug("Found {} tables in configuration", (Object)tables.size());
        for (ImportedTable t : tables) {
            SchemaDefinition schema = t.getSchema();
            if (!schema.getAnalysisEnabled().booleanValue()) continue;
            log.debug("Exporting {} : {} ", (Object)schema.getRelatedDescription(), (Object)t.getTableName());
            toReturn.putAll(t.exportCSV(request));
        }
        return toReturn;
    }

    public Map<String, String> getStatistics(AnalysisType type) throws SQLException, InvalidRequestException, InternalException, IOException {
        log.trace("Getting statistics for {} ", (Object)type);
        HashMap<String, String> toReturn = new HashMap<String, String>();
        Set tables = PerformanceManagerImpl.getAnalysisSet((AnalysisType)type);
        log.debug("Found {} tables in configuration", (Object)tables.size());
        for (ImportedTable t : tables) {
            log.debug("Exporting {} : {} ", (Object)t.getSchema().getRelatedDescription(), (Object)t.getTableName());
            toReturn.putAll(t.exportStatistics());
        }
        return toReturn;
    }

    public void loadOutputData(ImportRoutineDescriptor desc) throws SQLException, InvalidRequestException, InternalException, IOException, DMException {
        log.info("Importing output for {} ", (Object)desc);
        ComputationId computation = DMUtils.getComputation((ImportRoutineDescriptor)desc);
        Map outputs = DMUtils.getOutputFiles((ComputationId)computation);
        try (Connection conn = DataBaseManager.get().getConnection();){
            for (Map.Entry entry : outputs.entrySet()) {
                PerformanceManagerImpl.parse((String)((String)entry.getValue()), (String)((String)entry.getKey()), (ImportRoutineDescriptor)desc, (Connection)conn);
            }
            log.debug("IMPORTED ALL FILES for {}, gonna clean previous routines output. ", (Object)desc);
            PerformanceManagerImpl.removeOlderEquivalents((ImportRoutineDescriptor)desc, (Connection)conn);
            log.debug("COMMITTING...");
            conn.commit();
            log.info("Successfully imported data for {} ", (Object)desc);
        }
    }

    public static void initDatabase() throws SQLException, InternalException {
        DataBaseManager db = DataBaseManager.get();
        Connection conn = db.getConnection();
        Statement stmt = conn.createStatement();
        log.info("Checking / updateing base schema..");
        stmt.executeUpdate("CREATE TABLE IF NOT EXISTS batches (id bigserial NOT NULL,uuid uuid NOT NULL,farmid bigint NOT NULL,type varchar(100),name text,PRIMARY KEY (id),FOREIGN KEY (farmid) REFERENCES farms(farmid))");
        stmt.executeUpdate("CREATE TABLE IF NOT EXISTS imports (id bigserial NOT NULL,farmid bigint NOT NULL,batch_type varchar(100) NOT NULL,sourceurl text,sourceversion text,start_time timestamp with time zone,end_time timestamp with time zone,status varchar(20),caller text,computation_id text,computation_url text,computation_opid text,computation_opname text,computation_req text,lock varchar(200),primary key (id))");
        stmt.executeUpdate("CREATE OR REPLACE VIEW completefarms AS (Select f.farmid as id, f.uuid as uuid, c.companyid as companyid, c.uuid as companyuuid, a.associationid as associationid, a.uuid as associationuuid, c.name as company_name, a.name as association_name, f.name as name FROM farms as f INNER JOIN companies as c ON f.companyid=c.companyid INNER JOIN associations as a ON c.associationid = a. associationid)");
        for (Map.Entry entry : PerformanceManagerImpl.getAnalysisConfiguration().entrySet()) {
            for (ImportedTable t : (Set)entry.getValue()) {
                String createStmt = t.createStatement();
                log.debug("Creating Table with stmt {} ", (Object)createStmt);
                stmt.execute(createStmt);
            }
        }
        if (Boolean.parseBoolean(LocalConfiguration.getProperty((String)"schema.load.commit"))) {
            conn.commit();
        }
    }

    public static void importSchema(SchemaDefinition schema, String csvBasePath) throws IOException, SQLException, InternalException {
        log.info("Loading schema {} ", (Object)schema);
        String actualCSVPath = String.valueOf(csvBasePath) + "/" + schema.getCsvPath();
        log.debug("CSV path : {} ", (Object)actualCSVPath);
        ArrayList csvFieldsDefinition = PerformanceManagerImpl.getCSVFieldsDefinition((String)actualCSVPath, (SchemaDefinition)schema);
        AnalysisType analysisType = schema.getRelatedAnalysis();
        String tablename = (String.valueOf(analysisType.getId()) + "_" + schema.getRelatedDescription()).toLowerCase().replaceAll(" ", "_");
        ImportedTable table = new ImportedTable(tablename, schema, csvFieldsDefinition);
        if (!analysisConfiguration.containsKey(analysisType)) {
            analysisConfiguration.put(schema.getRelatedAnalysis(), new HashSet());
        }
        ((Set)analysisConfiguration.get(schema.getRelatedAnalysis())).add(table);
    }

    static Set<ImportedTable> getAnalysisSet(AnalysisType type) throws InvalidRequestException {
        if (!analysisConfiguration.containsKey(type)) {
            throw new InvalidRequestException("Analysis Configuration not found for " + type);
        }
        return (Set)analysisConfiguration.get(type);
    }

    private static final void removeOlderEquivalents(ImportRoutineDescriptor last, Connection conn) throws SQLException, InvalidRequestException {
        log.debug("Removing imports replaced by {} ", (Object)last);
        DBQueryDescriptor desc = new DBQueryDescriptor().add((DBField)DBField.ImportRoutine.fields.get("farmid"), (Object)last.getFarmId()).add((DBField)DBField.ImportRoutine.fields.get("batch_type"), (Object)last.getBatch_type()).add((DBField)DBField.ImportRoutine.fields.get("sourceurl"), (Object)last.getSourceUrl()).add((DBField)DBField.ImportRoutine.fields.get("id"), (Object)last.getId()).add((DBField)DBField.ImportRoutine.fields.get("end_time"), (Object)new Timestamp(Instant.now().toEpochMilli()));
        ResultSet rsEquivalents = Queries.GET_OLDER_EQUIVALENT_IMPORT_ROUTINE.get(conn, desc).executeQuery();
        while (rsEquivalents.next()) {
            ImportRoutineDescriptor older = Queries.rowToDescriptor((ResultSet)rsEquivalents);
            log.debug("Removing outputs from {} ", (Object)older);
            AnalysisType type = new AnalysisType(older);
            for (ImportedTable table : (Set)analysisConfiguration.get(type)) {
                log.debug("Cleaning {} of {} outputs", (Object)table.getTableName(), (Object)older);
                table.cleanByImportRoutine(older, conn);
            }
        }
    }

    private static final long parse(String path, String description, ImportRoutineDescriptor routine, Connection conn) throws IOException, SQLException, InvalidRequestException {
        URL csvUrl = new URL(path);
        BufferedReader in = new BufferedReader(new InputStreamReader(csvUrl.openStream()));
        CSVParser parser = CSVFormat.DEFAULT.withFirstRecordAsHeader().parse((Reader)in);
        AnalysisType type = new AnalysisType(routine);
        try {
            log.debug("Parsing file {} : {} ", (Object)description, (Object)path);
            ArrayList<String> csvSchema = new ArrayList<String>();
            for (Map.Entry entry : parser.getHeaderMap().entrySet()) {
                csvSchema.add((Integer)entry.getValue(), (String)entry.getKey());
            }
            log.debug("CSV Schema is {} ", csvSchema);
            long counter = 0L;
            for (ImportedTable table : (Set)analysisConfiguration.get(type)) {
                if (!table.matchesSchema(csvSchema)) continue;
                log.debug("Matching table is {} ", (Object)table.getTableName());
                Query query = table.getInsertQuery();
                PreparedStatement psInsert = query.prepare(conn);
                log.debug("Reading csvLines");
                for (CSVRecord record : parser) {
                    DBQueryDescriptor desc = table.getSetRow(record.toMap(), routine.getId());
                    query.fill(psInsert, desc);
                    counter += (long)psInsert.executeUpdate();
                }
                log.debug("Inserted {} lines into {} for routine {} [FARM ID {}]", new Object[]{counter, table.getTableName(), routine.getId(), routine.getFarmId()});
            }
            long l = counter;
            return l;
        }
        finally {
            parser.close();
            in.close();
        }
    }

    private static ArrayList<DBField> getCSVFieldsDefinition(String csvFile, SchemaDefinition schema) throws IOException {
        Reader in = null;
        CSVParser parser = null;
        try {
            HashSet<String> deanonimizationLabels = new HashSet<String>();
            if (schema.getAssociationUUIDField() != null) {
                deanonimizationLabels.add(schema.getAssociationUUIDField());
            }
            if (schema.getFarmUUIDField() != null) {
                deanonimizationLabels.add(schema.getFarmUUIDField());
            }
            if (schema.getBatchUUIDField() != null) {
                deanonimizationLabels.add(schema.getBatchUUIDField());
            }
            if (schema.getCompanyUUIDField() != null) {
                deanonimizationLabels.add(schema.getCompanyUUIDField());
            }
            in = new FileReader(csvFile);
            parser = CSVFormat.DEFAULT.withFirstRecordAsHeader().parse(in);
            Map headers = parser.getHeaderMap();
            ArrayList<DBField> toReturn = new ArrayList<DBField>();
            headers.forEach((key, value) -> {
                int type = Integer.MIN_VALUE;
                if (deanonimizationLabels.contains(key)) {
                    type = 12;
                }
                toReturn.add(new DBField(type, key));
            });
            parser.forEach(record -> toReturn.forEach(field -> {
                if (field.getType() != 12) {
                    String value = record.get(field.getFieldName());
                    if (value.matches("\\d*\\.\\d*") || value.matches("\\d*")) {
                        field.setType(7);
                    } else {
                        field.setType(12);
                    }
                }
            }));
            ArrayList<DBField> arrayList = toReturn;
            return arrayList;
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (parser != null) {
                parser.close();
            }
        }
    }
}

