/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.perform.service.engine.dm;

import java.util.ArrayList;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.gcube.application.perform.service.engine.dm.DMException;
import org.gcube.data.analysis.dataminermanagercl.server.dmservice.SClient;
import org.gcube.data.analysis.dataminermanagercl.server.monitor.DMMonitor;
import org.gcube.data.analysis.dataminermanagercl.server.monitor.DMMonitorListener;
import org.gcube.data.analysis.dataminermanagercl.server.monitor.DMMonitorTask;
import org.gcube.data.analysis.dataminermanagercl.shared.data.computations.ComputationId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsynchDMMonitor
extends DMMonitor {
    private static final Logger log = LoggerFactory.getLogger(AsynchDMMonitor.class);
    private int sleep = 2000;
    private int delay = 2000;
    private int period = 2000;
    private ComputationId computationId;
    private SClient sClient;
    private ArrayList<DMMonitorListener> listeners = new ArrayList();
    private Timer timer;
    private boolean notEnd;

    public AsynchDMMonitor(ComputationId computationId, SClient sClient) {
        super(computationId, sClient);
        this.computationId = computationId;
        this.sClient = sClient;
    }

    public void start() {
        throw new RuntimeException("Unecpetcted call to start() method");
    }

    public void startAsynch() throws DMException {
        try {
            log.debug("Start Monitoring");
            this.notEnd = true;
            this.timer = new Timer(false);
            DMMonitorTask dmMonitorTask = new DMMonitorTask((DMMonitor)this, this.computationId, this.sClient, this.listeners);
            log.debug("Start: " + new Date());
            this.timer.schedule((TimerTask)dmMonitorTask, this.delay, (long)this.period);
            log.debug("Scheduled.");
        }
        catch (Throwable e) {
            throw new DMException(e);
        }
    }

    public void add(DMMonitorListener listener) {
        this.listeners.add(listener);
    }

    public void addAll(ArrayList<DMMonitorListener> listeners) {
        this.listeners.addAll(listeners);
    }

    public void cancel() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.notEnd = false;
    }

    public int getSleep() {
        return this.sleep;
    }

    public void setSleep(int sleep) {
        this.sleep = sleep;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }
}

