/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.images;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.jdbc.JdbcPooledConnectionSource;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.TableUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.gcube.application.aquamaps.aquamapsservice.client.plugins.AbstractPlugin;
import org.gcube.application.aquamaps.aquamapsservice.client.proxies.Maps;
import org.gcube.application.aquamaps.images.Common;
import org.gcube.application.aquamaps.images.SpeciesInfoImportThread;
import org.gcube.application.aquamaps.images.exceptions.ImageNotFoundException;
import org.gcube.application.aquamaps.images.model.SpeciesInfo;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Common {
    public static final String SPECIES_PARAM = "species";
    public static final String IMAGE_JPEG = "image/jpeg";
    private static final String IMAGE_BASE_URL = "http://www.fishbase.org/images/thumbnails/jpg/";
    private static final Logger logger = LoggerFactory.getLogger(Common.class);
    private static final String configFile = "config.properties";
    public static final String SCOPE_PROP = "SCOPE";
    public static final String SUITABLE_PROP = "SUITABLE_ID";
    public static final String SUITABLE_2050_PROP = "SUITABLE_2050_ID";
    public static final String NATIVE_PROP = "NATIVE_ID";
    public static final String NATIVE_2050_PROP = "NATIVE_2050_ID";
    public static final String HELP_FILE = "HELP_FILE";
    public static final String IMAGE_NOT_FOUND_FILE = "IMAGE_NOT_FOUND_FILE";
    public static final String FETCH_ROUTINE_INTERVAL_MINUTES = "FETCH_ROUTINE_INTERVAL_MINUTES";
    private static Common instance;
    private Properties props = new Properties();
    private GCUBEScope scope = null;
    private Dao<SpeciesInfo, String> dao;
    private Long lastCompletedUpdate = 0L;
    private Map<String, String> lastConfiguration = null;

    public static synchronized Common get() {
        if (instance == null) {
            instance = new Common();
        }
        return instance;
    }

    public Common() {
        try {
            1 t = new /* Unavailable Anonymous Inner Class!! */;
            t.start();
            JdbcPooledConnectionSource connectionSource = new JdbcPooledConnectionSource("jdbc:h2:mem:occurrence;DB_CLOSE_DELAY=-1");
            this.dao = DaoManager.createDao((ConnectionSource)connectionSource, SpeciesInfo.class);
            TableUtils.createTableIfNotExists((ConnectionSource)connectionSource, SpeciesInfo.class);
            SpeciesInfoImportThread thread = new SpeciesInfoImportThread(this.props);
            thread.start();
        }
        catch (SQLException e) {
            logger.error("Unable to create db", (Throwable)e);
        }
    }

    public Maps getAMInterface() throws Exception {
        ScopeProvider.instance.set(this.props.getProperty(SCOPE_PROP));
        return (Maps)AbstractPlugin.maps().build();
    }

    public InputStream getSuitableMap(String scientificName) throws SQLException, ImageNotFoundException, MalformedURLException, IOException {
        if (!this.dao.idExists((Object)scientificName)) {
            throw new ImageNotFoundException();
        }
        SpeciesInfo info = (SpeciesInfo)this.dao.queryForId((Object)scientificName);
        if (info == null || info.getSuitableURI() == null) {
            throw new ImageNotFoundException();
        }
        return new URL(info.getSuitableURI()).openStream();
    }

    public InputStream getSuitable2050Map(String scientificName) throws SQLException, ImageNotFoundException, MalformedURLException, IOException {
        if (!this.dao.idExists((Object)scientificName)) {
            throw new ImageNotFoundException();
        }
        SpeciesInfo info = (SpeciesInfo)this.dao.queryForId((Object)scientificName);
        if (info == null || info.getSuitable2050URI() == null) {
            throw new ImageNotFoundException();
        }
        return new URL(info.getSuitable2050URI()).openStream();
    }

    public InputStream getNativeMap(String scientificName) throws SQLException, ImageNotFoundException, MalformedURLException, IOException {
        if (!this.dao.idExists((Object)scientificName)) {
            throw new ImageNotFoundException();
        }
        SpeciesInfo info = (SpeciesInfo)this.dao.queryForId((Object)scientificName);
        if (info == null || info.getNativeURI() == null) {
            throw new ImageNotFoundException();
        }
        return new URL(info.getNativeURI()).openStream();
    }

    public InputStream getNative2050Map(String scientificName) throws SQLException, ImageNotFoundException, MalformedURLException, IOException {
        if (!this.dao.idExists((Object)scientificName)) {
            throw new ImageNotFoundException();
        }
        SpeciesInfo info = (SpeciesInfo)this.dao.queryForId((Object)scientificName);
        if (info == null || info.getNative2050URI() == null) {
            throw new ImageNotFoundException();
        }
        return new URL(info.getNative2050URI()).openStream();
    }

    public InputStream getSpeciesPicture(String scientificName) throws SQLException, ImageNotFoundException, MalformedURLException, IOException {
        if (!this.dao.idExists((Object)scientificName)) {
            throw new ImageNotFoundException();
        }
        SpeciesInfo info = (SpeciesInfo)this.dao.queryForId((Object)scientificName);
        if (info == null || info.getPic() == null) {
            throw new ImageNotFoundException();
        }
        if (info.getPic().startsWith("http")) {
            return new URL(info.getPic()).openStream();
        }
        return new URL("http://www.fishbase.org/images/thumbnails/jpg/tn_" + info.getPic()).openStream();
    }

    public InputStream getImageNotFound() {
        return Common.class.getResourceAsStream(this.props.getProperty(IMAGE_NOT_FOUND_FILE));
    }

    public InputStream getHelpStream() {
        return Common.class.getResourceAsStream(this.props.getProperty(HELP_FILE));
    }

    public Dao<SpeciesInfo, String> getDao() {
        return this.dao;
    }

    public String getProperty(String property) {
        return this.props.getProperty(property);
    }

    public void setLastCompletedUpdate(Long lastCompletedUpdate) {
        this.lastCompletedUpdate = lastCompletedUpdate;
    }

    public Long getLastCompletedUpdate() {
        return this.lastCompletedUpdate;
    }

    public void setLastConfiguration(Map<String, String> lastConfiguration) {
        this.lastConfiguration = lastConfiguration;
    }

    public Map<String, String> getLastConfiguration() {
        return this.lastConfiguration;
    }

    static /* synthetic */ Properties access$0(Common common) {
        return common.props;
    }

    static /* synthetic */ Logger access$1() {
        return logger;
    }
}

