package org.gcube.application.aquamaps.images;

import java.io.IOException;
import java.io.InputStream;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.io.IOUtils;
import org.gcube.application.aquamaps.images.exceptions.ImageNotFoundException;
import org.gcube.application.aquamaps.images.exceptions.InvalidRequestException;
import org.gcube.common.core.utils.logging.GCUBELog;

public class Maps extends HttpServlet{

	private static final GCUBELog logger=new GCUBELog(Maps.class);

	private static final String SUITABLE="suitable";
	private static final String SUITABLE_2050="suitable/2050";
	private static final String NATIVE="native";
	private static final String NATIVE_2050="native/2050";
	private static Common common=Common.get();

	/**
	 * 
	 */
	private static final long serialVersionUID = 3628994804078627741L;


	@Override
	protected void doGet(HttpServletRequest req, HttpServletResponse resp)
	throws ServletException, IOException {
		InputStream is=null;
		try{

			String scientificName=req.getParameter(Common.SPECIES_PARAM);
			if(scientificName==null) throw new InvalidRequestException();
			scientificName=scientificName.toLowerCase();
			String mapType=req.getPathInfo().substring(1);

			resp.setContentType(Common.IMAGE_JPEG);
			
			if(mapType.equals(SUITABLE)) is=common.getSuitableMap(scientificName);
			else if(mapType.equals(SUITABLE_2050)) is=common.getSuitable2050Map(scientificName);
			else if(mapType.equals(NATIVE)) is=common.getNativeMap(scientificName);
			else if(mapType.equals(NATIVE_2050)) is=common.getNative2050Map(scientificName);
			else throw new InvalidRequestException();
			
			IOUtils.copy(is, resp.getOutputStream());
		}catch(IOException e){
			is=common.getImageNotFound();
			IOUtils.copy(is, resp.getOutputStream());
		}catch(ImageNotFoundException e){
			is=common.getImageNotFound();
			IOUtils.copy(is, resp.getOutputStream());
		}catch(InvalidRequestException e){
			resp.setStatus(HttpServletResponse.SC_BAD_REQUEST);
		}catch(Exception e){
			logger.error("Unexpected error ",e);
			resp.setStatus(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
		}finally{
			if(is!=null) IOUtils.closeQuietly(is);
			try{
				IOUtils.closeQuietly(resp.getOutputStream());
			}catch (Throwable t){
				logger.error("",t);
			}
		}
	}
}
