/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.service.rest.health;

import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Liveness;
import org.eclipse.microprofile.health.Readiness;
import org.gcube.application.cms.implementations.ImplementationProvider;
import org.gcube.application.geoportal.common.model.configuration.MongoConnection;
import org.gcube.application.geoportal.service.model.internal.db.Mongo;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Readiness
@Liveness
public class MongoHealthCheck
implements HealthCheck {
    private static final Logger log = LoggerFactory.getLogger(MongoHealthCheck.class);
    private String context;
    private Boolean includeCollections = false;
    public static final String SERVICE_NAME = "mongo";

    public HealthCheckResponse call() {
        return this.checkMongo(this.context);
    }

    public MongoHealthCheck(String context, Boolean includeCollections) {
        this.context = context;
        this.includeCollections = includeCollections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HealthCheckResponse checkMongo(String context) {
        log.debug("checkMongo in the context: {}", (Object)context);
        HealthCheckResponseBuilder buildHCRBuilder = HealthCheckResponse.named((String)SERVICE_NAME);
        Mongo mongo = null;
        try {
            HealthCheckResponse collections;
            ScopeProvider.instance.set(context);
            mongo = (Mongo)ImplementationProvider.get().getProvidedObjectByClass(Mongo.class);
            buildHCRBuilder = this.appendMongoInfo(buildHCRBuilder, mongo.getConnection());
            buildHCRBuilder.state(true);
            if (this.includeCollections != null && this.includeCollections.booleanValue()) {
                collections = mongo.getTheClient().getDatabase(mongo.getConnection().getDatabase()).listCollectionNames();
                log.info("listCollectionNames is null: {}", (Object)(collections == null ? 1 : 0));
                int i = 1;
                for (String coll : collections) {
                    log.debug("adding collection: {}", (Object)coll);
                    buildHCRBuilder.withData("collection_" + i, coll);
                    ++i;
                }
            }
            log.info("checkMongo is OK in the context: {}", (Object)context);
            collections = buildHCRBuilder.build();
            return collections;
        }
        catch (Exception e) {
            log.error("Error on checkMongo: ", (Throwable)e);
            log.warn("checkMongo is KO in the context: {}", (Object)context);
            buildHCRBuilder.state(false);
            if (mongo != null) {
                MongoConnection connection = null;
                try {
                    connection = mongo.getConnection();
                    buildHCRBuilder = this.appendMongoInfo(buildHCRBuilder, connection);
                }
                catch (Exception e1) {
                    buildHCRBuilder.withData("hosts", connection.getHosts() + "");
                }
            }
            HealthCheckResponse healthCheckResponse = buildHCRBuilder.build();
            return healthCheckResponse;
        }
        finally {
            ScopeProvider.instance.reset();
        }
    }

    private HealthCheckResponseBuilder appendMongoInfo(HealthCheckResponseBuilder buildHCRBuilder, MongoConnection connection) {
        buildHCRBuilder.withData("hosts", connection.getHosts() + "");
        buildHCRBuilder.withData("db_name ", connection.getDatabase());
        return buildHCRBuilder;
    }
}

