/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.service.engine.mongo;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import com.vdurmont.semver4j.Semver;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.InvalidParameterException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.gcube.application.cms.implementations.ImplementationProvider;
import org.gcube.application.cms.implementations.WorkspaceManager;
import org.gcube.application.cms.implementations.faults.DeletionException;
import org.gcube.application.cms.implementations.faults.InvalidLockException;
import org.gcube.application.cms.implementations.faults.InvalidUserRoleException;
import org.gcube.application.cms.implementations.faults.ProjectLockedException;
import org.gcube.application.cms.implementations.faults.ProjectNotFoundException;
import org.gcube.application.cms.implementations.faults.RegistrationException;
import org.gcube.application.cms.implementations.faults.UnauthorizedAccess;
import org.gcube.application.cms.implementations.utils.UserUtils;
import org.gcube.application.cms.plugins.LifecycleManager;
import org.gcube.application.cms.plugins.faults.EventException;
import org.gcube.application.cms.plugins.faults.InsufficientPrivileges;
import org.gcube.application.cms.plugins.faults.StepException;
import org.gcube.application.cms.plugins.faults.UnrecognizedStepException;
import org.gcube.application.cms.plugins.reports.EventExecutionReport;
import org.gcube.application.cms.plugins.reports.StepExecutionReport;
import org.gcube.application.cms.plugins.requests.BaseRequest;
import org.gcube.application.cms.plugins.requests.EventExecutionRequest;
import org.gcube.application.cms.plugins.requests.StepExecutionRequest;
import org.gcube.application.cms.serialization.Serialization;
import org.gcube.application.geoportal.common.faults.StorageException;
import org.gcube.application.geoportal.common.model.JSONPathWrapper;
import org.gcube.application.geoportal.common.model.configuration.Archive;
import org.gcube.application.geoportal.common.model.configuration.Configuration;
import org.gcube.application.geoportal.common.model.document.Lock;
import org.gcube.application.geoportal.common.model.document.Project;
import org.gcube.application.geoportal.common.model.document.access.Access;
import org.gcube.application.geoportal.common.model.document.access.AccessPolicy;
import org.gcube.application.geoportal.common.model.document.accounting.AccountingInfo;
import org.gcube.application.geoportal.common.model.document.accounting.PublicationInfo;
import org.gcube.application.geoportal.common.model.document.accounting.User;
import org.gcube.application.geoportal.common.model.document.filesets.RegisteredFile;
import org.gcube.application.geoportal.common.model.document.filesets.RegisteredFileSet;
import org.gcube.application.geoportal.common.model.document.lifecycle.LifecycleInformation;
import org.gcube.application.geoportal.common.model.document.relationships.Relationship;
import org.gcube.application.geoportal.common.model.rest.ConfigurationException;
import org.gcube.application.geoportal.common.model.rest.QueryRequest;
import org.gcube.application.geoportal.common.model.rest.RegisterFileSetRequest;
import org.gcube.application.geoportal.common.model.rest.TempFile;
import org.gcube.application.geoportal.common.model.useCaseDescriptor.DataAccessPolicy;
import org.gcube.application.geoportal.common.model.useCaseDescriptor.Field;
import org.gcube.application.geoportal.common.model.useCaseDescriptor.HandlerDeclaration;
import org.gcube.application.geoportal.common.model.useCaseDescriptor.RelationshipDefinition;
import org.gcube.application.geoportal.common.model.useCaseDescriptor.UseCaseDescriptor;
import org.gcube.application.geoportal.common.utils.StorageUtils;
import org.gcube.application.geoportal.service.engine.mongo.MongoManager;
import org.gcube.application.geoportal.service.engine.mongo.MongoManagerI;
import org.gcube.application.geoportal.service.engine.mongo.ProfiledMongoManager;
import org.gcube.application.geoportal.service.engine.mongo.UCDManagerI;
import org.gcube.application.geoportal.service.engine.providers.PluginManager;
import org.gcube.common.storagehub.client.dsl.FolderContainer;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ProfiledMongoManager
extends MongoManager
implements MongoManagerI<Project> {
    private static final Logger log = LoggerFactory.getLogger(ProfiledMongoManager.class);
    UseCaseDescriptor useCaseDescriptor;
    private final AtomicReference<Object> manager = new AtomicReference();

    protected String mongoIDFieldName() {
        return "_id";
    }

    public ProfiledMongoManager(String profileId) throws ConfigurationException, RegistrationException {
        log.info("Loading useCaseDescriptor ID {} ", (Object)profileId);
        if (profileId == null) {
            throw new InvalidParameterException("UseCaseDescriptor ID cannot be null");
        }
        this.useCaseDescriptor = ((UCDManagerI)ImplementationProvider.get().getProvidedObjectByClass(UCDManagerI.class)).getById(profileId);
        if (this.useCaseDescriptor == null) {
            throw new WebApplicationException("UseCaseDescriptor " + profileId + " not registered", Response.Status.NOT_FOUND);
        }
        this.init(this.getToUseCollectionName());
    }

    private String getToUseCollectionName() {
        return this.useCaseDescriptor.getId();
    }

    protected Project lock(String id, String op) throws ProjectNotFoundException, ProjectLockedException, JsonProcessingException, InvalidUserRoleException, UnauthorizedAccess {
        log.trace("Locking {} cause {} ", (Object)id, (Object)op);
        Lock lock = new Lock();
        lock.setId(UUID.randomUUID().toString());
        lock.setInfo(UserUtils.getCurrent().asInfo());
        lock.setOperation(op);
        Document filter = new Document(this.mongoIDFieldName(), (Object)ProfiledMongoManager.asId((String)id)).append("$or", Arrays.asList(new Document("_lock", (Object)new Document("$exists", (Object)false)), new Document("_lock", (Object)new Document("$type", (Object)"null"))));
        log.debug("Lock filter is {} ", (Object)filter.toJson());
        Object obj = this.getCollection().findOneAndUpdate((Bson)filter, (Bson)new Document("$set", (Object)new Document("_lock", (Object)Serialization.asDocument((Object)lock))), new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER));
        if (obj == null) {
            Project p = this.getByID(id);
            if (p.getLock() != null) {
                throw new ProjectLockedException("Project already locked : " + p.getLock());
            }
            log.error("Unable to lock {} ", (Object)id);
            log.debug("Existing project is {} ", (Object)p);
            throw new RuntimeException("Unable to lock unlocked project " + id);
        }
        return (Project)Serialization.convert((Object)obj, Project.class);
    }

    protected Project unlockAndUpdate(Project proj) throws InvalidLockException, ProjectNotFoundException, JsonProcessingException, InvalidUserRoleException, UnauthorizedAccess {
        log.info("Unlocking for update {} lock is {} ", (Object)proj.getId(), (Object)proj.getLock());
        Lock oldLock = proj.getLock();
        proj.setLock(null);
        Document filter = new Document(this.mongoIDFieldName(), (Object)ProfiledMongoManager.asId((String)proj.getId())).append("_lock._id", (Object)oldLock.getId());
        log.info("Filter document is {} ", (Object)filter.toJson());
        Object obj = this.getCollection().findOneAndReplace((Bson)filter, (Object)Serialization.asDocumentWithId((Project)proj), new FindOneAndReplaceOptions().returnDocument(ReturnDocument.AFTER));
        if (obj == null) {
            Project p = this.getByID(proj.getId());
            throw new InvalidLockException("Found lock for " + p.getId() + " is " + p.getLock() + ", expected is " + oldLock);
        }
        return (Project)Serialization.convert((Object)obj, Project.class);
    }

    protected Project unlockAndPatch(Project proj) throws InvalidLockException, ProjectNotFoundException, JsonProcessingException, InvalidUserRoleException, UnauthorizedAccess {
        log.info("Unlocking for patching {} lock is {} ", (Object)proj.getId(), (Object)proj.getLock());
        Lock oldLock = proj.getLock();
        Document filter = new Document(this.mongoIDFieldName(), (Object)ProfiledMongoManager.asId((String)proj.getId())).append("_lock._id", (Object)oldLock.getId());
        String documentValueAsJson = proj.getTheDocument().toJson();
        String updatedDocumentAsJson = new Document("_theDocument", (Object)documentValueAsJson).toJson();
        Document setUpdatedDocument = new Document("$set", (Object)updatedDocumentAsJson);
        log.info("Filter document is {} ", (Object)filter.toJson());
        log.info("$set is {} ", (Object)setUpdatedDocument);
        Object obj = this.getCollection().findOneAndUpdate((Bson)filter, (Bson)setUpdatedDocument, new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER));
        if (obj == null) {
            throw new InvalidLockException("Found lock for " + proj.getId() + " is " + proj.getLock() + ", expected is " + oldLock);
        }
        proj = this.getByID(proj.getId());
        proj = this.unlock(proj);
        return proj;
    }

    protected Project unlock(Project proj) throws InvalidLockException, InvalidUserRoleException, ProjectNotFoundException, UnauthorizedAccess {
        log.trace("Unlocking for update {} lock is {} ", (Object)proj.getId(), (Object)proj.getLock());
        Lock oldLock = proj.getLock();
        Document filter = new Document(this.mongoIDFieldName(), (Object)ProfiledMongoManager.asId((String)proj.getId())).append("_lock._id", (Object)oldLock.getId());
        Object obj = this.getCollection().findOneAndUpdate((Bson)filter, (Bson)new Document("$set", (Object)new Document("_lock", null)), new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER));
        if (obj == null) {
            Project p = this.getByID(proj.getId());
            throw new InvalidLockException("Found lock for " + p.getId() + " is " + p.getLock() + ", expected is " + oldLock);
        }
        return (Project)Serialization.convert((Object)obj, Project.class);
    }

    private LifecycleManager getLCManager() {
        try {
            LifecycleManager toReturn = null;
            List handlerDeclarations = (List)this.useCaseDescriptor.getHandlersMapByType().get("LifecycleManagement");
            if (handlerDeclarations == null || handlerDeclarations.isEmpty()) {
                throw new ConfigurationException("No Lifecycle Handler defined for useCaseDescriptor ID " + this.useCaseDescriptor.getId());
            }
            if (handlerDeclarations.size() > 1) {
                throw new ConfigurationException("Too many Lifecycle Handlers defined (" + handlerDeclarations + ") in useCaseDescriptor ID " + this.useCaseDescriptor.getId());
            }
            HandlerDeclaration lcHandlerDeclaration = (HandlerDeclaration)handlerDeclarations.get(0);
            log.debug("Looking for handler {} ", (Object)lcHandlerDeclaration);
            toReturn = (LifecycleManager)((PluginManager.PluginMap)ImplementationProvider.get().getProvidedObjectByClass(PluginManager.PluginMap.class)).get((Object)lcHandlerDeclaration.getId());
            if (toReturn == null) {
                throw new ConfigurationException("Unable to find Lifecycle Manager Plugin. ID " + lcHandlerDeclaration.getId());
            }
            return toReturn;
        }
        catch (Throwable t) {
            log.warn("Unable to load LC Manager ", t);
            return null;
        }
    }

    public Project registerNew(Document toRegisterDoc) throws IOException, InvalidUserRoleException {
        log.info("Registering new document in {} ", (Object)this.useCaseDescriptor.getId());
        log.trace("Going to register {}", (Object)toRegisterDoc.toJson());
        User u = UserUtils.getCurrent().asInfo().getUser();
        DataAccessPolicy policy = this.useCaseDescriptor.getMatching(u);
        log.trace("Access policy for user {} is {} ", (Object)u, (Object)policy);
        if (policy == null) {
            log.warn("No policy found for {}. Returning empty ", (Object)u);
            throw new InvalidUserRoleException("No policy defined for current user roles " + u.getRoles());
        }
        if (policy.getPolicy().getWrite().equals((Object)DataAccessPolicy.Policy.Type.none)) {
            throw new InvalidUserRoleException("User doesn't have write privileges " + u.getRoles());
        }
        Project toRegister = new Project();
        toRegister.setTheDocument(toRegisterDoc);
        PublicationInfo pubInfo = new PublicationInfo();
        pubInfo.setCreationInfo(UserUtils.getCurrent().asInfo());
        Access access = new Access();
        access.setLicense("CC-BY-4.0");
        access.setPolicy(AccessPolicy.OPEN);
        pubInfo.setAccess(access);
        toRegister.setInfo(pubInfo);
        toRegister.setProfileID(this.useCaseDescriptor.getId());
        toRegister.setProfileVersion(this.useCaseDescriptor.getVersion());
        toRegister.setVersion(new Semver("1.0.0"));
        LifecycleInformation draftInfo = new LifecycleInformation().cleanState();
        draftInfo.setPhase("DRAFT");
        draftInfo.setLastOperationStatus(LifecycleInformation.Status.OK);
        toRegister.setLifecycleInformation(draftInfo);
        toRegister = this.triggerEvent(toRegister, "INIT_DOCUMENT", null);
        log.debug("Going to register {}\u00a0", (Object)toRegister);
        ObjectId id = this.insertDoc(Serialization.asDocumentWithId((Project)toRegister));
        log.info("Obtained id {}\u00a0", (Object)id);
        try {
            return this.getByID(id.toHexString());
        }
        catch (InvalidUserRoleException | ProjectNotFoundException | UnauthorizedAccess e) {
            throw new WebApplicationException("Unexpected exception while registering project ", e);
        }
    }

    public Project update(String id, Document toSet) throws IOException, EventException, ProjectLockedException, ProjectNotFoundException, InvalidLockException, InvalidUserRoleException, UnauthorizedAccess {
        log.trace("Updating {}\u00a0", (Object)toSet);
        Project toUpdate = this.lock(id, "Manual update");
        try {
            User u = UserUtils.getCurrent().asInfo().getUser();
            DataAccessPolicy policy = this.useCaseDescriptor.getMatching(u);
            log.info("Registering Fileset for {} [{}] , policy for {} is {} ", new Object[]{id, this.useCaseDescriptor.getId(), u, policy});
            if (policy == null) {
                log.warn("No policy found for {}. Returning empty ", (Object)u);
                throw new InvalidUserRoleException("No policy defined for current user roles " + u.getRoles());
            }
            if (!policy.canWrite(toUpdate, u)) {
                throw new UnauthorizedAccess("No edit rights on project " + id);
            }
            toUpdate.setTheDocument(toSet);
            toUpdate.getLifecycleInformation().cleanState();
            toUpdate = this.onUpdate(toUpdate);
            return this.unlockAndUpdate(toUpdate);
        }
        catch (Throwable t) {
            log.error("Unexpected exception ", t);
            this.unlock(toUpdate);
            throw t;
        }
    }

    public Project patch(String id, Document toSet) throws IOException, EventException, ProjectLockedException, ProjectNotFoundException, InvalidLockException, InvalidUserRoleException, UnauthorizedAccess {
        log.trace("Patching {}\u00a0", (Object)toSet);
        Project toUpdate = this.lock(id, "Manual patch");
        try {
            User u = UserUtils.getCurrent().asInfo().getUser();
            DataAccessPolicy policy = this.useCaseDescriptor.getMatching(u);
            log.info("Registering Fileset for {} [{}] , policy for {} is {} ", new Object[]{id, this.useCaseDescriptor.getId(), u, policy});
            if (policy == null) {
                log.warn("No policy found for {}. Returning empty ", (Object)u);
                throw new InvalidUserRoleException("No policy defined for current user roles " + u.getRoles());
            }
            if (!policy.canWrite(toUpdate, u)) {
                throw new UnauthorizedAccess("No edit rights on project " + id);
            }
            toUpdate.setTheDocument(toSet);
            toUpdate.getLifecycleInformation().cleanState();
            toUpdate = this.onUpdate(toUpdate);
            return this.unlockAndPatch(toUpdate);
        }
        catch (Throwable t) {
            log.error("Unexpected exception ", t);
            this.unlock(toUpdate);
            throw t;
        }
    }

    public Project setRelation(String id, String relation, String targetUCD, String targetId) throws IOException, EventException, ProjectLockedException, ProjectNotFoundException, InvalidLockException, InvalidUserRoleException, UnauthorizedAccess, RegistrationException, ConfigurationException {
        Project toUpdate = this.lock(id, "Set Relation " + relation + " toward " + targetUCD + ":" + targetId);
        try {
            List matching;
            log.info(this.getUseCaseDescriptor().getId() + ":" + id + " setting relation " + relation + " toward " + targetUCD + ":" + targetId);
            String toSetReverseRelation = null;
            List existingDefinitions = this.getUseCaseDescriptor().getRelationshipDefinitions();
            for (RelationshipDefinition def : existingDefinitions) {
                if (!def.getId().equals(relation)) continue;
                toSetReverseRelation = def.getReverseRelationId();
            }
            log.debug("{} reverse relation for {} is {}", new Object[]{this.getUseCaseDescriptor().getId(), relation, toSetReverseRelation});
            List relations = toUpdate.getRelationshipsByName(relation);
            if (!relations.isEmpty() && (matching = relations.stream().filter((? super T r) -> r.getTargetID().equals(targetId) && r.getTargetUCD().equals(targetUCD)).collect(Collectors.toList())).size() > 0) {
                throw new WebApplicationException("Relationship " + relation + " -> " + targetUCD + " : " + targetId + " already set", Response.Status.EXPECTATION_FAILED);
            }
            ProfiledMongoManager otherManager = targetUCD.equals(this.useCaseDescriptor.getId()) ? this : new ProfiledMongoManager(targetUCD);
            Project other = this.getByID(targetId);
            Relationship rel = new Relationship();
            rel.setRelationshipName(relation);
            rel.setTargetID(targetId);
            rel.setTargetUCD(targetUCD);
            toUpdate = this.onUpdate(toUpdate.addRelation(rel));
            if (toSetReverseRelation != null) {
                Relationship reverseRel = new Relationship();
                reverseRel.setRelationshipName(toSetReverseRelation);
                reverseRel.setTargetID(id);
                reverseRel.setTargetUCD(this.getUseCaseDescriptor().getId());
                log.info("Setting reverse relation {} ", (Object)reverseRel);
                other = otherManager.lock(other.getId(), "Setting reverse relation " + reverseRel);
                other.addRelation(reverseRel);
                otherManager.unlockAndUpdate(other);
            }
            return this.unlockAndUpdate(toUpdate);
        }
        catch (Throwable t) {
            log.error("Unexpected exception ", t);
            this.unlock(toUpdate);
            throw t;
        }
    }

    public Project deleteRelation(String id, String relation, String targetUCD, String targetId) throws IOException, EventException, ProjectLockedException, ProjectNotFoundException, InvalidLockException, InvalidUserRoleException, UnauthorizedAccess, RegistrationException, ConfigurationException {
        log.info("Delete relation {}:{}--{}-->{}:{} ", new Object[]{this.getUseCaseDescriptor().getId(), id, relation, targetUCD, targetId});
        Project toUpdate = this.lock(id, "Delete Relation");
        try {
            String toUseTargetUCD = targetUCD == null || targetUCD.equals("") ? this.getUseCaseDescriptor().getId() : targetUCD;
            String toDeleteReverseRelation = null;
            List existingDefinitions = this.getUseCaseDescriptor().getRelationshipDefinitions();
            for (RelationshipDefinition def : existingDefinitions) {
                if (!def.getId().equals(relation)) continue;
                toDeleteReverseRelation = def.getReverseRelationId();
            }
            log.debug("{} reverse relation for {} is {}", new Object[]{this.getUseCaseDescriptor().getId(), relation, toDeleteReverseRelation});
            List relations = toUpdate.getRelationships();
            if (relations != null && !relations.isEmpty()) {
                int beforeSize = relations.size();
                ArrayList<Relationship> toRemove = new ArrayList<Relationship>();
                for (Relationship r : toUpdate.getRelationships()) {
                    if (!r.getRelationshipName().equals(relation) || !r.getTargetUCD().equals(toUseTargetUCD) || !r.getTargetID().equals(targetId)) continue;
                    log.debug("Removing {} ", (Object)r);
                    toRemove.add(r);
                    if (toDeleteReverseRelation == null) continue;
                    log.debug("Removing reverse of {} ", (Object)r);
                    ProfiledMongoManager otherManager = toUseTargetUCD.equals(this.useCaseDescriptor.getId()) ? this : new ProfiledMongoManager(targetUCD);
                    Project other = this.getByID(targetId);
                    other = otherManager.lock(other.getId(), "Remove reverse relation " + toDeleteReverseRelation + " toward " + this.getUseCaseDescriptor().getId() + ":" + id);
                    String finalToDeleteReverseRelation = toDeleteReverseRelation;
                    other.getRelationships().removeIf(revRel -> revRel.getRelationshipName().equals(finalToDeleteReverseRelation) && revRel.getTargetID().equals(id) && revRel.getTargetUCD().equals(this.getUseCaseDescriptor().getId()));
                    otherManager.unlockAndUpdate(other);
                }
                toUpdate.getRelationships().removeAll(toRemove);
                if (toUpdate.getRelationships().size() != beforeSize) {
                    log.debug("Removed {} relations from {} ", (Object)(toUpdate.getRelationships().size() != beforeSize ? 1 : 0), (Object)id);
                    return this.unlockAndUpdate(toUpdate);
                }
            }
            log.debug("Relationship not found. Unlocking.. ");
            return this.unlock(toUpdate);
        }
        catch (Throwable t) {
            log.error("Unexpected exception ", t);
            this.unlock(toUpdate);
            throw t;
        }
    }

    private Project onUpdate(Project toUpdate) throws EventException {
        UserUtils.AuthenticatedUser u = UserUtils.getCurrent();
        toUpdate.getInfo().setLastEditInfo(u.asInfo());
        toUpdate.setVersion(toUpdate.getVersion().withIncPatch());
        return this.triggerEvent(toUpdate, "INIT_DOCUMENT", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String id, boolean force) throws DeletionException, InvalidUserRoleException, ProjectLockedException, ProjectNotFoundException, UnauthorizedAccess, JsonProcessingException, InvalidLockException {
        block12: {
            log.info("Deleting by ID {}, force {}", (Object)id, (Object)force);
            Project doc = this.lock(id, "Deletion { force : " + force + "}");
            boolean deleted = false;
            try {
                User u = UserUtils.getCurrent().asInfo().getUser();
                DataAccessPolicy policy = this.useCaseDescriptor.getMatching(u);
                log.debug("Delete project {} [{}] , policy for {} is {} ", new Object[]{id, this.useCaseDescriptor.getId(), u, policy});
                if (policy == null) {
                    throw new InvalidUserRoleException("No policy defined for current user roles " + u.getRoles());
                }
                if (!policy.canWrite(doc, u)) {
                    throw new UnauthorizedAccess("No edit rights on project " + id);
                }
                if (!(doc = this.triggerEvent(doc, "DELETE_DOCUMENT", new Document("force", (Object)force))).getLifecycleInformation().getLastOperationStatus().equals((Object)LifecycleInformation.Status.OK)) break block12;
                try {
                    WorkspaceManager ws = new WorkspaceManager();
                    JSONPathWrapper wrapper = new JSONPathWrapper(this.useCaseDescriptor.getSchema().toJson());
                    for (Object obj : wrapper.getByPath("$..[?(@._payloads)]")) {
                        Document fs = Serialization.asDocument(obj);
                        log.debug("Deleting {}", obj);
                        String folderId = fs.getString((Object)"_folderID");
                        ws.deleteItem(folderId);
                    }
                }
                finally {
                    super.deleteDoc(ProfiledMongoManager.asId((String)id));
                    deleted = true;
                }
            }
            catch (ConfigurationException | StorageHubException e) {
                log.error("Exception while trying to delete {} [UCID {}]", (Object)id, (Object)this.useCaseDescriptor.getId());
                throw new DeletionException("Unable to contact Storage ", e);
            }
            finally {
                if (doc != null && !deleted) {
                    this.unlockAndUpdate(doc);
                }
            }
        }
    }

    public Project getByID(String id) throws ProjectNotFoundException, InvalidUserRoleException, UnauthorizedAccess {
        User u = UserUtils.getCurrent().asInfo().getUser();
        DataAccessPolicy policy = this.useCaseDescriptor.getMatching(u);
        log.info("Accessing Project {} [{}] , policy for {} is {} ", new Object[]{id, this.useCaseDescriptor.getId(), u, policy});
        if (policy == null) {
            log.warn("No policy found for {}. Returning empty ", (Object)u);
            throw new InvalidUserRoleException("No policy defined for current user roles " + u.getRoles());
        }
        Document doc = this.getDocById(ProfiledMongoManager.asId((String)id), policy == null || policy.getEnforcer() == null ? null : policy.getEnforcer().getFilterDocument());
        if (doc == null) {
            throw new ProjectNotFoundException("No document with ID " + id);
        }
        Project p = (Project)Serialization.convert((Object)doc, Project.class);
        if (!policy.canRead(p, u)) {
            throw new UnauthorizedAccess("No access rights on " + id);
        }
        return p;
    }

    public Iterable<Document> query(QueryRequest queryRequest) throws InvalidUserRoleException {
        LinkedBlockingQueue<Document> queue = new LinkedBlockingQueue<Document>();
        User u = UserUtils.getCurrent().asInfo().getUser();
        DataAccessPolicy policy = this.useCaseDescriptor.getMatching(u);
        log.info("Querying {} [{}] , policy for {} is {} ", new Object[]{queryRequest, this.useCaseDescriptor.getId(), u, policy});
        if (policy == null) {
            log.warn("No policy found for {}. Returning empty ", (Object)u);
            throw new InvalidUserRoleException("No policy defined for current user roles " + u.getRoles());
        }
        if (policy.getPolicy().getRead().equals((Object)DataAccessPolicy.Policy.Type.none)) {
            log.info("Read is NONE : Returning empty collection");
            return queue;
        }
        Document finalFilter = new Document();
        if (queryRequest.getFilter() != null) {
            finalFilter.putAll((Map)queryRequest.getFilter());
        }
        if (policy.getEnforcer() != null) {
            finalFilter.putAll((Map)policy.getEnforcer().getFilterDocument());
        }
        if (policy.getPolicy().getRead().equals((Object)DataAccessPolicy.Policy.Type.own)) {
            finalFilter.put("_info._creationInfo._user._username", (Object)u.getUsername());
        }
        queryRequest.setFilter(finalFilter);
        log.debug("Final filter is {}", (Object)queryRequest.getFilter());
        this.queryDoc(queryRequest).forEach(d -> {
            try {
                queue.put((Document)d);
            }
            catch (Throwable t) {
                log.warn("Unable to translate " + d);
            }
        });
        log.info("Returned {} elements ", (Object)queue.size());
        return queue;
    }

    public Iterable<Project> filter(QueryRequest queryRequest) throws InvalidUserRoleException {
        LinkedBlockingQueue<Project> queue = new LinkedBlockingQueue<Project>();
        User u = UserUtils.getCurrent().asInfo().getUser();
        DataAccessPolicy policy = this.useCaseDescriptor.getMatching(u);
        log.info("Querying {} [{}] , policy for {} is {} ", new Object[]{queryRequest, this.useCaseDescriptor.getId(), u, policy});
        if (policy == null) {
            log.warn("No policy found for {}. Returning empty ", (Object)u);
            throw new InvalidUserRoleException("No policy defined for current user roles " + u.getRoles());
        }
        if (policy.getPolicy().getRead().equals((Object)DataAccessPolicy.Policy.Type.none)) {
            log.info("Read is NONE : Returning empty collection");
            return queue;
        }
        Document finalFilter = new Document();
        if (queryRequest.getFilter() != null) {
            finalFilter.putAll((Map)queryRequest.getFilter());
        }
        if (policy.getEnforcer() != null) {
            finalFilter.putAll((Map)policy.getEnforcer().getFilterDocument());
        }
        if (policy.getPolicy().getRead().equals((Object)DataAccessPolicy.Policy.Type.own)) {
            finalFilter.put("_info._creationInfo._user._username", (Object)u.getUsername());
        }
        queryRequest.setFilter(finalFilter);
        log.debug("Final filter is {}", (Object)queryRequest.getFilter());
        this.queryDoc(queryRequest).forEach(d -> {
            try {
                queue.put((Project)d);
            }
            catch (Throwable t) {
                log.warn("Unable to translate " + d);
            }
        });
        log.info("Returned {} elements ", (Object)queue.size());
        return queue;
    }

    public Project performStep(String id, String step, Document options) throws StepException, JsonProcessingException, ProjectLockedException, ProjectNotFoundException, InvalidLockException, InvalidUserRoleException, UnauthorizedAccess, ConfigurationException, InsufficientPrivileges {
        Project document = this.lock(id, "Step " + step + " execution");
        try {
            User u = UserUtils.getCurrent().asInfo().getUser();
            DataAccessPolicy policy = this.useCaseDescriptor.getMatching(u);
            log.info("Registering Fileset for {} [{}] , policy for {} is {} ", new Object[]{id, this.useCaseDescriptor.getId(), u, policy});
            if (policy == null) {
                log.warn("No policy found for {}. Returning empty ", (Object)u);
                throw new InvalidUserRoleException("No policy defined for current user roles " + u.getRoles());
            }
            if (!policy.canWrite(document, u)) {
                throw new UnauthorizedAccess("No edit rights on project " + id);
            }
            document.getLifecycleInformation().cleanState();
            document = this.step(document, step, options);
            return this.unlockAndUpdate(document);
        }
        catch (InsufficientPrivileges | UnrecognizedStepException | ConfigurationException e) {
            log.debug("Unable to perform step ", e);
            this.unlock(document);
            throw e;
        }
        catch (Throwable t) {
            log.error("[UseCaseDescriptor {}\u00a0] ERROR Invoking Step {} on document {}", new Object[]{this.useCaseDescriptor.getId(), step, id, t});
            LifecycleInformation info = new LifecycleInformation();
            info.setPhase(document.getLifecycleInformation().getPhase());
            info.setLastOperationStatus(LifecycleInformation.Status.ERROR);
            info.addErrorMessage(t.getMessage());
            info.setLastInvokedStep(step);
            document.setLifecycleInformation(info);
            return this.unlockAndUpdate(document);
        }
    }

    public Project registerFileSet(String id, RegisterFileSetRequest request) throws ConfigurationException, StorageHubException, StorageException, JsonProcessingException, EventException, ProjectLockedException, ProjectNotFoundException, InvalidLockException, InvalidUserRoleException, UnauthorizedAccess {
        log.info("Registering Fileset for {} [useCaseDescriptor ID {}], Request is {} ", new Object[]{id, this.useCaseDescriptor.getId(), request});
        List files = request.getStreams();
        Document attributes = request.getAttributes();
        Project doc = this.lock(id, "Register Fileset");
        try {
            User u = UserUtils.getCurrent().asInfo().getUser();
            DataAccessPolicy policy = this.useCaseDescriptor.getMatching(u);
            log.info("Registering Fileset for {} [{}] , policy for {} is {} ", new Object[]{id, this.useCaseDescriptor.getId(), u, policy});
            if (policy == null) {
                log.warn("No policy found for {}. Returning empty ", (Object)u);
                throw new InvalidUserRoleException("No policy defined for current user roles " + u.getRoles());
            }
            if (!policy.canWrite(doc, u)) {
                throw new UnauthorizedAccess("No edit rights on project " + id);
            }
            doc.getLifecycleInformation().cleanState();
            doc.getLifecycleInformation().setLastOperationStatus(LifecycleInformation.Status.OK);
            WorkspaceManager ws = new WorkspaceManager();
            StorageUtils storage = (StorageUtils)ImplementationProvider.get().getProvidedObjectByClass(StorageUtils.class);
            log.debug("Checking field {} definition in {}", (Object)request.getFieldDefinitionPath(), (Object)this.useCaseDescriptor.getId());
            Field fieldDefinition = ProfiledMongoManager.getFieldDefinition((UseCaseDescriptor)this.useCaseDescriptor, (String)request.getFieldDefinitionPath());
            JSONPathWrapper docWrapper = new JSONPathWrapper(doc.getTheDocument().toJson());
            List matchingPaths = docWrapper.getMatchingPaths(request.getParentPath());
            if (matchingPaths.size() > 1) {
                throw new WebApplicationException("Multiple Destination matching parent path " + request.getParentPath(), Response.Status.BAD_REQUEST);
            }
            if (matchingPaths.isEmpty()) {
                throw new WebApplicationException("PArent path not found at " + request.getParentPath(), Response.Status.BAD_REQUEST);
            }
            String parentMatchingPath = (String)matchingPaths.get(0);
            List foundElementsByMatchingPaths = docWrapper.getByPath(parentMatchingPath);
            if (foundElementsByMatchingPaths == null || foundElementsByMatchingPaths.isEmpty()) {
                throw new WebApplicationException("No element found at " + parentMatchingPath, Response.Status.BAD_REQUEST);
            }
            Document parent = Serialization.asDocument(foundElementsByMatchingPaths.get(0));
            Access toSetAccess = new Access(doc.getInfo().getAccess().getPolicy(), doc.getInfo().getAccess().getLicense());
            if (request.getToSetAccess() != null) {
                AccessPolicy requestedPolicy;
                String requestedLicense = request.getToSetAccess().getLicense();
                if (requestedLicense != null) {
                    toSetAccess.setLicense(requestedLicense);
                }
                if ((requestedPolicy = request.getToSetAccess().getPolicy()) != null) {
                    toSetAccess.setPolicy(requestedPolicy);
                }
            }
            switch (1.$SwitchMap$org$gcube$application$geoportal$common$model$rest$RegisterFileSetRequest$ClashOptions[request.getClashOption().ordinal()]) {
                case 1: {
                    if (fieldDefinition.isCollection().booleanValue()) {
                        throw new WebApplicationException("Cannot replace repeatable field " + request.getFieldDefinitionPath() + ".", Response.Status.BAD_REQUEST);
                    }
                    RegisteredFileSet toDelete = (RegisteredFileSet)Serialization.convert((Object)parent.get((Object)request.getFieldName()), RegisteredFileSet.class);
                    if (toDelete != null && !toDelete.isEmpty()) {
                        String path = parentMatchingPath + "." + request.getFieldName();
                        this.deleteFileSetRoutine(doc, Boolean.valueOf(false), Boolean.valueOf(false), path);
                    }
                    RegisteredFileSet fs = ProfiledMongoManager.prepareRegisteredFileSet((Access)toSetAccess, (String)doc.getId(), (String)this.useCaseDescriptor.getId(), (Document)request.getAttributes(), (List)files, (StorageUtils)storage, (WorkspaceManager)ws);
                    log.debug("Registered Fileset for [ID {} useCaseDescriptor {}] is {} ", new Object[]{fs, doc.getId(), doc.getProfileID()});
                    docWrapper.putElement(parentMatchingPath, request.getFieldName(), (Object)fs);
                    break;
                }
                case 2: {
                    if (fieldDefinition.isCollection().booleanValue()) {
                        throw new WebApplicationException("Cannot merge repeatable field " + request.getFieldDefinitionPath() + ".", Response.Status.BAD_REQUEST);
                    }
                    RegisteredFileSet original = (RegisteredFileSet)Serialization.convert((Object)parent.get((Object)request.getFieldName()), RegisteredFileSet.class);
                    Document toUseAttributes = request.getAttributes();
                    if (original != null) {
                        toUseAttributes.putAll((Map)original);
                    }
                    RegisteredFileSet fs = ProfiledMongoManager.prepareRegisteredFileSet((Access)toSetAccess, (String)doc.getId(), (String)this.useCaseDescriptor.getId(), (Document)toUseAttributes, (List)files, (StorageUtils)storage, (WorkspaceManager)ws);
                    log.debug("Registered Fileset for [ID {} useCaseDescriptor {}] is {} ", new Object[]{fs, doc.getId(), doc.getProfileID()});
                    docWrapper.putElement(parentMatchingPath, request.getFieldName(), (Object)fs);
                    break;
                }
                case 3: {
                    if (!fieldDefinition.isCollection().booleanValue()) {
                        throw new WebApplicationException("Cannot add to single field " + request.getFieldDefinitionPath() + ".", Response.Status.BAD_REQUEST);
                    }
                    RegisteredFileSet fs = ProfiledMongoManager.prepareRegisteredFileSet((Access)toSetAccess, (String)doc.getId(), (String)this.useCaseDescriptor.getId(), (Document)request.getAttributes(), (List)files, (StorageUtils)storage, (WorkspaceManager)ws);
                    log.debug("Registered Fileset for [ID {} useCaseDescriptor {}] is {} ", new Object[]{fs, doc.getId(), doc.getProfileID()});
                    docWrapper.addElementToArray(String.format("%1ds['%2$s']", parentMatchingPath, request.getFieldName()), (Object)fs);
                    break;
                }
                default: {
                    throw new WebApplicationException("Unexpected clash policy " + request.getClashOption(), Response.Status.BAD_REQUEST);
                }
            }
            log.debug("Setting result on profiled document");
            doc.setTheDocument(Document.parse((String)docWrapper.getValueCTX().jsonString()));
            doc = this.onUpdate(doc);
            return this.unlockAndUpdate(doc);
        }
        catch (Throwable t) {
            log.warn("Unexpected Exception while trying to registering fileset on {}.", (Object)id, (Object)t);
            log.debug("Request was {}", (Object)request);
            log.debug("Complete doc was {} ", (Object)doc);
            this.unlock(doc);
            throw t;
        }
    }

    public Project deleteFileSet(String id, String path, Boolean force, Boolean ignore_errors) throws ConfigurationException, StorageHubException, JsonProcessingException, DeletionException, EventException, ProjectLockedException, ProjectNotFoundException, InvalidLockException, InvalidUserRoleException, UnauthorizedAccess {
        log.info("Deleting Fileset for P_ID {} [UCD_ID {}], at {} [force {} and  ignore_errors {}]", new Object[]{id, this.useCaseDescriptor.getId(), path, force, ignore_errors});
        Project doc = this.lock(id, "Fileset Deletion");
        try {
            User u = UserUtils.getCurrent().asInfo().getUser();
            DataAccessPolicy policy = this.useCaseDescriptor.getMatching(u);
            log.debug("Deleting Fileset for {} [{}] , policy for {} is {} ", new Object[]{doc.getId(), this.useCaseDescriptor.getId(), u, policy});
            if (policy == null) {
                log.warn("No policy found for {}. Returning empty ", (Object)u);
                throw new InvalidUserRoleException("No policy defined for current user roles " + u.getRoles());
            }
            if (!policy.canWrite(doc, u)) {
                throw new UnauthorizedAccess("No edit rights on project " + doc.getId());
            }
            doc.getLifecycleInformation().cleanState();
            doc.getLifecycleInformation().cleanState().setLastOperationStatus(LifecycleInformation.Status.OK);
            if (ignore_errors == null) {
                ignore_errors = false;
            }
            doc = this.deleteFileSetRoutine(doc, force, ignore_errors, path);
            return this.unlockAndUpdate(doc);
        }
        catch (Throwable t) {
            log.warn("Unexpected Exception while trying to delete fileset on {}.", (Object)id, (Object)t);
            this.unlock(doc);
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project forceUnlock(String id) throws InvalidUserRoleException, ProjectNotFoundException, UnauthorizedAccess, JsonProcessingException, InvalidLockException {
        Project toUnlock = null;
        try {
            try {
                toUnlock = this.lock(id, "Check locked for force unlock");
                throw new WebApplicationException("Project " + id + " not locked", Response.Status.EXPECTATION_FAILED);
            }
            catch (ProjectLockedException e) {
                toUnlock = this.getByID(id);
                return toUnlock;
            }
        }
        finally {
            if (toUnlock != null) {
                return this.unlock(toUnlock);
            }
            throw new WebApplicationException("Unable to get Project " + id, Response.Status.EXPECTATION_FAILED);
        }
    }

    public Project setAccessPolicy(String id, Access access) throws InvalidUserRoleException, ProjectLockedException, ProjectNotFoundException, UnauthorizedAccess, JsonProcessingException, InvalidLockException, EventException {
        log.trace("UCD {}, Project {} : Setting Access {}", new Object[]{this.useCaseDescriptor.getId(), id, access});
        Project toUpdate = this.lock(id, "Set Access policy");
        try {
            User u = UserUtils.getCurrent().asInfo().getUser();
            DataAccessPolicy policy = this.useCaseDescriptor.getMatching(u);
            if (policy == null) {
                log.warn("No policy found for {}. Returning empty ", (Object)u);
                throw new InvalidUserRoleException("No policy defined for current user roles " + u.getRoles());
            }
            if (!policy.canWrite(toUpdate, u)) {
                throw new UnauthorizedAccess("No edit rights on project " + id);
            }
            toUpdate.getInfo().setAccess(access);
            toUpdate.getLifecycleInformation().cleanState();
            toUpdate = this.onUpdate(toUpdate);
            return this.unlockAndUpdate(toUpdate);
        }
        catch (Throwable t) {
            log.error("Unexpected exception ", t);
            this.unlock(toUpdate);
            throw t;
        }
    }

    private Project deleteFileSetRoutine(Project doc, Boolean force, Boolean ignore_errors, String path) throws ConfigurationException, StorageHubException {
        log.info("Delete[force : {}, ignore_errors: {}] FS at {} for {}:{}", new Object[]{force, ignore_errors, path, doc.getProfileID(), doc.getId()});
        JSONPathWrapper wrapper = new JSONPathWrapper(doc.getTheDocument().toJson());
        List matchingPaths = wrapper.getMatchingPaths(path);
        log.info("matchingPaths is: " + matchingPaths);
        String error = null;
        if (matchingPaths.isEmpty()) {
            error = "No Registered FileSet found at " + path;
            if (!ignore_errors.booleanValue()) {
                throw new WebApplicationException(error, Response.Status.BAD_REQUEST);
            }
        }
        if (matchingPaths.size() > 1 && !ignore_errors.booleanValue()) {
            error = "Multiple Fileset (" + matchingPaths.size() + ") matching " + path;
            if (!ignore_errors.booleanValue()) {
                throw new WebApplicationException(error, Response.Status.BAD_REQUEST);
            }
        }
        if (error != null && ignore_errors.booleanValue()) {
            log.info("Error detected {}. Ignoring it and returning input doc", (Object)error);
            return doc;
        }
        RegisteredFileSet fs = null;
        error = null;
        Throwable filesetExc = null;
        try {
            List deleteList = wrapper.getByPath(path);
            if (deleteList == null || deleteList.isEmpty()) {
                error = "List of object going to delete is null or empty";
                log.warn(error);
                filesetExc = new WebApplicationException(error, Response.Status.BAD_REQUEST);
            }
            if (error == null) {
                Object toFileSet = deleteList.get(0);
                fs = (RegisteredFileSet)Serialization.convert(toFileSet, RegisteredFileSet.class);
                log.info("Going to delete {}", (Object)fs);
            }
        }
        catch (Exception e) {
            error = "Error on getting the RegisteredFileSet for path: " + path;
            log.warn(error);
            filesetExc = e;
            log.debug("Error is: ", (Throwable)e);
        }
        if (error != null) {
            if (ignore_errors.booleanValue()) {
                log.info("ignore_errors is {}, returning input doc {}", (Object)ignore_errors, (Object)doc.getId());
                return doc;
            }
            log.info("Thrown " + WebApplicationException.class.getSimpleName() + " with message {}", (Object)filesetExc.getMessage());
            throw new WebApplicationException(error, Response.Status.BAD_REQUEST);
        }
        doc = this.triggerEvent(doc, "DELETE_FILESET", new Document("force", (Object)force).append("path", (Object)path).append("fileSetPath", (Object)path));
        wrapper = new JSONPathWrapper(doc.getTheDocument().toJson());
        if (doc.getLifecycleInformation().getLastOperationStatus().equals((Object)LifecycleInformation.Status.OK)) {
            if (fs.getFolderId() != null) {
                try {
                    log.info("Deleting Fileset Folder ID {} ", (Object)fs.getFolderId());
                    new WorkspaceManager().deleteItem(fs.getFolderId());
                }
                catch (Exception e) {
                    LifecycleInformation info = doc.getLifecycleInformation();
                    if (info == null) {
                        info = new LifecycleInformation();
                    }
                    info.addErrorMessage("Unable to delete the Folder ID " + fs.getFolderId() + " in the VRE Folder");
                    info.setLastOperationStatus(LifecycleInformation.Status.WARNING);
                    log.warn("Error on deleting the Folder ID {} in the VRE Folder", (Object)fs.getFolderId(), (Object)e);
                }
            }
            log.debug("Removing FS from document [ID : ] by path {}", (Object)doc.getId(), (Object)path);
            wrapper.setElement(path, null);
        }
        log.debug("Setting result on profiled document");
        doc.setTheDocument(Document.parse((String)wrapper.getValueCTX().jsonString()));
        return doc;
    }

    public Configuration getConfiguration() throws ConfigurationException {
        String context = UserUtils.getCurrent().getContext();
        log.debug("Asking configuration for {} in {} ", (Object)this.useCaseDescriptor.getId(), (Object)context);
        Configuration toReturn = new Configuration();
        ArrayList<Archive> archives = new ArrayList<Archive>();
        toReturn.setArchives(archives);
        ArrayList indexes = new ArrayList();
        toReturn.setIndexes(indexes);
        toReturn.setProfileId(this.getUseCaseDescriptor().getId());
        toReturn.setContext(context);
        toReturn.setLastUpdatedTime(LocalDateTime.now());
        Archive mongoArchive = new Archive("DOCUMENT-STORE-COLLECTION");
        MongoCollection coll = this.getCollection();
        mongoArchive.put("count", (Object)coll.count());
        mongoArchive.put("collection_name", (Object)this.getToUseCollectionName());
        try {
            ArrayList counts = new ArrayList();
            coll.aggregate(Collections.singletonList(Document.parse((String)"{\"$group\" : {\"_id\":{\"phase\":\"$_lifecycleInformation._phase\",\"status\":\"$_lifecycleInformation._lastOperationStatus\"}, \"count\":{\"$sum\":1}}}"))).forEach(doc -> {
                try {
                    counts.add(Serialization.asDocument((Object)doc));
                }
                catch (JsonProcessingException e) {
                    log.warn("Unable to write aggregated results ", (Throwable)e);
                }
            });
            mongoArchive.put("countByPhase", counts);
        }
        catch (Throwable t) {
            toReturn.addErrorMessage("Unable to get PHASE statistics " + t.getMessage());
            log.error("Unable to get PHASE statistics", t);
        }
        archives.add(mongoArchive);
        try {
            archives.add(new WorkspaceManager().getConfiguration());
        }
        catch (Exception e) {
            toReturn.addErrorMessage("Unable to get WS info " + e.getMessage());
            log.error("Unable to get WS Configuration", (Throwable)e);
        }
        AccountingInfo user = UserUtils.getCurrent().asInfo();
        try {
            Configuration lcConfig = this.getLCManager().getCurrentConfiguration(new BaseRequest(this.useCaseDescriptor, user.getUser(), user.getContext()));
            log.info("Configuration is {} ", (Object)lcConfig);
            if (lcConfig.getArchives() != null) {
                archives.addAll(lcConfig.getArchives());
            }
            if (lcConfig.getIndexes() != null) {
                indexes.addAll(lcConfig.getIndexes());
            }
        }
        catch (Throwable e) {
            toReturn.addErrorMessage("Unable to get Lifecycle info " + e.getMessage());
            log.error("Unable to get Lifecycle info ", e);
        }
        log.debug("Returning current configuration {}", (Object)toReturn);
        return toReturn;
    }

    private Project step(Project theDocument, String step, Document callParameters) throws InsufficientPrivileges, ConfigurationException, StepException {
        try {
            EventExecutionRequest triggerRequest;
            log.info("[UseCaseDescriptor {}] Invoking Step {} on {}", new Object[]{this.useCaseDescriptor.getId(), step, this.getManager().getDescriptor()});
            AccountingInfo user = UserUtils.getCurrent().asInfo();
            StepExecutionRequest request = new StepExecutionRequest(this.useCaseDescriptor, user.getUser(), user.getContext(), theDocument, step);
            request.setCallParameters(callParameters);
            log.debug("Requesting Step Execution {}", (Object)request);
            StepExecutionReport report = this.getManager().performStep(request);
            Project toReturn = report.prepareResult();
            if (report.getToTriggerEvents() != null) {
                ListIterator eventIT = report.getToTriggerEvents().listIterator();
                while (!toReturn.getLifecycleInformation().getLastOperationStatus().equals((Object)LifecycleInformation.Status.ERROR) && eventIT.hasNext()) {
                    triggerRequest = (EventExecutionRequest)eventIT.next();
                    log.info("Triggering {} ", (Object)triggerRequest);
                    toReturn = this.triggerEvent(toReturn, triggerRequest.getEvent(), triggerRequest.getCallParameters());
                }
            }
            if (report.getCascadeSteps() != null) {
                ListIterator stepIT = report.getCascadeSteps().listIterator();
                while (!toReturn.getLifecycleInformation().getLastOperationStatus().equals((Object)LifecycleInformation.Status.ERROR) && stepIT.hasNext()) {
                    triggerRequest = (StepExecutionRequest)stepIT.next();
                    log.info("Triggering {} ", (Object)triggerRequest);
                    toReturn = this.step(toReturn, triggerRequest.getStep(), triggerRequest.getCallParameters());
                }
            }
            return report.prepareResult();
        }
        catch (InsufficientPrivileges | UnrecognizedStepException | ConfigurationException e) {
            throw e;
        }
        catch (Throwable t) {
            log.error("Unable to perform step " + step, t);
            theDocument.getLifecycleInformation().addErrorMessage("Unable to perform step " + step + " cause : " + t.getMessage());
            theDocument.getLifecycleInformation().setLastOperationStatus(LifecycleInformation.Status.ERROR);
            return theDocument;
        }
    }

    private Project triggerEvent(Project project, String event, Document parameters) {
        try {
            log.info("[UseCaseDescriptor {}] triggering event {} on {}", new Object[]{this.useCaseDescriptor.getId(), event, this.getManager().getDescriptor()});
            AccountingInfo user = UserUtils.getCurrent().asInfo();
            EventExecutionRequest request = new EventExecutionRequest(this.useCaseDescriptor, user.getUser(), user.getContext(), project, event);
            request.setCallParameters(parameters);
            log.debug("Triggering {}", (Object)request);
            EventExecutionReport report = this.getManager().onEvent(request);
            return report.prepareResult();
        }
        catch (Throwable t) {
            log.error("Unable to trigger event " + event, t);
            project.getLifecycleInformation().addErrorMessage("Unable to trigger " + event + " cause : " + t.getMessage());
            project.getLifecycleInformation().setLastOperationStatus(LifecycleInformation.Status.ERROR);
            return project;
        }
    }

    private static final RegisteredFileSet prepareRegisteredFileSet(Access toSetAccess, String docID, String profileID, Document attributes, List<TempFile> files, StorageUtils storage, WorkspaceManager ws) throws StorageHubException, StorageException {
        log.info("Preparing Registered FileSet {}");
        RegisteredFileSet toReturn = new RegisteredFileSet();
        if (attributes != null) {
            toReturn.putAll((Map)attributes);
        }
        String uuid = UUID.randomUUID().toString();
        toReturn.putIfAbsent((Object)"_uuid", (Object)uuid);
        toReturn.putIfAbsent((Object)"_creationInfo", (Object)UserUtils.getCurrent().asInfo());
        toReturn.putIfAbsent((Object)"_access", (Object)toSetAccess);
        String folderID = toReturn.getFolderId();
        log.trace("Folder ID is {} ", (Object)folderID);
        FolderContainer sectionFolder = null;
        if (folderID == null || folderID.isEmpty()) {
            FolderContainer base = ws.getSubFolder(ws.getAppBase(), docID, "Base Folder for profiled document. UseCaseDescriptor " + profileID);
            sectionFolder = ws.createFolder(new WorkspaceManager.FolderOptions(docID + "_" + uuid, "Registered Fileset uuid " + uuid, base));
            toReturn.put("_folderID", (Object)sectionFolder.getId());
        } else {
            sectionFolder = ws.getFolderById(folderID);
        }
        ArrayList<RegisteredFile> registeredFiles = new ArrayList<RegisteredFile>();
        if (toReturn.containsKey((Object)"_payloads")) {
            registeredFiles.addAll(toReturn.getPayloads());
        }
        for (TempFile f : files) {
            InputStream is = null;
            try {
                log.debug("Opening temp file {}", (Object)f);
                String fileUrl = null;
                fileUrl = f.getId() == null || f.getId().isEmpty() ? f.getUrl() : storage.getURL(f.getId());
                log.info("Got URL {} from ID {}", (Object)fileUrl, (Object)f.getId());
                is = new URL(fileUrl).openStream();
                RegisteredFile registered = ws.registerFile(new WorkspaceManager.FileOptions(f.getFilename(), is, "Imported via gcube CMS service ", sectionFolder));
                log.info("Registered " + registered);
                registeredFiles.add(registered);
                if (is == null) continue;
            }
            catch (IOException | StorageHubException e) {
                try {
                    throw new StorageException("Unable to store " + f, e);
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        IOUtils.closeQuietly(is);
                    }
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        toReturn.put("_payloads", registeredFiles);
        return toReturn;
    }

    private static Field getFieldDefinition(UseCaseDescriptor useCaseDescriptor, String fieldPath) throws WebApplicationException {
        JSONPathWrapper schemaWrapper = new JSONPathWrapper(useCaseDescriptor.getSchema().toJson());
        List fieldDefinitions = schemaWrapper.getByPath(fieldPath, Field.class);
        if (fieldDefinitions == null || fieldDefinitions.isEmpty()) {
            throw new WebApplicationException("No Field found in schema " + useCaseDescriptor.getId() + " at " + fieldPath, Response.Status.BAD_REQUEST);
        }
        if (fieldDefinitions.size() > 1) {
            throw new WebApplicationException("Multiple field definitions (" + fieldDefinitions.size() + ") found in " + useCaseDescriptor.getId() + " for " + fieldPath, Response.Status.BAD_REQUEST);
        }
        Field fieldDefinition = (Field)Serialization.convert(fieldDefinitions.get(0), Field.class);
        if (fieldDefinition == null) {
            throw new WebApplicationException("Found field is null [" + useCaseDescriptor.getId() + " for " + fieldPath + "]", Response.Status.BAD_REQUEST);
        }
        log.trace("Field definition is {}", (Object)fieldDefinition);
        return fieldDefinition;
    }

    public UseCaseDescriptor getUseCaseDescriptor() {
        return this.useCaseDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LifecycleManager getManager() {
        Object value = this.manager.get();
        if (value == null) {
            AtomicReference atomicReference = this.manager;
            synchronized (atomicReference) {
                value = this.manager.get();
                if (value == null) {
                    LifecycleManager actualValue = this.getLCManager();
                    value = actualValue == null ? this.manager : actualValue;
                    this.manager.set(value);
                }
            }
        }
        return value == this.manager ? null : value;
    }
}

