/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.service.model.internal.db;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import org.gcube.application.geoportal.service.model.internal.db.MongoConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mongo {
    private static final Logger log = LoggerFactory.getLogger(Mongo.class);
    private MongoClient theClient = null;
    private MongoConnection connection = null;

    public Mongo(MongoConnection conn) {
        this.connection = conn;
        MongoCredential credential = MongoCredential.createCredential((String)conn.getUser(), (String)conn.getDatabase(), (char[])conn.getPassword().toCharArray());
        MongoClientOptions options = MongoClientOptions.builder().threadsAllowedToBlockForConnectionMultiplier(10).connectionsPerHost(20).maxConnectionIdleTime(10000).applicationName("geoportal-service").sslEnabled(true).connectTimeout(30000).build();
        this.theClient = new MongoClient(new ServerAddress((String)conn.getHosts().get(0), conn.getPort()), credential, options);
    }

    public void close() {
        this.theClient.close();
    }

    public String toString() {
        return "Mongo(theClient=" + this.getTheClient() + ", connection=" + this.getConnection() + ")";
    }

    public MongoClient getTheClient() {
        return this.theClient;
    }

    public MongoConnection getConnection() {
        return this.connection;
    }
}

