/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.service.engine.mongo;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.mongodb.client.MongoDatabase;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.gcube.application.cms.plugins.LifecycleManager;
import org.gcube.application.cms.plugins.faults.StepException;
import org.gcube.application.cms.plugins.reports.ExecutionReport;
import org.gcube.application.cms.plugins.requests.StepExecutionRequest;
import org.gcube.application.geoportal.common.model.document.Access;
import org.gcube.application.geoportal.common.model.document.AccessPolicy;
import org.gcube.application.geoportal.common.model.document.ComparableVersion;
import org.gcube.application.geoportal.common.model.document.ProfiledDocument;
import org.gcube.application.geoportal.common.model.document.PublicationInfo;
import org.gcube.application.geoportal.common.model.profile.HandlerDeclaration;
import org.gcube.application.geoportal.common.model.profile.Profile;
import org.gcube.application.geoportal.common.model.rest.QueryRequest;
import org.gcube.application.geoportal.service.engine.ImplementationProvider;
import org.gcube.application.geoportal.service.engine.mongo.MongoManager;
import org.gcube.application.geoportal.service.engine.mongo.MongoManagerI;
import org.gcube.application.geoportal.service.model.internal.faults.ConfigurationException;
import org.gcube.application.geoportal.service.model.internal.faults.DeletionException;
import org.gcube.application.geoportal.service.utils.Serialization;
import org.gcube.application.geoportal.service.utils.UserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ProfiledMongoManager
extends MongoManager
implements MongoManagerI<ProfiledDocument> {
    private static final Logger log = LoggerFactory.getLogger(ProfiledMongoManager.class);
    Profile profile;
    MongoDatabase db = null;
    LifecycleManager lfManager;

    public ProfiledMongoManager(String profileId) throws ConfigurationException {
        log.info("Loading profile ID {} ", (Object)profileId);
        if (profileId == null) {
            throw new InvalidParameterException("Profile ID cannot be null");
        }
        Map profiles = (Map)ImplementationProvider.get().getProfiles().getObject();
        if (!profiles.containsKey(profileId)) {
            log.debug("Asked profile {} not found. Available ones are {}\u00a0", (Object)profileId, profiles.keySet());
            throw new WebApplicationException("Profile " + profileId + " not registered", Response.Status.NOT_FOUND);
        }
        this.profile = (Profile)profiles.get(profileId);
        log.debug("Loaded Profile {}\u00a0", (Object)this.profile);
        List handlerDeclarations = (List)this.profile.getHandlersMap().get("LifecycleManagement");
        if (handlerDeclarations == null || handlerDeclarations.isEmpty()) {
            throw new ConfigurationException("No Lifecycle Handler defined for profile ID " + profileId);
        }
        if (handlerDeclarations.size() > 1) {
            throw new ConfigurationException("Too many Lifecycle Handlers defined (" + handlerDeclarations + ") in profile ID " + profileId);
        }
        HandlerDeclaration lcHandlerDeclaration = (HandlerDeclaration)handlerDeclarations.get(0);
        log.debug("Looking for handler {} ", (Object)lcHandlerDeclaration);
        try {
            this.lfManager = (LifecycleManager)((Map)ImplementationProvider.get().getPluginManager().getObject()).get(lcHandlerDeclaration.getId());
            if (this.lfManager == null) {
                throw new ConfigurationException("Unable to find Lifecycle Manager Plugin. ID " + lcHandlerDeclaration.getId());
            }
        }
        catch (ClassCastException e) {
            throw new ConfigurationException("Unable to use " + lcHandlerDeclaration.getId() + " as Lifecycle Manager");
        }
        String toUseDB = this.client.getConnection().getDatabase();
        log.info("Connecting to DB {} ", (Object)toUseDB);
        this.db = this.client.getTheClient().getDatabase(toUseDB);
    }

    private ProfiledDocument onUpdate(ProfiledDocument updatedDocument) throws StepException {
        UserUtils.AuthenticatedUser u = UserUtils.getCurrent();
        updatedDocument.getInfo().setLastEditInfo(u.asInfo());
        return this.step(updatedDocument, "@@@UPDATE_DOCUMENT@@").getResult();
    }

    private Document asDocument(ProfiledDocument d) throws JsonProcessingException {
        return Document.parse((String)Serialization.write((Object)d));
    }

    private ProfiledDocument asProfiledDocument(Document d) throws IOException {
        return (ProfiledDocument)Serialization.read((String)d.toJson(), ProfiledDocument.class);
    }

    private String getCollectionName() {
        return this.profile.getId();
    }

    public MongoDatabase getDatabase() {
        return this.db;
    }

    public ProfiledDocument registerNew(Document toRegisterDoc) throws IOException, StepException {
        log.info("Registering new document in {} ", (Object)this.profile.getId());
        log.debug("Going to register {}", (Object)toRegisterDoc.toJson());
        ProfiledDocument toRegister = new ProfiledDocument();
        toRegister.setTheDocument(toRegisterDoc);
        PublicationInfo pubInfo = new PublicationInfo();
        pubInfo.setCreationInfo(UserUtils.getCurrent().asInfo());
        Access access = new Access();
        access.setLicense("");
        access.setPolicy(AccessPolicy.OPEN);
        pubInfo.setAccess(access);
        toRegister.setInfo(pubInfo);
        toRegister.setProfileID(this.profile.getId());
        toRegister.setProfileVersion(this.profile.getVersion());
        toRegister.setVersion(new ComparableVersion("1.0.0"));
        toRegister = this.step(toRegister, "@@@INIT_DOCUMENT@@").getResult();
        log.debug("Going to register {}\u00a0", (Object)toRegister);
        ObjectId id = this.insert(this.asDocument(toRegister), this.getCollectionName());
        log.info("Obtained id {}\u00a0", (Object)id);
        return this.getByID(id.toHexString());
    }

    public ProfiledDocument update(String id, ProfiledDocument toSet) throws IOException, StepException {
        log.trace("Replacing {}\u00a0", (Object)toSet);
        toSet = this.onUpdate(toSet);
        return this.asProfiledDocument(this.replace(this.asDocument(toSet), this.getCollectionName()));
    }

    public void delete(String id, boolean force) throws DeletionException {
        log.debug("Deleting by ID {}, force {}", (Object)id, (Object)force);
        try {
            ProfiledDocument doc = this.getByID(id);
            throw new DeletionException("IMPLEMENT THIS");
        }
        catch (Throwable t) {
            throw new DeletionException("Unable to delete " + id, t);
        }
    }

    public ProfiledDocument getByID(String id) throws IOException {
        return this.asProfiledDocument(super.getById(ProfiledMongoManager.asId((String)id), this.getCollectionName()));
    }

    public Iterable<Document> query(QueryRequest queryRequest) {
        log.info("Querying {} ", (Object)queryRequest);
        LinkedBlockingQueue<Document> queue = new LinkedBlockingQueue<Document>();
        this.query(queryRequest, this.getCollectionName()).forEach(d -> {
            try {
                queue.put((Document)d);
            }
            catch (Throwable t) {
                log.warn("Unable to translate " + d);
            }
        });
        log.info("Returned {} elements ", (Object)queue.size());
        return queue;
    }

    public Iterable<ProfiledDocument> filter(QueryRequest queryRequest) {
        log.info("Searching concessione for filter {} ", (Object)queryRequest);
        LinkedBlockingQueue<ProfiledDocument> queue = new LinkedBlockingQueue<ProfiledDocument>();
        this.query(queryRequest, this.getCollectionName()).forEach(d -> {
            try {
                queue.put((ProfiledDocument)d);
            }
            catch (Throwable t) {
                log.warn("Unable to translate " + d);
            }
        });
        log.info("Returned {} elements ", (Object)queue.size());
        return queue;
    }

    public ProfiledDocument materialize(String id) {
        throw new RuntimeException("TO IMPLEMENT");
    }

    public ProfiledDocument dematerialize(String id) {
        throw new RuntimeException("TO IMPLEMENT");
    }

    public ProfiledDocument index(String id) {
        throw new RuntimeException("TO IMPLEMENT");
    }

    public ProfiledDocument deIndex(String id) {
        throw new RuntimeException("TO IMPLEMENT");
    }

    public ProfiledDocument performStep(String id, String step, Document options) {
        throw new RuntimeException("TO IMPLEMENT");
    }

    private ExecutionReport step(ProfiledDocument theDocument, String step) throws StepException {
        log.info("[Profile {}\u00a0] Invoking Step {} on ", new Object[]{this.profile.getId(), step, this.lfManager.getDescriptor()});
        StepExecutionRequest request = new StepExecutionRequest();
        request.setDocument(theDocument);
        request.setProfile(this.profile);
        request.setStep("@@@INIT_DOCUMENT@@");
        log.debug("Requesting Step Execution {}\u00a0", (Object)request);
        return this.lfManager.performStep(request);
    }
}

