/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.service.rest;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GuardedMethod<T> {
    private static final Logger log = LoggerFactory.getLogger(GuardedMethod.class);
    private static List<Runnable> preoperations = new ArrayList();
    private T result = null;

    public static void addPreoperation(Runnable preoperation) {
        preoperations.add(preoperation);
    }

    public GuardedMethod<T> execute() throws WebApplicationException {
        try {
            if (!preoperations.isEmpty()) {
                log.debug("Running preops (size : {} )", (Object)preoperations.size());
                for (Runnable r : preoperations) {
                    r.run();
                }
            }
            log.debug("Executing actual method..");
            this.result = this.run();
            return this;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Throwable t) {
            log.error("Unexpected error ", t);
            throw new WebApplicationException("Unexpected internal error", t, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    public T getResult() {
        return (T)this.result;
    }

    protected abstract T run() throws Exception, WebApplicationException;
}

