/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.service.engine.postgis;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.gcube.application.cms.implementations.ImplementationProvider;
import org.gcube.application.cms.serialization.Serialization;
import org.gcube.application.geoportal.common.model.legacy.Concessione;
import org.gcube.application.geoportal.common.model.rest.ConfigurationException;
import org.gcube.application.geoportal.common.model.rest.DatabaseConnection;
import org.gcube.application.geoportal.common.model.rest.PostgisIndexDescriptor;
import org.gcube.application.geoportal.service.engine.materialization.SDIManager;
import org.gcube.application.geoportal.service.engine.postgis.PostgisDBManager;
import org.gcube.application.geoportal.service.model.internal.db.DBConstants;
import org.gcube.application.geoportal.service.model.internal.db.PostgisTable;
import org.gcube.application.geoportal.service.model.internal.faults.PublishException;
import org.gcube.application.geoportal.service.model.internal.faults.SDIInteractionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class PostgisIndex {
    private static final Logger log = LoggerFactory.getLogger(PostgisIndex.class);
    private SDIManager sdiManager = new SDIManager();
    private String wmsLink = this.init();

    private static PostgisDBManager getDB() throws ConfigurationException {
        return (PostgisDBManager)ImplementationProvider.get().getProvidedObjectByClass(PostgisDBManager.class);
    }

    public PostgisIndexDescriptor getInfo() throws ConfigurationException, SDIInteractionException, SQLException {
        DatabaseConnection conn = PostgisIndex.getDB().getConnectionDescriptor();
        return new PostgisIndexDescriptor(conn, this.wmsLink);
    }

    protected PostgisTable getCentroidsTable() {
        return DBConstants.Concessioni.CENTROIDS;
    }

    public String init() throws SQLException, ConfigurationException, SDIInteractionException {
        log.debug("Contacting postgis DB .. ");
        PostgisDBManager db = PostgisIndex.getDB();
        log.debug("Checking if centroids table exists..");
        PostgisTable table = this.getCentroidsTable();
        db.create(table);
        db.commit();
        return this.sdiManager.configureCentroidLayer("centroids_concessioni", "gna", "gna_postgis", table, db.getConnectionDescriptor());
    }

    public void registerCentroid(Concessione record) throws PublishException {
        try {
            log.debug("Evaluating Centroid");
            Map centroidRow = PostgisIndex.evaluateCentroid((Concessione)record);
            log.debug("Contacting postgis DB .. ");
            PostgisDBManager db = PostgisIndex.getDB();
            PostgisTable centroidsTable = this.getCentroidsTable();
            log.debug("Inserting / updated centroid Row {} ", (Object)centroidRow);
            PreparedStatement ps = db.prepareInsertStatement(centroidsTable, true, true);
            log.debug("Deleting centroid if present. ID is " + record.getId());
            db.deleteByFieldValue(centroidsTable, new PostgisTable.Field("product_id", PostgisTable.FieldType.TEXT), (Object)record.getMongo_id());
            centroidsTable.fillCSVPreparedStatament(centroidRow, ps, false);
            ps.executeUpdate();
            db.commit();
        }
        catch (SQLException e) {
            log.warn("Unable to publish Centroid for record " + record, (Throwable)e);
            throw new PublishException("Unable to publish centroid.", (Throwable)e, null);
        }
        catch (ConfigurationException e) {
            log.warn("Unable to contact centroids db " + record.getRecordType(), (Throwable)e);
            throw new PublishException("Unable to publish centroid.", (Throwable)e, null);
        }
    }

    public void removeCentroid(Concessione record) {
        try {
            PostgisDBManager db = PostgisIndex.getDB();
            PostgisTable centroidsTable = this.getCentroidsTable();
            log.debug("Deleting centroid if present. ID is " + record.getMongo_id());
            int result = db.deleteByFieldValue(centroidsTable, new PostgisTable.Field("product_id", PostgisTable.FieldType.TEXT), (Object)record.getMongo_id());
            db.commit();
            log.info("Removed {} entries from gif Index with mongo id {} ", (Object)result, (Object)record.getMongo_id());
        }
        catch (Exception e) {
            log.warn("Unable to remove centroid ", (Throwable)e);
        }
    }

    protected static Map<String, String> evaluateCentroid(Concessione record) {
        HashMap<String, String> centroidsRow = new HashMap<String, String>();
        centroidsRow.put("product_id", record.getMongo_id());
        centroidsRow.put("anno", record.getDataInizioProgetto().getYear() + "");
        centroidsRow.put("nome", record.getNome());
        centroidsRow.put("regione", "");
        if (record.getCentroidLat() == null || record.getCentroidLat() == 0.0) {
            try {
                log.debug("Evaluating Centroid latitude for record " + record);
                record.setCentroidLat(Double.valueOf((record.getPosizionamentoScavo().getBbox().getMaxLat() + record.getPosizionamentoScavo().getBbox().getMinLat()) / 2.0));
            }
            catch (Throwable t) {
                log.warn("Unable to evaluate centroid latitude " + t);
            }
        }
        if (record.getCentroidLong() == null || record.getCentroidLong() == 0.0) {
            try {
                log.debug("Evaluating Centroid Longituted for record " + record);
                record.setCentroidLong(Double.valueOf((record.getPosizionamentoScavo().getBbox().getMaxLong() + record.getPosizionamentoScavo().getBbox().getMinLong()) / 2.0));
            }
            catch (Throwable t) {
                log.warn("Unable to evaluate centroid latitude " + t);
            }
        }
        centroidsRow.put("xcoord", record.getCentroidLong() + "");
        centroidsRow.put("ycoord", record.getCentroidLat() + "");
        centroidsRow.put("descrizione", record.getIntroduzione());
        centroidsRow.put("contenuto", record.getDescrizioneContenuto());
        centroidsRow.put("autore", PostgisIndex.asString((Collection)record.getAuthors()));
        centroidsRow.put("contributore", record.getContributore());
        centroidsRow.put("titolare", PostgisIndex.asString((Collection)record.getTitolari()));
        centroidsRow.put("responsabile", record.getResponsabile());
        centroidsRow.put("editore", record.getEditore());
        centroidsRow.put("finanziamento", PostgisIndex.asString((Collection)record.getFontiFinanziamento()));
        centroidsRow.put("soggetto", PostgisIndex.asString((Collection)record.getSoggetto()));
        centroidsRow.put("risorse", PostgisIndex.asString((Collection)record.getRisorseCorrelate()));
        centroidsRow.put("date_scavo", Serialization.FULL_FORMATTER.format(record.getDataFineProgetto()));
        centroidsRow.put("data_archiviazione", Serialization.FULL_FORMATTER.format(record.getLastUpdateTime()));
        centroidsRow.put("versione", record.getVersion());
        centroidsRow.put("licenza", record.getLicenzaID());
        centroidsRow.put("titolare_licenza", PostgisIndex.asString((Collection)record.getTitolareLicenza()));
        centroidsRow.put("accesso", record.getPolicy().toString());
        centroidsRow.put("parole_chiave", PostgisIndex.asString((Collection)record.getParoleChiaveLibere()));
        return centroidsRow;
    }

    private static String asString(Collection<?> coll) {
        if (coll == null || coll.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (Object t : coll) {
            builder.append(t.toString() + ",");
        }
        return builder.substring(0, builder.lastIndexOf(","));
    }

    static {
        try {
            Class.forName("org.postgresql.Driver");
            Class.forName("org.postgis.DriverWrapper");
        }
        catch (Exception var2) {
            throw new RuntimeException(var2);
        }
    }
}

