/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.service;

import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.ApplicationPath;
import org.gcube.application.cms.caches.Engine;
import org.gcube.application.cms.implementations.ImplementationProvider;
import org.gcube.application.cms.serialization.Serialization;
import org.gcube.application.geoportal.common.utils.StorageUtils;
import org.gcube.application.geoportal.service.engine.mongo.UCDManagerI;
import org.gcube.application.geoportal.service.engine.postgis.PostgisDBManager;
import org.gcube.application.geoportal.service.engine.providers.ConfigurationCache;
import org.gcube.application.geoportal.service.engine.providers.MongoClientProvider;
import org.gcube.application.geoportal.service.engine.providers.PluginManager;
import org.gcube.application.geoportal.service.engine.providers.PostgisConnectionProvider;
import org.gcube.application.geoportal.service.engine.providers.StorageClientProvider;
import org.gcube.application.geoportal.service.engine.providers.StorageHubProvider;
import org.gcube.application.geoportal.service.engine.providers.ucd.ProfileMap;
import org.gcube.application.geoportal.service.engine.providers.ucd.SingleISResourceUCDProvider;
import org.gcube.application.geoportal.service.engine.providers.ucd.UCDManager;
import org.gcube.application.geoportal.service.model.internal.db.Mongo;
import org.gcube.application.geoportal.service.rest.ConcessioniOverMongo;
import org.gcube.application.geoportal.service.rest.Plugins;
import org.gcube.application.geoportal.service.rest.ProfiledDocuments;
import org.gcube.application.geoportal.service.rest.UseCaseDescriptors;
import org.gcube.common.storagehub.client.dsl.StorageHubClient;
import org.glassfish.jersey.server.ResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationPath(value="/srv")
public class GeoPortalService
extends ResourceConfig {
    private static final Logger log = LoggerFactory.getLogger(GeoPortalService.class);

    public <T> Map<Engine<T>, Class<T>> customImplementations() {
        return Collections.EMPTY_MAP;
    }

    public GeoPortalService() {
        this.registerClasses(new Class[]{ConcessioniOverMongo.class});
        this.registerClasses(new Class[]{ProfiledDocuments.class});
        this.registerClasses(new Class[]{UseCaseDescriptors.class});
        this.registerClasses(new Class[]{Plugins.class});
        log.info("Setting implementations .. ");
        ImplementationProvider.get().setEngine((Engine)new MongoClientProvider(), Mongo.class);
        ImplementationProvider.get().setEngine((Engine)new StorageClientProvider(), StorageUtils.class);
        ImplementationProvider.get().setEngine((Engine)new PostgisConnectionProvider(), PostgisDBManager.class);
        ImplementationProvider.get().setEngine((Engine)new SingleISResourceUCDProvider(), ProfileMap.class);
        ImplementationProvider.get().setEngine((Engine)new PluginManager(), PluginManager.PluginMap.class);
        ImplementationProvider.get().setEngine((Engine)new StorageHubProvider(), StorageHubClient.class);
        ImplementationProvider.get().setEngine((Engine)new UCDManager(), UCDManagerI.class);
        ImplementationProvider.get().setEngine((Engine)new ConfigurationCache(), ConfigurationCache.ConfigurationMap.class);
        for (Map.Entry entry : this.customImplementations().entrySet()) {
            log.warn("LOADING CUSTOM ENGINE : {} serving {}", entry.getKey(), entry.getValue());
            ImplementationProvider.get().setEngine((Engine)entry.getKey(), (Class)entry.getValue());
        }
        log.debug("ENGINES ARE : ");
        ImplementationProvider.get().getManagerList().forEach((aClass, s) -> log.debug("{} serving {} ", aClass, s));
        ImplementationProvider.get().initEngines();
        log.info("Initializing serialization");
        JacksonJaxbJsonProvider provider = new JacksonJaxbJsonProvider();
        provider.setMapper(Serialization.mapper);
        this.register((Object)provider);
    }
}

