/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import org.gcube.application.geoportal.model.Record;

public class Serialization {
    private static ObjectMapper mapper = new ObjectMapper();
    private static ObjectMapper prettyMapper;
    public static final DateTimeFormatter FULL_FORMATTER;

    public static final <T extends Record> String asJSON(T toSerialize) throws JsonProcessingException {
        return mapper.writeValueAsString(toSerialize);
    }

    public static final <T extends Record> T readObject(String jsonString, Class<T> clazz) throws JsonParseException, JsonMappingException, IOException {
        return (T)((Record)mapper.readValue(jsonString, clazz));
    }

    public static final String prettyPrint(Object toSerialize) throws JsonProcessingException {
        return prettyMapper.writeValueAsString(toSerialize);
    }

    public static String asString(Collection<?> coll) {
        if (coll == null || coll.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (Object t : coll) {
            builder.append(t.toString() + ",");
        }
        return builder.substring(0, builder.lastIndexOf(","));
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS, true);
        mapper.registerModule((Module)new JavaTimeModule());
        prettyMapper = new ObjectMapper();
        prettyMapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        prettyMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        prettyMapper.configure(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS, false);
        prettyMapper.registerModule((Module)new JavaTimeModule());
        FULL_FORMATTER = DateTimeFormatter.ofPattern("uuuuMMdd_HH-mm-ss");
    }
}

