/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.storage;

import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.application.geoportal.model.InputStreamDescriptor;
import org.gcube.application.geoportal.model.Record;
import org.gcube.application.geoportal.model.concessioni.Concessione;
import org.gcube.application.geoportal.model.concessioni.LayerConcessione;
import org.gcube.application.geoportal.model.concessioni.RelazioneScavo;
import org.gcube.application.geoportal.model.content.AssociatedContent;
import org.gcube.application.geoportal.model.content.GeoServerContent;
import org.gcube.application.geoportal.model.content.OtherContent;
import org.gcube.application.geoportal.model.content.PersistedContent;
import org.gcube.application.geoportal.model.content.UploadedImage;
import org.gcube.application.geoportal.model.content.WorkspaceContent;
import org.gcube.application.geoportal.model.fault.PersistenceException;
import org.gcube.application.geoportal.model.fault.SDIInteractionException;
import org.gcube.application.geoportal.model.gis.SDILayerDescriptor;
import org.gcube.application.geoportal.model.report.PublicationReport;
import org.gcube.application.geoportal.model.report.ValidationReport;
import org.gcube.application.geoportal.storage.SDIManager;
import org.gcube.application.geoportal.storage.TempFile;
import org.gcube.application.geoportal.storage.WorkspaceManager;
import org.gcube.common.storagehub.client.dsl.FolderContainer;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.data.transfer.library.faults.RemoteServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentHandler<T extends Record> {
    private static final Logger log = LoggerFactory.getLogger(ContentHandler.class);
    private Map<AssociatedContent, ArrayList<TempFile>> uploadedResources = new HashMap<AssociatedContent, ArrayList<TempFile>>();
    private Map<AssociatedContent, ArrayList<TempFile>> toDeleteResources = new HashMap<AssociatedContent, ArrayList<TempFile>>();
    private ArrayList<TempFile> toDeleteTemps = new ArrayList();
    private T record;

    public ContentHandler(T record) {
        this.record = record;
    }

    public void register(AssociatedContent content, InputStreamDescriptor ... iss) throws IOException {
        ArrayList<TempFile> tempFiles = new ArrayList<TempFile>();
        for (InputStreamDescriptor is : iss) {
            tempFiles.add(new TempFile(org.gcube.application.geoportal.utils.Files.copyToTemp(is.getStream()), is.getFilename()));
        }
        this.toDeleteTemps.addAll(tempFiles);
        this.uploadedResources.put(content, tempFiles);
    }

    public void unregister(AssociatedContent content, InputStreamDescriptor ... iss) {
    }

    public void dispose(AssociatedContent content) throws StorageHubException, SDIInteractionException, IllegalArgumentException, MalformedURLException, RemoteServiceException {
        log.debug("Deleting Content " + content);
        WorkspaceManager wsManager = null;
        SDIManager sdiManager = null;
        for (PersistedContent p : content.getActualContent()) {
            if (p instanceof WorkspaceContent) {
                if (wsManager == null) {
                    wsManager = new WorkspaceManager((Record)this.record);
                }
                wsManager.deleteFromWS((WorkspaceContent)p);
                continue;
            }
            if (!(p instanceof GeoServerContent)) continue;
            if (sdiManager == null) {
                sdiManager = new SDIManager();
            }
            sdiManager.deleteContent((GeoServerContent)p);
        }
    }

    public void disposeQuietly(AssociatedContent content) {
        try {
            this.dispose(content);
        }
        catch (IllegalArgumentException | MalformedURLException | SDIInteractionException | StorageHubException | RemoteServiceException e) {
            log.warn("Unable to delete content " + content, e);
        }
    }

    public PublicationReport publish() {
        log.debug("Publishing " + ((Record)this.record).getNome());
        PublicationReport toReturn = new PublicationReport("Publish report");
        try {
            SDIManager sdiManager = new SDIManager();
            ArrayList<LayerConcessione> list = new ArrayList<LayerConcessione>();
            Concessione conc = (Concessione)this.record;
            String workspace = sdiManager.createWorkspace("gna_conc_" + ((Record)this.record).getId());
            list.add(conc.getPosizionamentoScavo());
            list.addAll(conc.getPianteFineScavo());
            for (AssociatedContent associatedContent : list) {
                if (!(associatedContent instanceof LayerConcessione)) continue;
                try {
                    List<PersistedContent> p = associatedContent.getActualContent();
                    GeoServerContent geoserverPersisted = sdiManager.pushShapeLayerFileSet((SDILayerDescriptor)associatedContent, workspace);
                    geoserverPersisted.setAssociated(associatedContent);
                    p.add(geoserverPersisted);
                    associatedContent.setActualContent(p);
                }
                catch (SDIInteractionException e) {
                    log.warn("Unable to publish layers.", (Throwable)e);
                    toReturn.addMessage(ValidationReport.ValidationStatus.WARNING, "Layer " + associatedContent.getTitolo() + " non pubblicato.");
                }
                toReturn.addMessage(ValidationReport.ValidationStatus.PASSED, "Pubblicato layer " + associatedContent.getTitolo());
            }
        }
        catch (SDIInteractionException e1) {
            toReturn.addMessage(ValidationReport.ValidationStatus.WARNING, "Unable to publish layers " + e1.getMessage());
        }
        return toReturn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PublicationReport storeChanges() throws PersistenceException {
        log.debug("Starting to persist " + this.uploadedResources.size() + " resources " + ((Record)this.record).getNome());
        PublicationReport toReturn = new PublicationReport("Storage report");
        try {
            WorkspaceManager wsManager = new WorkspaceManager((Record)this.record);
            for (Map.Entry<AssociatedContent, ArrayList<TempFile>> entry : this.uploadedResources.entrySet()) {
                AssociatedContent content = entry.getKey();
                ArrayList<PersistedContent> persisted = new ArrayList<PersistedContent>();
                FolderContainer destination = null;
                String description = null;
                log.debug("Storing " + content);
                if (content instanceof RelazioneScavo) {
                    destination = wsManager.getSubFolder("relazione");
                    description = "Relazione di scavo : " + content.getTitolo();
                } else if (content instanceof UploadedImage) {
                    destination = wsManager.getSubFolder("imgs");
                    description = "Immagine significativa : " + content.getTitolo();
                } else if (content instanceof SDILayerDescriptor) {
                    if (!(content instanceof LayerConcessione)) throw new Exception("Invalid SDI Content " + content);
                    destination = wsManager.getSubFolder("layers/" + content.getTitolo());
                    description = "Layer concessione : " + content.getTitolo();
                } else {
                    if (!(content instanceof OtherContent)) throw new Exception("Invalid content " + content);
                    destination = wsManager.getSubFolder("other/" + content.getTitolo());
                    description = "Other content : " + content.getTitolo();
                }
                log.debug("Actually Storing files to WS folder " + destination.getId());
                for (TempFile theFile : entry.getValue()) {
                    WorkspaceContent wsContent = wsManager.storeToWS(theFile.getTheFile(), destination, theFile.getOriginalFileName(), description);
                    wsContent.setAssociated(content);
                    persisted.add(wsContent);
                }
                toReturn.addMessage(ValidationReport.ValidationStatus.PASSED, "Registrati " + entry.getValue().size() + " elementi in archivio per : " + content.getTitolo());
                content.setActualContent(persisted);
            }
            return toReturn;
        }
        catch (StorageHubException e) {
            toReturn.addMessage(ValidationReport.ValidationStatus.ERROR, "Impossibile archiviare.");
            log.error("Unexpected SGHUB Exception", (Throwable)e);
            throw new PersistenceException("Unexpected Exception", e, toReturn);
        }
        catch (Throwable t) {
            toReturn.addMessage(ValidationReport.ValidationStatus.ERROR, "Errore inatteso.");
            throw new PersistenceException("Unexpected Exception", t, toReturn);
        }
    }

    protected void finalize() throws Throwable {
        for (TempFile f : this.toDeleteTemps) {
            Files.deleteIfExists(f.getTheFile().toPath());
        }
    }

    public ValidationReport validateContent() {
        return null;
    }
}

